/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;

public abstract class Try<T> {
    private Try() {
    }

    public static <U> Try<U> ofFailable(Callable<U> failable) {
        try {
            return Try.successful(failable.call());
        }
        catch (Exception e) {
            return Try.failure(e);
        }
    }

    public static <U> Try<U> successful(U result) {
        return new Success<U>(result);
    }

    public static <U> Try<U> failure(Throwable failure) {
        return new Failure(failure);
    }

    public abstract boolean isSuccessful();

    public abstract T get();

    public abstract T getOrMapFailure(Function<Throwable, T> var1);

    public abstract Optional<Throwable> getFailure();

    public abstract <U> Try<U> flatMap(Function<? super T, Try<U>> var1);

    public abstract <U> Try<U> map(Function<? super T, U> var1);

    public abstract <U> Try<U> tryMap(Function<? super T, U> var1);

    public abstract Try<T> mapFailure(Function<Throwable, Throwable> var1);

    public abstract void ifSuccessful(Consumer<T> var1);

    public abstract void ifSuccessfulOrElse(Consumer<? super T> var1, Consumer<? super Throwable> var2);

    private static final class Failure<T>
    extends Try<T> {
        private final Throwable failure;

        public Failure(Throwable failure) {
            this.failure = failure;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public T get() {
            throw UncheckedException.throwAsUncheckedException((Throwable)this.failure);
        }

        @Override
        public T getOrMapFailure(Function<Throwable, T> f) {
            return f.apply(this.failure);
        }

        @Override
        public Optional<Throwable> getFailure() {
            return Optional.of(this.failure);
        }

        @Override
        public <U> Try<U> flatMap(Function<? super T, Try<U>> f) {
            return (Try)Cast.uncheckedNonnullCast((Object)this);
        }

        @Override
        public <U> Try<U> map(Function<? super T, U> f) {
            return (Try)Cast.uncheckedNonnullCast((Object)this);
        }

        @Override
        public <U> Try<U> tryMap(Function<? super T, U> f) {
            return (Try)Cast.uncheckedNonnullCast((Object)this);
        }

        @Override
        public Try<T> mapFailure(Function<Throwable, Throwable> f) {
            return Try.failure(f.apply(this.failure));
        }

        @Override
        public void ifSuccessful(Consumer<T> consumer) {
        }

        @Override
        public void ifSuccessfulOrElse(Consumer<? super T> successConsumer, Consumer<? super Throwable> failureConsumer) {
            failureConsumer.accept(this.failure);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Failure failure1 = (Failure)o;
            return this.failure.equals(failure1.failure);
        }

        public int hashCode() {
            return this.failure.hashCode();
        }

        public String toString() {
            return "Failed(" + this.failure + ")";
        }
    }

    private static final class Success<T>
    extends Try<T> {
        private final T value;

        public Success(T value) {
            this.value = value;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T getOrMapFailure(Function<Throwable, T> f) {
            return this.value;
        }

        @Override
        public Optional<Throwable> getFailure() {
            return Optional.empty();
        }

        @Override
        public <U> Try<U> flatMap(Function<? super T, Try<U>> f) {
            return f.apply(this.value);
        }

        @Override
        public <U> Try<U> map(Function<? super T, U> f) {
            return Try.successful(f.apply(this.value));
        }

        @Override
        public <U> Try<U> tryMap(Function<? super T, U> f) {
            return Try.ofFailable(() -> f.apply((T)this.value));
        }

        @Override
        public Try<T> mapFailure(Function<Throwable, Throwable> f) {
            return this;
        }

        @Override
        public void ifSuccessful(Consumer<T> consumer) {
            consumer.accept(this.value);
        }

        @Override
        public void ifSuccessfulOrElse(Consumer<? super T> successConsumer, Consumer<? super Throwable> failureConsumer) {
            successConsumer.accept(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Success success = (Success)o;
            return this.value.equals(success.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Successful(" + this.value + ")";
        }
    }
}

