/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAssignmentTypeMismatchChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirAssignmentTypeMismatchChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirAssignmentTypeMismatchChecker INSTANCE = new FirAssignmentTypeMismatchChecker();

    private FirAssignmentTypeMismatchChecker() {
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirExpression rValue = expression2.getRValue();
        if (FirTypeUtilsKt.isNullLiteral(rValue)) {
            FirPropertySymbol firPropertySymbol;
            FirReference firReference = expression2.getLValue();
            FirResolvedNamedReference firResolvedNamedReference = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
            Object object = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
            FirPropertySymbol firPropertySymbol2 = firPropertySymbol = object instanceof FirPropertySymbol ? (FirPropertySymbol)object : null;
            FirTypeRef leftType = firPropertySymbol == null ? null : ((object = (FirProperty)firPropertySymbol.getFir()) == null ? null : ((FirProperty)object).getReturnTypeRef());
            if (((firPropertySymbol = leftType) == null ? null : ((object = FirTypeUtilsKt.getConeType((FirTypeRef)((Object)firPropertySymbol))) == null ? null : ((ConeKotlinType)object).getNullability())) == ConeNullability.NOT_NULL) {
                DiagnosticReporterKt.reportOn(reporter, rValue.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), context2);
            }
        }
    }
}

