/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.compiler.java;

import com.sun.source.util.JavacTask;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import org.gradle.internal.compiler.java.listeners.classnames.ClassNameCollector;
import org.gradle.internal.compiler.java.listeners.constants.ConstantDependentsConsumer;
import org.gradle.internal.compiler.java.listeners.constants.ConstantsCollector;

public class IncrementalCompileTask
implements JavaCompiler.CompilationTask {
    private final Function<File, Optional<String>> relativize;
    private final Consumer<Map<String, Set<String>>> classNameConsumer;
    private final ConstantDependentsConsumer constantDependentsConsumer;
    private final JavacTask delegate;

    public IncrementalCompileTask(JavaCompiler.CompilationTask delegate, Function<File, Optional<String>> relativize, Consumer<Map<String, Set<String>>> classNamesConsumer, BiConsumer<String, String> publicDependentDelegate, BiConsumer<String, String> privateDependentDelegate) {
        this.relativize = relativize;
        this.classNameConsumer = classNamesConsumer;
        this.constantDependentsConsumer = new ConstantDependentsConsumer(publicDependentDelegate, privateDependentDelegate);
        if (!(delegate instanceof JavacTask)) {
            throw new UnsupportedOperationException("Unexpected Java compile task : " + delegate.getClass().getName());
        }
        this.delegate = (JavacTask)delegate;
    }

    @Override
    public void addModules(Iterable<String> moduleNames) {
        this.delegate.addModules(moduleNames);
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        this.delegate.setProcessors(processors);
    }

    @Override
    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        ClassNameCollector classNameCollector = new ClassNameCollector(this.relativize, this.delegate.getElements());
        ConstantsCollector constantsCollector = new ConstantsCollector(this.delegate, this.constantDependentsConsumer);
        this.delegate.addTaskListener(classNameCollector);
        this.delegate.addTaskListener(constantsCollector);
        try {
            Boolean bl = this.delegate.call();
            return bl;
        }
        finally {
            this.classNameConsumer.accept(classNameCollector.getMapping());
        }
    }
}

