/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.BuildLayoutValidator;
import org.gradle.internal.buildtree.BuildActionModelRequirements;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeModelControllerServices;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.RunTasksRequirements;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.launcher.exec.AbstractToolingModelRequirements;
import org.gradle.launcher.exec.QueryModelRequirements;
import org.gradle.launcher.exec.RunActionRequirements;
import org.gradle.launcher.exec.RunPhasedActionRequirements;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedPhasedAction;

public class BuildTreeLifecycleBuildActionExecutor
implements BuildSessionActionExecutor {
    private final BuildTreeModelControllerServices buildTreeModelControllerServices;
    private final BuildLayoutValidator buildLayoutValidator;

    public BuildTreeLifecycleBuildActionExecutor(BuildTreeModelControllerServices buildTreeModelControllerServices, BuildLayoutValidator buildLayoutValidator) {
        this.buildTreeModelControllerServices = buildTreeModelControllerServices;
        this.buildLayoutValidator = buildLayoutValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result execute(BuildAction action, BuildSessionContext buildSession) {
        BuildActionRunner.Result result = null;
        try {
            AbstractToolingModelRequirements actionRequirements;
            this.buildLayoutValidator.validate(action.getStartParameter());
            if (action instanceof BuildModelAction && action.isCreateModel()) {
                BuildModelAction buildModelAction = (BuildModelAction)action;
                actionRequirements = new QueryModelRequirements(action.getStartParameter(), action.isRunTasks(), buildModelAction.getModelName());
            } else {
                actionRequirements = action instanceof ClientProvidedBuildAction ? new RunActionRequirements(action.getStartParameter(), action.isRunTasks()) : (action instanceof ClientProvidedPhasedAction ? new RunPhasedActionRequirements(action.getStartParameter(), false) : new RunTasksRequirements(action.getStartParameter()));
            }
            BuildTreeModelControllerServices.Supplier modelServices = this.buildTreeModelControllerServices.servicesForBuildTree((BuildActionModelRequirements)actionRequirements);
            try (BuildTreeState buildTree = new BuildTreeState(buildSession.getServices(), modelServices);){
                result = (BuildActionRunner.Result)buildTree.run(context -> context.execute(action));
            }
        }
        catch (Throwable t) {
            if (result == null) {
                throw UncheckedException.throwAsUncheckedException(t);
            }
            throw UncheckedException.throwAsUncheckedException(result.addFailure(t).getBuildFailure());
        }
        return result;
    }
}

