/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.KnownImplementationSnapshot;
import org.gradle.internal.snapshot.impl.LambdaImplementationSnapshot;
import org.gradle.internal.snapshot.impl.UnknownClassloaderImplementationSnapshot;

public class ImplementationSnapshotSerializer
implements Serializer<ImplementationSnapshot> {
    public ImplementationSnapshot read(Decoder decoder) throws Exception {
        Impl serializer = Impl.values()[decoder.readSmallInt()];
        return serializer.read(decoder);
    }

    public void write(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
        Impl serializer = ImplementationSnapshotSerializer.determineSerializer(implementationSnapshot);
        encoder.writeSmallInt(serializer.ordinal());
        serializer.write(encoder, implementationSnapshot);
    }

    private static Impl determineSerializer(ImplementationSnapshot implementationSnapshot) {
        if (implementationSnapshot instanceof KnownImplementationSnapshot) {
            return Impl.DEFAULT;
        }
        if (implementationSnapshot instanceof UnknownClassloaderImplementationSnapshot) {
            return Impl.UNKNOWN_CLASSLOADER;
        }
        if (implementationSnapshot instanceof LambdaImplementationSnapshot) {
            return Impl.LAMBDA;
        }
        throw new IllegalArgumentException("Unknown implementation snapshot type: " + implementationSnapshot.getClass().getName());
    }

    private static enum Impl implements Serializer<ImplementationSnapshot>
    {
        DEFAULT{

            @Override
            protected ImplementationSnapshot doRead(String typeName, Decoder decoder) throws Exception {
                HashCode classLoaderHash = (HashCode)this.hashCodeSerializer.read(decoder);
                return new KnownImplementationSnapshot(typeName, classLoaderHash);
            }

            @Override
            public void writeAdditionalData(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
                this.hashCodeSerializer.write(encoder, (Object)implementationSnapshot.getClassLoaderHash());
            }
        }
        ,
        UNKNOWN_CLASSLOADER{

            @Override
            protected ImplementationSnapshot doRead(String typeName, Decoder decoder) {
                return new UnknownClassloaderImplementationSnapshot(typeName);
            }
        }
        ,
        LAMBDA{

            @Override
            protected ImplementationSnapshot doRead(String typeName, Decoder decoder) {
                return new LambdaImplementationSnapshot(typeName);
            }
        };

        protected final Serializer<HashCode> hashCodeSerializer = new HashCodeSerializer();

        public void write(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
            encoder.writeString((CharSequence)implementationSnapshot.getTypeName());
            this.writeAdditionalData(encoder, implementationSnapshot);
        }

        public ImplementationSnapshot read(Decoder decoder) throws Exception {
            String typeName = decoder.readString();
            return this.doRead(typeName, decoder);
        }

        protected abstract ImplementationSnapshot doRead(String var1, Decoder var2) throws Exception;

        protected void writeAdditionalData(Encoder encoder, ImplementationSnapshot implementationSnapshot) throws Exception {
        }
    }
}

