/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import javax.annotation.Nullable;
import org.gradle.internal.build.BuildToolingModelAction;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.runner.BuildControllerFactory;
import org.gradle.tooling.internal.provider.runner.DefaultBuildController;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public abstract class AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    private final BuildControllerFactory buildControllerFactory;
    private final PayloadSerializer payloadSerializer;

    public AbstractClientProvidedBuildActionRunner(BuildControllerFactory buildControllerFactory, PayloadSerializer payloadSerializer) {
        this.buildControllerFactory = buildControllerFactory;
        this.payloadSerializer = payloadSerializer;
    }

    protected BuildActionRunner.Result runClientAction(ClientAction action, BuildTreeLifecycleController buildController) {
        ActionAdapter adapter = new ActionAdapter(action, this.payloadSerializer);
        try {
            ActionResults actionResults = (ActionResults)buildController.fromBuildModel(action.isRunTasks(), (BuildToolingModelAction)adapter);
            adapter.maybeApplyResult(actionResults);
            return BuildActionRunner.Result.of((Object)action.getResult());
        }
        catch (RuntimeException e) {
            RuntimeException clientFailure = e;
            if (adapter.actionFailure != null) {
                clientFailure = new InternalBuildActionFailureException((Throwable)adapter.actionFailure);
            }
            return BuildActionRunner.Result.failed((Throwable)e, (RuntimeException)clientFailure);
        }
    }

    private class ActionAdapter
    implements BuildToolingModelAction<ActionResults> {
        private final ClientAction clientAction;
        private final PayloadSerializer payloadSerializer;
        SerializedPayload projectsEvaluatedResult;
        SerializedPayload buildFinishedResult;
        RuntimeException actionFailure;
        boolean executed;

        ActionAdapter(ClientAction clientAction, PayloadSerializer payloadSerializer) {
            this.clientAction = clientAction;
            this.payloadSerializer = payloadSerializer;
        }

        public void beforeTasks(BuildToolingModelController controller) {
            this.projectsEvaluatedResult = this.runAction(controller, this.clientAction.getProjectsEvaluatedAction(), PhasedActionResult.Phase.PROJECTS_LOADED);
        }

        public ActionResults fromBuildModel(BuildToolingModelController controller) {
            this.buildFinishedResult = this.runAction(controller, this.clientAction.getBuildFinishedAction(), PhasedActionResult.Phase.BUILD_FINISHED);
            this.executed = true;
            return new ActionResults(this.projectsEvaluatedResult, this.buildFinishedResult);
        }

        public void maybeApplyResult(ActionResults actionResults) {
            if (this.executed) {
                return;
            }
            if (actionResults.projectsLoadedResult != null) {
                this.clientAction.collectActionResult(actionResults.projectsLoadedResult, PhasedActionResult.Phase.PROJECTS_LOADED);
            }
            if (actionResults.buildFinishedResult != null) {
                this.clientAction.collectActionResult(actionResults.buildFinishedResult, PhasedActionResult.Phase.BUILD_FINISHED);
            }
        }

        private SerializedPayload runAction(BuildToolingModelController controller, @Nullable Object action, PhasedActionResult.Phase phase) {
            if (action == null || this.actionFailure != null) {
                return null;
            }
            DefaultBuildController internalBuildController = AbstractClientProvidedBuildActionRunner.this.buildControllerFactory.controllerFor(controller);
            try {
                Object result = action instanceof InternalBuildActionVersion2 ? ((InternalBuildActionVersion2)action).execute((InternalBuildControllerVersion2)internalBuildController) : ((InternalBuildAction)action).execute((InternalBuildController)internalBuildController);
                SerializedPayload serializedResult = this.payloadSerializer.serialize(result);
                this.clientAction.collectActionResult(serializedResult, phase);
                return serializedResult;
            }
            catch (RuntimeException e) {
                this.actionFailure = e;
                throw e;
            }
        }
    }

    private static class ActionResults {
        @Nullable
        final SerializedPayload projectsLoadedResult;
        @Nullable
        final SerializedPayload buildFinishedResult;

        ActionResults(@Nullable SerializedPayload projectsLoadedResult, @Nullable SerializedPayload buildFinishedResult) {
            this.projectsLoadedResult = projectsLoadedResult;
            this.buildFinishedResult = buildFinishedResult;
        }
    }

    protected static interface ClientAction {
        @Nullable
        public Object getProjectsEvaluatedAction();

        @Nullable
        public Object getBuildFinishedAction();

        public void collectActionResult(SerializedPayload var1, PhasedActionResult.Phase var2);

        @Nullable
        public SerializedPayload getResult();

        public boolean isRunTasks();
    }
}

