/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.CacheableInvocation;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvocationFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Try;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationStep
implements Transformation,
TaskDependencyContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationStep.class);
    private final Transformer transformer;
    private final TransformerInvocationFactory transformerInvocationFactory;
    private final ProjectInternal owningProject;
    private final InputFingerprinter globalInputFingerprinter;

    public TransformationStep(Transformer transformer, TransformerInvocationFactory transformerInvocationFactory, DomainObjectContext owner, InputFingerprinter globalInputFingerprinter) {
        this.transformer = transformer;
        this.transformerInvocationFactory = transformerInvocationFactory;
        this.globalInputFingerprinter = globalInputFingerprinter;
        this.owningProject = owner.getProject();
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    @Nullable
    public ProjectInternal getOwningProject() {
        return this.owningProject;
    }

    @Override
    public boolean endsWith(Transformation otherTransform) {
        return this == otherTransform;
    }

    @Override
    public int stepsCount() {
        return 1;
    }

    public CacheableInvocation<TransformationSubject> createInvocation(TransformationSubject subjectToTransform, TransformUpstreamDependencies upstreamDependencies, @Nullable NodeExecutionContext context) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transforming {} with {}", (Object)subjectToTransform.getDisplayName(), (Object)this.transformer.getDisplayName());
        }
        InputFingerprinter inputFingerprinter = context != null ? (InputFingerprinter)context.getService(InputFingerprinter.class) : this.globalInputFingerprinter;
        Try<ArtifactTransformDependencies> resolvedDependencies = upstreamDependencies.computeArtifacts();
        return (CacheableInvocation)resolvedDependencies.map(dependencies -> {
            ImmutableList<File> inputArtifacts = subjectToTransform.getFiles();
            if (inputArtifacts.isEmpty()) {
                return CacheableInvocation.cached(Try.successful((Object)subjectToTransform.createSubjectFromResult((ImmutableList<File>)ImmutableList.of())));
            }
            if (inputArtifacts.size() > 1) {
                return CacheableInvocation.nonCached(() -> this.doTransform(subjectToTransform, inputFingerprinter, (ArtifactTransformDependencies)dependencies, inputArtifacts));
            }
            File inputArtifact = (File)inputArtifacts.get(0);
            return this.transformerInvocationFactory.createInvocation(this.transformer, inputArtifact, (ArtifactTransformDependencies)dependencies, subjectToTransform, inputFingerprinter).map(subjectToTransform::createSubjectFromResult);
        }).getOrMapFailure(failure -> CacheableInvocation.cached(Try.failure((Throwable)failure)));
    }

    private Try<TransformationSubject> doTransform(TransformationSubject subjectToTransform, InputFingerprinter inputFingerprinter, ArtifactTransformDependencies dependencies, ImmutableList<File> inputArtifacts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (File inputArtifact : inputArtifacts) {
            Try<ImmutableList<File>> result = this.transformerInvocationFactory.createInvocation(this.transformer, inputArtifact, dependencies, subjectToTransform, inputFingerprinter).invoke();
            if (result.getFailure().isPresent()) {
                return Try.failure((Throwable)((Throwable)result.getFailure().get()));
            }
            builder.addAll((Iterable)result.get());
        }
        return Try.successful((Object)subjectToTransform.createSubjectFromResult((ImmutableList<File>)builder.build()));
    }

    public void isolateParametersIfNotAlready() {
        this.transformer.isolateParametersIfNotAlready();
    }

    @Override
    public boolean requiresDependencies() {
        return this.transformer.requiresDependencies();
    }

    public String getDisplayName() {
        return this.transformer.getDisplayName();
    }

    @Override
    public void visitTransformationSteps(Action<? super TransformationStep> action) {
        action.execute((Object)this);
    }

    public ImmutableAttributes getFromAttributes() {
        return this.transformer.getFromAttributes();
    }

    public String toString() {
        return this.transformer.getDisplayName();
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.transformer.visitDependencies(context);
    }
}

