/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableModuleComponentMetaDataResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableModuleComponentMetaDataResolveResult {
    private BuildableModuleComponentMetaDataResolveResult.State state = BuildableModuleComponentMetaDataResolveResult.State.Unknown;
    private ModuleVersionResolveException failure;
    private ModuleComponentResolveMetadata metaData;
    private boolean authoritative;

    private void reset(BuildableModuleComponentMetaDataResolveResult.State state) {
        this.state = state;
        this.metaData = null;
        this.failure = null;
        this.authoritative = false;
    }

    public void reset() {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Unknown);
    }

    @Override
    public void resolved(ModuleComponentResolveMetadata metaData) {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Resolved);
        this.metaData = metaData;
        this.authoritative = true;
    }

    @Override
    public void setMetadata(ModuleComponentResolveMetadata metaData) {
        this.assertResolved();
        this.metaData = metaData;
    }

    @Override
    public void missing() {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Missing);
        this.authoritative = true;
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Failed);
        this.failure = failure;
        this.authoritative = true;
    }

    @Override
    public BuildableModuleComponentMetaDataResolveResult.State getState() {
        return this.state;
    }

    @Override
    public boolean hasResult() {
        return this.state != BuildableModuleComponentMetaDataResolveResult.State.Unknown;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    @Override
    public ModuleComponentResolveMetadata getMetaData() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData;
    }

    @Override
    public boolean isAuthoritative() {
        this.assertHasResult();
        return this.authoritative;
    }

    @Override
    public void setAuthoritative(boolean authoritative) {
        this.assertHasResult();
        this.authoritative = authoritative;
    }

    @Override
    public void redirectToGradleMetadata() {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Redirect);
    }

    @Override
    public boolean shouldUseGradleMetatada() {
        return this.state == BuildableModuleComponentMetaDataResolveResult.State.Redirect;
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }

    private void assertResolved() {
        if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
            throw this.failure;
        }
        if (this.state != BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
            throw new IllegalStateException("This module has not been resolved.");
        }
    }
}

