/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildToolingModelAction;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.StateTransitionController;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeModelCreator;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.BuildTreeWorkPreparer;

public class DefaultBuildTreeLifecycleController
implements BuildTreeLifecycleController {
    private final StateTransitionController<State> state = new StateTransitionController<State>(State.NotStarted);
    private final BuildLifecycleController buildLifecycleController;
    private final IncludedBuildTaskGraph taskGraph;
    private final BuildTreeWorkPreparer workPreparer;
    private final BuildTreeWorkExecutor workExecutor;
    private final BuildTreeModelCreator modelCreator;
    private final BuildTreeFinishExecutor finishExecutor;

    public DefaultBuildTreeLifecycleController(BuildLifecycleController buildLifecycleController, IncludedBuildTaskGraph taskGraph, BuildTreeWorkPreparer workPreparer, BuildTreeWorkExecutor workExecutor, BuildTreeModelCreator modelCreator, BuildTreeFinishExecutor finishExecutor) {
        this.buildLifecycleController = buildLifecycleController;
        this.taskGraph = taskGraph;
        this.workPreparer = workPreparer;
        this.modelCreator = modelCreator;
        this.workExecutor = workExecutor;
        this.finishExecutor = finishExecutor;
    }

    @Override
    public void beforeBuild(Consumer<? super GradleInternal> action) {
        this.state.inState(State.NotStarted, () -> action.accept(this.buildLifecycleController.getGradle()));
    }

    @Override
    public void scheduleAndRunTasks() {
        this.runBuild(this::doScheduleAndRunTasks);
    }

    @Override
    public <T> T fromBuildModel(boolean runTasks, BuildToolingModelAction<? extends T> action) {
        return this.runBuild(() -> {
            ExecutionResult<Void> result;
            this.modelCreator.beforeTasks(action);
            if (runTasks && !(result = this.doScheduleAndRunTasks()).getFailures().isEmpty()) {
                return result.asFailure();
            }
            Object model = this.modelCreator.fromBuildModel(action);
            return ExecutionResult.succeeded(model);
        });
    }

    private ExecutionResult<Void> doScheduleAndRunTasks() {
        return this.taskGraph.withNewTaskGraph(() -> {
            this.workPreparer.scheduleRequestedTasks();
            return this.workExecutor.execute();
        });
    }

    @Override
    public <T> T withEmptyBuild(Function<? super SettingsInternal, T> action) {
        return this.runBuild(() -> {
            Object result = action.apply(this.buildLifecycleController.getLoadedSettings());
            return ExecutionResult.succeeded(result);
        });
    }

    private <T> T runBuild(Supplier<ExecutionResult<? extends T>> action) {
        return (T)this.state.transition(State.NotStarted, State.Complete, () -> {
            ExecutionResult result;
            try {
                result = (ExecutionResult)action.get();
            }
            catch (Throwable t) {
                result = ExecutionResult.failed(t);
            }
            RuntimeException finalReportableFailure = this.finishExecutor.finishBuildTree(result.getFailures());
            if (finalReportableFailure != null) {
                throw finalReportableFailure;
            }
            return result.getValue();
        });
    }

    private static enum State implements StateTransitionController.State
    {
        NotStarted,
        Complete;

    }
}

