/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

public class MappingProvider<OUT, IN>
extends AbstractMinimalProvider<OUT> {
    private final Class<OUT> type;
    private final ProviderInternal<? extends IN> provider;
    private final Transformer<? extends OUT, ? super IN> transformer;

    public MappingProvider(Class<OUT> type, ProviderInternal<? extends IN> provider, Transformer<? extends OUT, ? super IN> transformer) {
        this.type = type;
        this.provider = provider;
        this.transformer = transformer;
    }

    @Override
    @Nullable
    public Class<OUT> getType() {
        return this.type;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return this.provider.getProducer();
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return this.provider.calculatePresence(consumer);
    }

    @Override
    protected ValueSupplier.Value<OUT> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<IN> value = this.provider.calculateValue(consumer);
        if (value.isMissing()) {
            return value.asType();
        }
        return ValueSupplier.Value.of(this.transformer.transform(value.get()));
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends OUT> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue<IN> value = this.provider.calculateExecutionTimeValue();
        if (value.isChangingValue()) {
            return ValueSupplier.ExecutionTimeValue.changingValue(new MappingProvider<OUT, IN>(this.type, value.getChangingValue(), this.transformer));
        }
        if (value.isMissing()) {
            return ValueSupplier.ExecutionTimeValue.missing();
        }
        return ValueSupplier.ExecutionTimeValue.fixedValue(this.transformer.transform(value.getFixedValue()));
    }

    @Override
    public String toString() {
        return "map(" + this.type.getName() + " " + this.provider + " " + this.transformer + ")";
    }
}

