/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.SimplePluginResolution;

public class CorePluginResolver
implements PluginResolver {
    private final DocumentationRegistry documentationRegistry;
    private final PluginRegistry pluginRegistry;

    public CorePluginResolver(DocumentationRegistry documentationRegistry, PluginRegistry pluginRegistry) {
        this.documentationRegistry = documentationRegistry;
        this.pluginRegistry = pluginRegistry;
    }

    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) {
        PluginId id = pluginRequest.getId();
        if (!this.isCorePluginRequest(id)) {
            result.notFound(CorePluginResolver.getDescription(), String.format("plugin is not in '%s' namespace", "org.gradle"));
            return;
        }
        PluginImplementation plugin = this.pluginRegistry.lookup(id);
        if (plugin == null) {
            result.notFound(CorePluginResolver.getDescription(), String.format("not a core plugin, please see %s for available core plugins", this.documentationRegistry.getDocumentationFor("standard_plugins")));
            return;
        }
        this.validate(pluginRequest);
        result.found(CorePluginResolver.getDescription(), new SimplePluginResolution(plugin));
    }

    private void validate(PluginRequestInternal pluginRequest) {
        if (pluginRequest.getVersion() != null) {
            throw new InvalidPluginRequestException(pluginRequest, "Plugin '" + pluginRequest.getId() + "' is a core Gradle plugin, which cannot be specified with a version number. Such plugins are versioned as part of Gradle. Please remove the version number from the declaration.");
        }
        if (pluginRequest.getModule() != null) {
            throw new InvalidPluginRequestException(pluginRequest, "Plugin '" + pluginRequest.getId() + "' is a core Gradle plugin, which cannot be specified with a custom implementation artifact. Such plugins are versioned as part of Gradle. Please remove the custom artifact from the request.");
        }
        if (!pluginRequest.isApply()) {
            throw new InvalidPluginRequestException(pluginRequest, "Plugin '" + pluginRequest.getId() + "' is a core Gradle plugin, which is already on the classpath. Requesting it with the 'apply false' option is a no-op.");
        }
    }

    private boolean isCorePluginRequest(PluginId id) {
        String namespace = id.getNamespace();
        return namespace == null || namespace.equals("org.gradle");
    }

    public static String getDescription() {
        return "Gradle Core Plugins";
    }
}

