/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configurationcache.initialization.ConfigurationCacheProblemsListener;
import org.gradle.configurationcache.problems.DocumentationSection;
import org.gradle.configurationcache.problems.ProblemsListener;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.PropertyProblemKt;
import org.gradle.configurationcache.problems.PropertyTrace;
import org.gradle.configurationcache.problems.StructuredMessage;
import org.gradle.internal.DisplayName;
import org.gradle.internal.InternalListener;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gradle/configurationcache/initialization/DefaultConfigurationCacheProblemsListener;", "Lorg/gradle/configurationcache/initialization/ConfigurationCacheProblemsListener;", "problems", "Lorg/gradle/configurationcache/problems/ProblemsListener;", "userCodeApplicationContext", "Lorg/gradle/configuration/internal/UserCodeApplicationContext;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "(Lorg/gradle/configurationcache/problems/ProblemsListener;Lorg/gradle/configuration/internal/UserCodeApplicationContext;Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;)V", "atConfigurationTime", "", "isBuildSrcBuild", "invocationSource", "", "listenerRegistrationProblem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "trace", "Lorg/gradle/configurationcache/problems/PropertyTrace;", "invocationDescription", "", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "onBuildScopeListenerRegistration", "", "listener", "onProjectAccess", "task", "Lorg/gradle/api/internal/TaskInternal;", "onTaskDependenciesAccess", "onTaskExecutionAccessProblem", "propertyTraceForTask", "configuration-cache"})
public final class DefaultConfigurationCacheProblemsListener
implements ConfigurationCacheProblemsListener {
    private final ProblemsListener problems;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final ConfigurationTimeBarrier configurationTimeBarrier;

    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.atConfigurationTime()) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.atConfigurationTime()) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task) {
        this.problems.onProblem(new PropertyProblem(this.propertyTraceForTask(task), StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$receiver");
                $this$build.text("invocation of ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" at execution time is unsupported.");
            }
            {
                this.$invocationDescription = string2;
                super(1);
            }
        })), (Throwable)new InvalidUserCodeException("Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported."), DocumentationSection.RequirementsUseProjectDuringExecution));
    }

    private final PropertyTrace propertyTraceForTask(TaskInternal task) {
        PropertyTrace propertyTrace;
        UserCodeApplicationContext.Application application = this.userCodeApplicationContext.current();
        if (application != null && (application = application.getDisplayName()) != null) {
            UserCodeApplicationContext.Application application2 = application;
            boolean bl = false;
            boolean bl2 = false;
            UserCodeApplicationContext.Application p1 = application2;
            boolean bl3 = false;
            propertyTrace = new PropertyTrace.BuildLogic((DisplayName)p1);
        } else {
            Class clazz = GeneratedSubclasses.unpackType((Object)task);
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"GeneratedSubclasses.unpackType(task)");
            Path path = task.getIdentityPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"task.identityPath");
            String string2 = path.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.identityPath.path");
            propertyTrace = new PropertyTrace.Task(clazz, string2);
        }
        return propertyTrace;
    }

    public void onBuildScopeListenerRegistration(@NotNull Object listener, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)invocationSource, (String)"invocationSource");
        if (listener instanceof InternalListener || listener instanceof ProjectEvaluationListener || this.isBuildSrcBuild(invocationSource)) {
            return;
        }
        this.problems.onProblem(this.listenerRegistrationProblem(PropertyProblemKt.location(this.userCodeApplicationContext, null), invocationDescription, new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.")));
    }

    private final PropertyProblem listenerRegistrationProblem(PropertyTrace trace, String invocationDescription, InvalidUserCodeException exception) {
        return new PropertyProblem(trace, StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$receiver");
                $this$build.text("registration of listener on ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" is unsupported");
            }
            {
                this.$invocationDescription = string2;
                super(1);
            }
        })), (Throwable)exception, DocumentationSection.RequirementsBuildListeners);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBuildSrcBuild(Object invocationSource) {
        Object object = invocationSource;
        if (!(object instanceof GradleInternal)) {
            object = null;
        }
        GradleInternal gradleInternal = (GradleInternal)object;
        if (gradleInternal == null) return false;
        GradleInternal gradleInternal2 = gradleInternal;
        boolean bl = false;
        boolean bl2 = false;
        GradleInternal $this$run = gradleInternal2;
        boolean bl3 = false;
        if ($this$run.isRootBuild()) return false;
        Path path = $this$run.getIdentityPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"identityPath");
        if (!Intrinsics.areEqual((Object)path.getName(), (Object)"buildSrc")) return false;
        return true;
    }

    private final boolean atConfigurationTime() {
        return this.configurationTimeBarrier.isAtConfigurationTime();
    }

    public DefaultConfigurationCacheProblemsListener(@NotNull ProblemsListener problems, @NotNull UserCodeApplicationContext userCodeApplicationContext, @NotNull ConfigurationTimeBarrier configurationTimeBarrier) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)userCodeApplicationContext, (String)"userCodeApplicationContext");
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        this.problems = problems;
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.configurationTimeBarrier = configurationTimeBarrier;
    }
}

