/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkUsageOfKotlinExperimentalOrUseExperimental", "element", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "checkers"})
public final class FirOptInAnnotationCallChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirOptInAnnotationCallChecker INSTANCE = new FirOptInAnnotationCallChecker();

    private FirOptInAnnotationCallChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirTypeRef $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag = (object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : ((ConeClassLikeType)object).getLookupTag();
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag lookupTag = coneClassLikeLookupTag;
        object = lookupTag.getClassId().asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lookupTag.classId.asSingleFqName()");
        Object fqName2 = object;
        boolean isMarker = Intrinsics.areEqual((Object)fqName2, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME());
        boolean isOptIn = Intrinsics.areEqual((Object)fqName2, (Object)OptInNames.INSTANCE.getOPT_IN_FQ_NAME());
        if (isMarker || isOptIn) {
            this.checkUsageOfKotlinExperimentalOrUseExperimental(expression2.getSource(), context2, reporter);
            if (isOptIn) {
                FirCall $this$arguments$iv = expression2;
                boolean $i$f$getArguments = false;
                List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments2.isEmpty()) {
                    DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getUSE_EXPERIMENTAL_WITHOUT_ARGUMENTS(), context2, null, 8, null);
                } else {
                    FirExpression annotationClasses = FirAnnotationHelpersKt.findArgumentByName(expression2, OptInNames.INSTANCE.getUSE_EXPERIMENTAL_ANNOTATION_CLASS());
                    Object object2 = annotationClasses;
                    object2 = object2 == null ? null : FirAnnotationHelpersKt.extractClassesFromArgument((FirExpression)object2);
                    boolean bl2 = false;
                    Object object3 = object2;
                    if (object3 == null) {
                        object3 = CollectionsKt.emptyList();
                    }
                    Iterator iterator2 = object3.iterator();
                    while (iterator2.hasNext()) {
                        FirRegularClassSymbol classSymbol = (FirRegularClassSymbol)iterator2.next();
                        FirOptInUsageBaseChecker firOptInUsageBaseChecker = FirOptInUsageBaseChecker.INSTANCE;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        FirOptInUsageBaseChecker $this$check_u24lambda_u2d0 = firOptInUsageBaseChecker;
                        boolean bl5 = false;
                        if ($this$check_u24lambda_u2d0.loadExperimentalityForMarkerAnnotation$checkers((FirRegularClass)classSymbol.getFir()) != null) continue;
                        FirSourceElement firSourceElement = expression2.getSource();
                        FirDiagnosticFactory1<FqName> firDiagnosticFactory1 = FirErrors.INSTANCE.getUSE_EXPERIMENTAL_ARGUMENT_IS_NOT_MARKER();
                        FqName fqName3 = classSymbol.getClassId().asSingleFqName();
                        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"classSymbol.classId.asSingleFqName()");
                        DiagnosticReporterKt.reportOn$default(reporter, firSourceElement, firDiagnosticFactory1, fqName3, context2, null, 16, null);
                    }
                }
            }
        }
    }

    private final void checkUsageOfKotlinExperimentalOrUseExperimental(FirSourceElement element, CheckerContext context2, DiagnosticReporter reporter) {
        List<String> useExperimentalFqNames = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).getFlag(AnalysisFlags.getUseExperimental());
        if (!useExperimentalFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
            DiagnosticReporterKt.reportOn$default(reporter, element, FirErrors.INSTANCE.getEXPERIMENTAL_IS_NOT_ENABLED(), context2, null, 8, null);
        }
    }
}

