/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.lazy;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.lazy.Lazy;

@ThreadSafe
class LockingLazy<T>
implements Lazy<T> {
    private final Lock lock = new ReentrantLock();
    private Supplier<T> supplier;
    private T value;

    public LockingLazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        return this.ensureValue();
    }

    private T ensureValue() {
        if (this.supplier != null) {
            this.lock.lock();
            try {
                this.maybeInitialize();
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.value;
    }

    private void maybeInitialize() {
        if (this.supplier != null) {
            this.value = this.supplier.get();
            this.supplier = null;
        }
    }

    @Override
    public void use(Consumer<? super T> consumer) {
    }

    @Override
    public <V> V apply(Function<? super T, V> function) {
        return function.apply(this.ensureValue());
    }
}

