/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import java.util.Collection;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleFinder;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u0003H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0011\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b0\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleFinder;", "jrtFileSystemRoot", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "javaFileManager", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;Lcom/intellij/openapi/project/Project;)V", "allObservableModules", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "getAllObservableModules", "()Lkotlin/sequences/Sequence;", "allScope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "modulesRoot", "Lorg/jetbrains/annotations/Nullable;", "systemModules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "getSystemModules", "userModules", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "addUserModule", "", "module", "findModule", "name", "findSystemModule", "moduleRoot", "cli"})
public final class CliJavaModuleFinder
implements JavaModuleFinder {
    @NotNull
    private final KotlinCliJavaFileManager javaFileManager;
    @Nullable
    private final VirtualFile modulesRoot;
    @NotNull
    private final LinkedHashMap<String, JavaModule> userModules;
    @NotNull
    private final GlobalSearchScope allScope;

    public CliJavaModuleFinder(@Nullable VirtualFile jrtFileSystemRoot, @NotNull KotlinCliJavaFileManager javaFileManager, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)javaFileManager, (String)"javaFileManager");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.javaFileManager = javaFileManager;
        VirtualFile virtualFile2 = jrtFileSystemRoot;
        this.modulesRoot = virtualFile2 == null ? null : virtualFile2.findChild("modules");
        boolean bl = false;
        this.userModules = new LinkedHashMap();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"allScope(project)");
        this.allScope = globalSearchScope;
    }

    public final void addUserModule(@NotNull JavaModule module2) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        this.userModules.putIfAbsent(module2.getName(), module2);
    }

    @NotNull
    public final Sequence<JavaModule> getAllObservableModules() {
        Sequence<JavaModule.Explicit> sequence2 = this.getSystemModules();
        Collection<JavaModule> collection = this.userModules.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"userModules.values");
        return SequencesKt.plus(sequence2, (Iterable)collection);
    }

    @NotNull
    public final Sequence<JavaModule.Explicit> getSystemModules() {
        VirtualFile virtualFile2 = this.modulesRoot;
        Object[] $this$orEmpty$iv = virtualFile2 == null ? null : virtualFile2.getChildren();
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            objectArray = new VirtualFile[]{};
        }
        return SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<VirtualFile, JavaModule.Explicit>((Object)this){

            @Nullable
            public final JavaModule.Explicit invoke(@NotNull VirtualFile p0) {
                Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
                return CliJavaModuleFinder.access$findSystemModule((CliJavaModuleFinder)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "findSystemModule(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;";
            }

            @NotNull
            public final String getName() {
                return "findSystemModule";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(CliJavaModuleFinder.class);
            }
        }));
    }

    @Override
    @Nullable
    public JavaModule findModule(@NotNull String name) {
        JavaModule.Explicit explicit;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        VirtualFile virtualFile2 = this.modulesRoot;
        if (virtualFile2 == null) {
            explicit = null;
        } else {
            VirtualFile virtualFile3 = virtualFile2.findChild(name);
            if (virtualFile3 == null) {
                explicit = null;
            } else {
                VirtualFile virtualFile4 = virtualFile3;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile p0 = virtualFile4;
                boolean bl3 = false;
                explicit = this.findSystemModule(p0);
            }
        }
        JavaModule.Explicit explicit2 = explicit;
        return explicit2 == null ? this.userModules.get(name) : (JavaModule)explicit2;
    }

    private final JavaModule.Explicit findSystemModule(VirtualFile moduleRoot) {
        Object object = moduleRoot.findChild("module-info.class");
        if (object == null) {
            return null;
        }
        Object object2 = object;
        VirtualFile file2 = object2;
        if ((object = JavaModuleInfo.Companion.read(file2, this.javaFileManager, this.allScope)) == null) {
            return null;
        }
        Object moduleInfo2 = object;
        return new JavaModule.Explicit((JavaModuleInfo)moduleInfo2, CollectionsKt.listOf((Object)new JavaModule.Root(moduleRoot, true)), file2);
    }

    public static final /* synthetic */ JavaModule.Explicit access$findSystemModule(CliJavaModuleFinder $this, VirtualFile moduleRoot) {
        return $this.findSystemModule(moduleRoot);
    }
}

