/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ForwardingMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.gradle.internal.classpath.AccessTrackingSet;
import org.gradle.internal.classpath.AccessTrackingUtils;

class AccessTrackingEnvMap
extends ForwardingMap<String, String> {
    private final Map<String, String> delegate;
    private final BiConsumer<? super String, ? super String> onAccess;

    public AccessTrackingEnvMap(BiConsumer<String, String> onAccess) {
        this(System.getenv(), onAccess);
    }

    @VisibleForTesting
    AccessTrackingEnvMap(Map<String, String> delegate, BiConsumer<? super String, ? super String> onAccess) {
        this.delegate = delegate;
        this.onAccess = onAccess;
    }

    public String get(@Nullable Object key) {
        return this.getAndReport(key);
    }

    public String getOrDefault(@Nullable Object key, String defaultValue) {
        String value = this.getAndReport(key);
        if (value == null && !this.delegate.containsKey(key)) {
            return defaultValue;
        }
        return value;
    }

    public boolean containsKey(@Nullable Object key) {
        return this.getAndReport(key) != null;
    }

    public Set<String> keySet() {
        return new AccessTrackingSet(super.keySet(), this::getAndReport, this::reportAggregatingAccess);
    }

    private String getAndReport(@Nullable Object key) {
        String result = this.delegate.get(key);
        this.onAccess.accept((String)key, result);
        return result;
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return new AccessTrackingSet<Map.Entry<String, String>>(this.delegate.entrySet(), this::onAccessEntrySetElement, this::reportAggregatingAccess);
    }

    private void onAccessEntrySetElement(@Nullable Object potentialEntry) {
        Map.Entry<String, String> entry = AccessTrackingUtils.tryConvertingToTrackableEntry(potentialEntry);
        if (entry != null) {
            this.getAndReport(entry.getKey());
        }
    }

    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.reportAggregatingAccess();
        this.delegate.forEach(action);
    }

    public int size() {
        this.reportAggregatingAccess();
        return this.delegate.size();
    }

    public boolean isEmpty() {
        this.reportAggregatingAccess();
        return this.delegate.isEmpty();
    }

    public boolean equals(@Nullable Object object) {
        this.reportAggregatingAccess();
        return this.delegate.equals(object);
    }

    public int hashCode() {
        this.reportAggregatingAccess();
        return this.delegate.hashCode();
    }

    protected Map<String, String> delegate() {
        return this.delegate;
    }

    private void reportAggregatingAccess() {
        this.delegate.forEach(this.onAccess);
    }
}

