/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.file.FilePathUtil;

public abstract class FileHierarchySet {
    private static final FileHierarchySet EMPTY = new FileHierarchySet(){

        @Override
        public boolean contains(File file) {
            return false;
        }

        @Override
        public boolean contains(String path) {
            return false;
        }

        @Override
        public FileHierarchySet plus(File rootDir) {
            return new PrefixFileSet(rootDir);
        }

        @Override
        public FileHierarchySet plus(String absolutePath) {
            return new PrefixFileSet(absolutePath);
        }

        @Override
        public void visitRoots(RootVisitor visitor) {
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public abstract boolean contains(File var1);

    public abstract boolean contains(String var1);

    @CheckReturnValue
    public abstract FileHierarchySet plus(File var1);

    @CheckReturnValue
    public abstract FileHierarchySet plus(String var1);

    public abstract void visitRoots(RootVisitor var1);

    public static FileHierarchySet empty() {
        return EMPTY;
    }

    private static interface NodeVisitor {
        public void visitNode(int var1, Node var2);
    }

    private static class Node {
        private final String prefix;
        private final List<Node> children;

        Node(String prefix) {
            this.prefix = prefix;
            this.children = ImmutableList.of();
        }

        public Node(String prefix, List<Node> children) {
            this.prefix = prefix;
            this.children = children;
        }

        Node plus(String path) {
            int maxPos = Math.min(this.prefix.length(), path.length());
            int prefixLen = this.sizeOfCommonPrefix(path, 0);
            if (prefixLen == maxPos) {
                if (this.prefix.length() == path.length()) {
                    if (this.children.isEmpty()) {
                        return this;
                    }
                    return new Node(path);
                }
                if (this.prefix.length() < path.length()) {
                    if (this.children.isEmpty()) {
                        return this;
                    }
                    int startNextSegment = prefixLen == 0 ? 0 : prefixLen + 1;
                    ArrayList<Node> merged = new ArrayList<Node>(this.children.size() + 1);
                    boolean matched = false;
                    for (Node child : this.children) {
                        if (child.sizeOfCommonPrefix(path, startNextSegment) > 0) {
                            merged.add(child.plus(path.substring(startNextSegment)));
                            matched = true;
                            continue;
                        }
                        merged.add(child);
                    }
                    if (!matched) {
                        merged.add(new Node(path.substring(startNextSegment)));
                    }
                    return new Node(this.prefix, merged);
                }
                return new Node(path);
            }
            String commonPrefix = this.prefix.substring(0, prefixLen);
            int newChildrenStartIndex = prefixLen == 0 ? 0 : prefixLen + 1;
            Node newThis = new Node(this.prefix.substring(newChildrenStartIndex), this.children);
            Node sibling = new Node(path.substring(newChildrenStartIndex));
            return new Node(commonPrefix, (List<Node>)ImmutableList.of((Object)newThis, (Object)sibling));
        }

        int sizeOfCommonPrefix(String path, int offset) {
            return FilePathUtil.sizeOfCommonPrefix(this.prefix, path, offset);
        }

        boolean isChildOfOrThis(String filePath, int offset) {
            int prefixLength;
            int endOfThisSegment;
            if (this.prefix.isEmpty()) {
                return true;
            }
            int pathLength = filePath.length();
            if (pathLength < (endOfThisSegment = (prefixLength = this.prefix.length()) + offset)) {
                return false;
            }
            int i = prefixLength - 1;
            int j = endOfThisSegment - 1;
            while (i >= 0) {
                if (this.prefix.charAt(i) != filePath.charAt(j)) {
                    return false;
                }
                --i;
                --j;
            }
            return endOfThisSegment == pathLength || filePath.charAt(endOfThisSegment) == File.separatorChar;
        }

        boolean contains(String filePath, int offset) {
            if (!this.isChildOfOrThis(filePath, offset)) {
                return false;
            }
            if (this.children.isEmpty()) {
                return true;
            }
            int startNextSegment = this.prefix.isEmpty() ? offset : offset + this.prefix.length() + 1;
            for (Node child : this.children) {
                if (!child.contains(filePath, startNextSegment)) continue;
                return true;
            }
            return false;
        }

        public void visitHierarchy(int depth, NodeVisitor visitor) {
            visitor.visitNode(depth, this);
            for (Node child : this.children) {
                child.visitHierarchy(depth + 1, visitor);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (!this.prefix.equals(node.prefix)) {
                return false;
            }
            return this.children.equals(node.children);
        }

        public int hashCode() {
            int result = this.prefix.hashCode();
            result = 31 * result + this.children.hashCode();
            return result;
        }

        public String toString() {
            return this.prefix;
        }
    }

    private static class PrefixFileSet
    extends FileHierarchySet {
        private final Node rootNode;

        PrefixFileSet(File rootDir) {
            this(PrefixFileSet.toAbsolutePath(rootDir));
        }

        PrefixFileSet(String rootPath) {
            String path = PrefixFileSet.removeTrailingSeparator(rootPath);
            this.rootNode = new Node(path);
        }

        PrefixFileSet(Node rootNode) {
            this.rootNode = rootNode;
        }

        @VisibleForTesting
        List<String> flatten() {
            final ArrayList<String> prefixes = new ArrayList<String>();
            this.rootNode.visitHierarchy(0, new NodeVisitor(){

                @Override
                public void visitNode(int depth, Node node) {
                    if (depth == 0) {
                        prefixes.add(node.prefix);
                    } else {
                        prefixes.add(depth + ":" + node.prefix.replace(File.separatorChar, '/'));
                    }
                }
            });
            return prefixes;
        }

        @Override
        public boolean contains(String path) {
            return this.rootNode.contains(path, 0);
        }

        @Override
        public boolean contains(File file) {
            return this.rootNode.contains(file.getPath(), 0);
        }

        @Override
        public FileHierarchySet plus(File rootDir) {
            return this.plus(PrefixFileSet.toAbsolutePath(rootDir));
        }

        @Override
        public FileHierarchySet plus(String absolutePath) {
            return new PrefixFileSet(this.rootNode.plus(PrefixFileSet.removeTrailingSeparator(absolutePath)));
        }

        private static String toAbsolutePath(File rootDir) {
            assert (rootDir.isAbsolute());
            return rootDir.getAbsolutePath();
        }

        private static String removeTrailingSeparator(String absolutePath) {
            if (absolutePath.equals("/")) {
                absolutePath = "";
            } else if (absolutePath.endsWith(File.separator)) {
                absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
            }
            return absolutePath;
        }

        @Override
        public void visitRoots(final RootVisitor visitor) {
            final ArrayDeque prefixStack = new ArrayDeque();
            this.rootNode.visitHierarchy(0, new NodeVisitor(){

                @Override
                public void visitNode(int depth, Node node) {
                    while (prefixStack.size() > depth) {
                        prefixStack.removeLast();
                    }
                    if (node.children.isEmpty()) {
                        String root;
                        if (prefixStack.isEmpty()) {
                            root = node.prefix;
                        } else {
                            StringBuilder builder = new StringBuilder();
                            for (String prefix : prefixStack) {
                                builder.append(prefix);
                                builder.append(File.separatorChar);
                            }
                            builder.append(node.prefix);
                            root = builder.toString();
                        }
                        visitor.visitRoot(root);
                    } else {
                        prefixStack.add(node.prefix);
                    }
                }
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrefixFileSet that = (PrefixFileSet)o;
            return this.rootNode.equals(that.rootNode);
        }

        public int hashCode() {
            return this.rootNode.hashCode();
        }

        public String toString() {
            final StringBuilder builder = new StringBuilder();
            this.rootNode.visitHierarchy(0, new NodeVisitor(){
                private boolean first = true;

                @Override
                public void visitNode(int depth, Node node) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        builder.append("\n");
                    }
                    builder.append(Strings.repeat((String)" ", (int)(depth * 2)));
                    builder.append(node.prefix);
                }
            });
            return builder.toString();
        }
    }

    public static interface RootVisitor {
        public void visitRoot(String var1);
    }
}

