/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.KotlinType;
import org.gradle.api.GradleScriptException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionCatalogsExtension;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.DisplayName;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resource.TextResource;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.kotlin.dsl.accessors.ProjectAccessorsClassPathGenerator;
import org.gradle.kotlin.dsl.execution.CompiledScript;
import org.gradle.kotlin.dsl.execution.EvalOption;
import org.gradle.kotlin.dsl.execution.EvalOptionKt;
import org.gradle.kotlin.dsl.execution.ExecutableProgram;
import org.gradle.kotlin.dsl.execution.Interpreter$Host$WhenMappings;
import org.gradle.kotlin.dsl.execution.InterpreterKt;
import org.gradle.kotlin.dsl.execution.Packaged;
import org.gradle.kotlin.dsl.execution.PartialEvaluator;
import org.gradle.kotlin.dsl.execution.Program;
import org.gradle.kotlin.dsl.execution.ProgramId;
import org.gradle.kotlin.dsl.execution.ProgramKind;
import org.gradle.kotlin.dsl.execution.ProgramParser;
import org.gradle.kotlin.dsl.execution.ProgramSource;
import org.gradle.kotlin.dsl.execution.ProgramTarget;
import org.gradle.kotlin.dsl.execution.ResidualProgram;
import org.gradle.kotlin.dsl.execution.ResidualProgramCompiler;
import org.gradle.kotlin.dsl.execution.ResidualProgramCompilerKt;
import org.gradle.kotlin.dsl.execution.TemporaryScriptFilesKt;
import org.gradle.kotlin.dsl.support.GradleExtensionsKt;
import org.gradle.kotlin.dsl.support.KotlinScriptHost;
import org.gradle.kotlin.dsl.support.ProjectExtensionsKt;
import org.gradle.kotlin.dsl.support.ScriptCompilationException;
import org.gradle.kotlin.dsl.support.SettingsExtensionsKt;
import org.gradle.plugin.management.internal.PluginRequests;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003<=>B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\\\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002JN\u0010\"\u001a\u00020#2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JR\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010,\u001a\u00020-2\u0012\b\u0002\u0010.\u001a\f\u0012\u0004\u0012\u0002000/j\u0002`1J8\u00102\u001a\u00020#2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u00106\u001a\u00060\u0006R\u00020\u00002\u0010\u0010.\u001a\f\u0012\u0004\u0012\u0002000/j\u0002`1H\u0002J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0001H\u0002J>\u00108\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\u0018\u00109\u001a\u00020:2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u000bH\u0002J\f\u0010;\u001a\u00020\f*\u00020\u0001H\u0002R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR(\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n*\u0006\u0012\u0002\b\u00030\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006?"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter;", "", "host", "Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;)V", "defaultProgramHost", "Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "getHost", "()Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "injectedProperties", "", "", "Lkotlin/script/experimental/api/KotlinType;", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "getInjectedProperties", "(Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;)Ljava/util/Map;", "compile", "Ljava/io/File;", "scriptHost", "templateId", "scriptPath", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "compilationClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "pluginAccessorsClassPath", "temporaryFileProvider", "Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "emitSpecializedProgramFor", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "targetScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "baseScope", "eval", "", "target", "scriptHandler", "Lorg/gradle/api/initialization/dsl/ScriptHandler;", "topLevelScript", "", "options", "Ljava/util/EnumSet;", "Lorg/gradle/kotlin/dsl/execution/EvalOption;", "Lorg/gradle/kotlin/dsl/execution/EvalOptions;", "loadClassInChildScopeOf", "classesDir", "scriptTemplateId", "accessorsClassPath", "programHostFor", "programTargetFor", "scriptHostFor", "startCompilerOperationFor", "Ljava/lang/AutoCloseable;", "getKotlinType", "FirstStageOnlyProgramHost", "Host", "ProgramHost", "kotlin-dsl"})
public final class Interpreter {
    private final ProgramHost defaultProgramHost;
    @NotNull
    private final Host host;

    public final void eval(@NotNull Object target, @NotNull ScriptSource scriptSource, @NotNull HashCode sourceHash, @NotNull ScriptHandler scriptHandler, @NotNull ClassLoaderScope targetScope, @NotNull ClassLoaderScope baseScope, boolean topLevelScript, @NotNull EnumSet<EvalOption> options) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)scriptSource, (String)"scriptSource");
        Intrinsics.checkNotNullParameter((Object)sourceHash, (String)"sourceHash");
        Intrinsics.checkNotNullParameter((Object)scriptHandler, (String)"scriptHandler");
        Intrinsics.checkNotNullParameter((Object)targetScope, (String)"targetScope");
        Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        ProgramKind programKind = topLevelScript ? ProgramKind.TopLevel : ProgramKind.ScriptPlugin;
        ProgramTarget programTarget = this.programTargetFor(target);
        String templateId = InterpreterKt.templateIdFor(programTarget, programKind, "stage1");
        ClassLoader classLoader = baseScope.getExportClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"baseScope.exportClassLoader");
        ClassLoader parentClassLoader = classLoader;
        ProgramId programId = new ProgramId(templateId, sourceHash, parentClassLoader, null, null, 24, null);
        CompiledScript cachedProgram = this.host.cachedClassFor(programId);
        KotlinScriptHost<Object> scriptHost = this.scriptHostFor(programTarget, target, scriptSource, scriptHandler, targetScope, baseScope);
        ProgramHost programHost = this.programHostFor(options);
        if (cachedProgram != null) {
            programHost.eval(cachedProgram, scriptHost);
            return;
        }
        CompiledScript specializedProgram = this.emitSpecializedProgramFor(scriptHost, scriptSource, sourceHash, templateId, targetScope, baseScope, programKind, programTarget);
        this.host.cache(specializedProgram, programId);
        programHost.eval(specializedProgram, scriptHost);
    }

    public static /* synthetic */ void eval$default(Interpreter interpreter2, Object object, ScriptSource scriptSource, HashCode hashCode, ScriptHandler scriptHandler, ClassLoaderScope classLoaderScope, ClassLoaderScope classLoaderScope2, boolean bl, EnumSet enumSet, int n, Object object2) {
        if ((n & 0x80) != 0) {
            enumSet = EvalOptionKt.getDefaultEvalOptions();
        }
        interpreter2.eval(object, scriptSource, hashCode, scriptHandler, classLoaderScope, classLoaderScope2, bl, enumSet);
    }

    private final ProgramTarget programTargetFor(Object target) {
        ProgramTarget programTarget;
        Object object = target;
        if (object instanceof Settings) {
            programTarget = ProgramTarget.Settings;
        } else if (object instanceof Project) {
            programTarget = ProgramTarget.Project;
        } else if (object instanceof Gradle) {
            programTarget = ProgramTarget.Gradle;
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported target: " + target);
        }
        return programTarget;
    }

    private final KotlinScriptHost<Object> scriptHostFor(ProgramTarget programTarget, Object target, ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope) {
        return new KotlinScriptHost<Object>(target, scriptSource, scriptHandler, targetScope, baseScope, this.host.serviceRegistryFor(programTarget, target));
    }

    private final ProgramHost programHostFor(EnumSet<EvalOption> options) {
        return options.contains((Object)EvalOption.SkipBody) ? (ProgramHost)new FirstStageOnlyProgramHost() : this.defaultProgramHost;
    }

    private final CompiledScript emitSpecializedProgramFor(KotlinScriptHost<? extends Object> scriptHost, ScriptSource scriptSource, HashCode sourceHash, String templateId, ClassLoaderScope targetScope, ClassLoaderScope baseScope, ProgramKind programKind, ProgramTarget programTarget) {
        ClassPath pluginAccessorsClassPath = ResidualProgramCompilerKt.requiresAccessors(programTarget, programKind) ? this.host.pluginAccessorsFor(scriptHost) : ClassPath.EMPTY;
        String scriptPath = scriptHost.getFileName();
        ClassLoaderScope classLoaderScope = targetScope.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)classLoaderScope, (String)"targetScope.parent");
        ClassPath classPath = this.host.compilationClassPathOf(classLoaderScope);
        ClassPath classPath2 = pluginAccessorsClassPath;
        Intrinsics.checkNotNullExpressionValue((Object)classPath2, (String)"pluginAccessorsClassPath");
        File classesDir = this.compile(scriptHost, templateId, scriptPath, scriptSource, sourceHash, programKind, programTarget, classPath, classPath2, scriptHost.getTemporaryFileProvider$kotlin_dsl());
        return this.loadClassInChildScopeOf(baseScope, scriptPath, classesDir, templateId, pluginAccessorsClassPath, scriptSource);
    }

    private final File compile(KotlinScriptHost<?> scriptHost, String templateId, String scriptPath, ScriptSource scriptSource, HashCode sourceHash, ProgramKind programKind, ProgramTarget programTarget, ClassPath compilationClassPath, ClassPath pluginAccessorsClassPath, TemporaryFileProvider temporaryFileProvider2) {
        ClassPath classPath = ClassPath.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"ClassPath.EMPTY");
        return this.host.cachedDirFor(scriptHost, templateId, sourceHash, compilationClassPath, classPath, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this, scriptSource, templateId, scriptPath, programKind, programTarget, compilationClassPath, sourceHash, temporaryFileProvider2, pluginAccessorsClassPath, scriptHost){
            final /* synthetic */ Interpreter this$0;
            final /* synthetic */ ScriptSource $scriptSource;
            final /* synthetic */ String $templateId;
            final /* synthetic */ String $scriptPath;
            final /* synthetic */ ProgramKind $programKind;
            final /* synthetic */ ProgramTarget $programTarget;
            final /* synthetic */ ClassPath $compilationClassPath;
            final /* synthetic */ HashCode $sourceHash;
            final /* synthetic */ TemporaryFileProvider $temporaryFileProvider;
            final /* synthetic */ ClassPath $pluginAccessorsClassPath;
            final /* synthetic */ KotlinScriptHost $scriptHost;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull File cachedDir) {
                Intrinsics.checkNotNullParameter((Object)cachedDir, (String)"cachedDir");
                AutoCloseable autoCloseable = Interpreter.access$startCompilerOperationFor(this.this$0, this.$scriptSource, this.$templateId);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    String sourceText;
                    AutoCloseable it = autoCloseable;
                    boolean bl3 = false;
                    TextResource textResource = this.$scriptSource.getResource();
                    Intrinsics.checkNotNull((Object)textResource);
                    String string2 = sourceText = textResource.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceText");
                    ProgramSource programSource = new ProgramSource(this.$scriptPath, string2);
                    Packaged<Program> program2 = ProgramParser.INSTANCE.parse(programSource, this.$programKind, this.$programTarget);
                    Packaged<U> residualProgram2 = program2.map((Function1)new Function1<Program, ResidualProgram>(new PartialEvaluator(this.$programKind, this.$programTarget)){

                        @NotNull
                        public final ResidualProgram invoke(@NotNull Program p1) {
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return ((PartialEvaluator)this.receiver).reduce(p1);
                        }
                    });
                    ScriptSource $this$withLocationAwareExceptionHandling$iv = this.$scriptSource;
                    boolean $i$f$withLocationAwareExceptionHandling = false;
                    try {
                        boolean bl4 = false;
                        new ResidualProgramCompiler(cachedDir, this.$compilationClassPath, this.$sourceHash, this.$programKind, this.$programTarget, this.this$0.getHost().getImplicitImports(), InterpreterKt.getInterpreterLogger(), this.$temporaryFileProvider, (Function3<? super String, ? super String, ? super Function0<String>, String>)((Function3)new Function3<String, String, Function0<? extends String>, String>(this.this$0.getHost()){

                            @NotNull
                            public final String invoke(@NotNull String p1, @NotNull String p2, @NotNull Function0<String> p3) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                                Intrinsics.checkNotNullParameter(p3, (String)"p3");
                                return ((Host)this.receiver).runCompileBuildOperation(p1, p2, p3);
                            }
                        }), this.$pluginAccessorsClassPath, residualProgram2.getPackageName(), Interpreter.access$getInjectedProperties$p(this.this$0, this.$scriptHost)).compile((ResidualProgram)residualProgram2.getDocument());
                        Unit unit2 = Unit.INSTANCE;
                    }
                    catch (ScriptCompilationException e$iv) {
                        throw (Throwable)new LocationAwareException((Throwable)e$iv, $this$withLocationAwareExceptionHandling$iv, e$iv.getFirstErrorLine());
                    }
                    Unit unit3 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = interpreter2;
                this.$scriptSource = scriptSource;
                this.$templateId = string2;
                this.$scriptPath = string3;
                this.$programKind = programKind;
                this.$programTarget = programTarget;
                this.$compilationClassPath = classPath;
                this.$sourceHash = hashCode;
                this.$temporaryFileProvider = temporaryFileProvider2;
                this.$pluginAccessorsClassPath = classPath2;
                this.$scriptHost = kotlinScriptHost;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, KotlinType> getInjectedProperties(KotlinScriptHost<?> $this$injectedProperties) {
        Map map;
        Object obj = $this$injectedProperties.getTarget();
        if (obj instanceof Project) {
            VersionCatalogsExtension versionCatalogsExtension = (VersionCatalogsExtension)((Project)$this$injectedProperties.getTarget()).getExtensions().findByType(VersionCatalogsExtension.class);
            if (versionCatalogsExtension != null) {
                void $this$associateTo$iv$iv;
                void $this$filterTo$iv$iv;
                Pair it;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)versionCatalogsExtension;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    VersionCatalog versionCatalog = (VersionCatalog)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    Pair pair = TuplesKt.to((Object)v1.getName(), (Object)((Project)$this$injectedProperties.getTarget()).getExtensions().findByName(it.getName()));
                    collection.add(pair);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Pair)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSecond() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$associate$iv = (List)destination$iv$iv;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv2;
                    Pair it2 = (Pair)element$iv$iv;
                    boolean bl = false;
                    Object object = it2.getFirst();
                    Object object2 = it2.getSecond();
                    Intrinsics.checkNotNull((Object)object2);
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.second!!");
                    Pair pair = TuplesKt.to((Object)object, (Object)this.getKotlinType(object2));
                    boolean bl2 = false;
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                map = destination$iv$iv2;
            } else {
                boolean bl = false;
                map = MapsKt.emptyMap();
            }
        } else {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final KotlinType getKotlinType(Object $this$getKotlinType) {
        KotlinType kotlinType;
        Object object = $this$getKotlinType;
        if (object instanceof GeneratedSubclass) {
            Class clazz = ((GeneratedSubclass)$this$getKotlinType).publicType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"this.publicType()");
            kotlinType = new KotlinType(JvmClassMappingKt.getKotlinClass((Class)clazz));
        } else {
            kotlinType = new KotlinType(JvmClassMappingKt.getKotlinClass($this$getKotlinType.getClass()));
        }
        return kotlinType;
    }

    private final CompiledScript loadClassInChildScopeOf(ClassLoaderScope baseScope, String scriptPath, File classesDir, String scriptTemplateId, ClassPath accessorsClassPath, ScriptSource scriptSource) {
        InterpreterKt.access$logClassLoadingOf(scriptTemplateId, scriptSource);
        String string2 = "Program";
        File file = classesDir;
        ClassPath classPath = accessorsClassPath;
        return this.host.loadClassInChildScopeOf(baseScope, InterpreterKt.access$classLoaderScopeIdFor(scriptPath, scriptTemplateId), file, string2, classPath);
    }

    private final AutoCloseable startCompilerOperationFor(ScriptSource scriptSource, String scriptTemplateId) {
        InterpreterKt.access$logCompilationOf(scriptTemplateId, scriptSource);
        DisplayName displayName = scriptSource.getShortDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)displayName, (String)"scriptSource.shortDisplayName");
        String string2 = displayName.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"scriptSource.shortDisplayName.displayName");
        return this.host.startCompilerOperation(string2);
    }

    @NotNull
    public final Host getHost() {
        return this.host;
    }

    public Interpreter(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.defaultProgramHost = new ProgramHost();
    }

    public static final /* synthetic */ AutoCloseable access$startCompilerOperationFor(Interpreter $this, ScriptSource scriptSource, String scriptTemplateId) {
        return $this.startCompilerOperationFor(scriptSource, scriptTemplateId);
    }

    public static final /* synthetic */ Map access$getInjectedProperties$p(Interpreter $this, KotlinScriptHost $this$access_u24injectedProperties_u24p) {
        return $this.getInjectedProperties($this$access_u24injectedProperties_u24p);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u001c\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&JH\u0010\u0016\u001a\u00020\u00172\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\b0\u001fH&J\u0014\u0010 \u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H&J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001cH&J0\u0010&\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001cH&J\u001c\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030-H&J\u0014\u0010.\u001a\u00020\u001c2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J&\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000403H&J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0001H\u0016J\u0014\u00109\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH&J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0004H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006="}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$Host;", "", "implicitImports", "", "", "getImplicitImports", "()Ljava/util/List;", "applyBasePluginsTo", "", "project", "Lorg/gradle/api/internal/project/ProjectInternal;", "applyPluginsTo", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "pluginRequests", "Lorg/gradle/plugin/management/internal/PluginRequests;", "cache", "specializedProgram", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "programId", "Lorg/gradle/kotlin/dsl/execution/ProgramId;", "cachedClassFor", "cachedDirFor", "Ljava/io/File;", "templateId", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "compilationClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "accessorsClassPath", "initializer", "Lkotlin/Function1;", "closeTargetScopeOf", "compilationClassPathOf", "classLoaderScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "hashOf", "classPath", "loadClassInChildScopeOf", "childScopeId", "location", "className", "onScriptClassLoaded", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "Ljava/lang/Class;", "pluginAccessorsFor", "runCompileBuildOperation", "scriptPath", "stage", "action", "Lkotlin/Function0;", "serviceRegistryFor", "Lorg/gradle/internal/service/ServiceRegistry;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "target", "setupEmbeddedKotlinFor", "startCompilerOperation", "Ljava/lang/AutoCloseable;", "description", "kotlin-dsl"})
    public static interface Host {
        @Nullable
        public CompiledScript cachedClassFor(@NotNull ProgramId var1);

        public void cache(@NotNull CompiledScript var1, @NotNull ProgramId var2);

        @NotNull
        public File cachedDirFor(@NotNull KotlinScriptHost<?> var1, @NotNull String var2, @NotNull HashCode var3, @NotNull ClassPath var4, @NotNull ClassPath var5, @NotNull Function1<? super File, Unit> var6);

        @NotNull
        public AutoCloseable startCompilerOperation(@NotNull String var1);

        @NotNull
        public ClassPath compilationClassPathOf(@NotNull ClassLoaderScope var1);

        @NotNull
        public ClassPath pluginAccessorsFor(@NotNull KotlinScriptHost<?> var1);

        @NotNull
        public CompiledScript loadClassInChildScopeOf(@NotNull ClassLoaderScope var1, @NotNull String var2, @NotNull File var3, @NotNull String var4, @NotNull ClassPath var5);

        public void applyPluginsTo(@NotNull KotlinScriptHost<?> var1, @NotNull PluginRequests var2);

        public void applyBasePluginsTo(@NotNull ProjectInternal var1);

        public void setupEmbeddedKotlinFor(@NotNull KotlinScriptHost<?> var1);

        public void closeTargetScopeOf(@NotNull KotlinScriptHost<?> var1);

        @NotNull
        public HashCode hashOf(@NotNull ClassPath var1);

        @NotNull
        public String runCompileBuildOperation(@NotNull String var1, @NotNull String var2, @NotNull Function0<String> var3);

        public void onScriptClassLoaded(@NotNull ScriptSource var1, @NotNull Class<?> var2);

        @NotNull
        public List<String> getImplicitImports();

        @NotNull
        public ServiceRegistry serviceRegistryFor(@NotNull ProgramTarget var1, @NotNull Object var2);

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            @NotNull
            public static ServiceRegistry serviceRegistryFor(@NotNull Host $this, @NotNull ProgramTarget programTarget, @NotNull Object target) {
                ServiceRegistry serviceRegistry;
                Intrinsics.checkNotNullParameter((Object)((Object)programTarget), (String)"programTarget");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                switch (Interpreter$Host$WhenMappings.$EnumSwitchMapping$0[programTarget.ordinal()]) {
                    case 1: {
                        serviceRegistry = ProjectExtensionsKt.serviceRegistryOf((Project)target);
                        break;
                    }
                    case 2: {
                        serviceRegistry = SettingsExtensionsKt.serviceRegistryOf((Settings)target);
                        break;
                    }
                    case 3: {
                        serviceRegistry = GradleExtensionsKt.serviceRegistryOf((Gradle)target);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return serviceRegistry;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$FirstStageOnlyProgramHost;", "Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "Lorg/gradle/kotlin/dsl/execution/Interpreter;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter;)V", "evaluateSecondStageOf", "", "program", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$StagedProgram;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "scriptTemplateId", "", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "accessorsClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "kotlin-dsl"})
    private final class FirstStageOnlyProgramHost
    extends ProgramHost {
        @Override
        public void evaluateSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @NotNull ClassPath accessorsClassPath) {
            Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Intrinsics.checkNotNullParameter((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkNotNullParameter((Object)sourceHash, (String)"sourceHash");
            Intrinsics.checkNotNullParameter((Object)accessorsClassPath, (String)"accessorsClassPath");
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016JD\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\u001a\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J4\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J(\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0014\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030#H\u0002J \u0010'\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u001d\u001a\u00020\u00102\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0014\u0010(\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a8\u0006)"}, d2={"Lorg/gradle/kotlin/dsl/execution/Interpreter$ProgramHost;", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$Host;", "(Lorg/gradle/kotlin/dsl/execution/Interpreter;)V", "accessorsClassPathFor", "Lorg/gradle/internal/classpath/ClassPath;", "scriptHost", "Lorg/gradle/kotlin/dsl/support/KotlinScriptHost;", "applyBasePluginsTo", "", "project", "Lorg/gradle/api/Project;", "applyPluginsTo", "pluginRequests", "Lorg/gradle/plugin/management/internal/PluginRequests;", "closeTargetScopeOf", "compileSecondStageOf", "Lorg/gradle/kotlin/dsl/execution/CompiledScript;", "program", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram$StagedProgram;", "scriptTemplateId", "", "sourceHash", "Lorg/gradle/internal/hash/HashCode;", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "accessorsClassPath", "eval", "compiledScript", "evaluateSecondStageOf", "handleScriptException", "exception", "", "scriptClass", "Ljava/lang/Class;", "instantiate", "Lorg/gradle/kotlin/dsl/execution/ExecutableProgram;", "specializedProgram", "load", "setupEmbeddedKotlinFor", "kotlin-dsl"})
    private class ProgramHost
    implements ExecutableProgram.Host {
        @Override
        public void setupEmbeddedKotlinFor(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Interpreter.this.getHost().setupEmbeddedKotlinFor(scriptHost);
        }

        @Override
        public void applyPluginsTo(@NotNull KotlinScriptHost<?> scriptHost, @NotNull PluginRequests pluginRequests) {
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Intrinsics.checkNotNullParameter((Object)pluginRequests, (String)"pluginRequests");
            Interpreter.this.getHost().applyPluginsTo(scriptHost, pluginRequests);
        }

        @Override
        public void applyBasePluginsTo(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Interpreter.this.getHost().applyBasePluginsTo((ProjectInternal)project);
        }

        @Override
        public void handleScriptException(@NotNull Throwable exception, @NotNull Class<?> scriptClass, @NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter(scriptClass, (String)"scriptClass");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Void void_ = InterpreterKt.access$locationAwareExceptionHandlingFor(exception, scriptClass, scriptHost.getScriptSource());
            throw new KotlinNothingValueException();
        }

        @Override
        public void closeTargetScopeOf(@NotNull KotlinScriptHost<?> scriptHost) {
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Interpreter.this.getHost().closeTargetScopeOf(scriptHost);
        }

        @Override
        public void evaluateSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @NotNull ClassPath accessorsClassPath) {
            Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Intrinsics.checkNotNullParameter((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkNotNullParameter((Object)sourceHash, (String)"sourceHash");
            Intrinsics.checkNotNullParameter((Object)accessorsClassPath, (String)"accessorsClassPath");
            ClassLoaderScope targetScope = scriptHost.getTargetScope();
            ClassLoader classLoader = targetScope.getExportClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"targetScope.exportClassLoader");
            ClassLoader parentClassLoader = classLoader;
            Host host = Interpreter.this.getHost();
            ClassLoaderScope classLoaderScope = targetScope.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)classLoaderScope, (String)"targetScope.parent");
            ClassPath compileClassPath = host.compilationClassPathOf(classLoaderScope);
            ProgramId programId = new ProgramId(scriptTemplateId, sourceHash, parentClassLoader, Interpreter.this.getHost().hashOf(accessorsClassPath), Interpreter.this.getHost().hashOf(compileClassPath));
            CompiledScript cachedProgram = Interpreter.this.getHost().cachedClassFor(programId);
            if (cachedProgram != null) {
                this.eval(cachedProgram, scriptHost);
                return;
            }
            CompiledScript specializedProgram = program2.loadSecondStageFor(this, scriptHost, scriptTemplateId, sourceHash, accessorsClassPath);
            Interpreter.this.getHost().cache(specializedProgram, programId);
            this.eval(specializedProgram, scriptHost);
        }

        @Override
        @NotNull
        public ClassPath accessorsClassPathFor(@NotNull KotlinScriptHost<?> scriptHost) {
            Project project;
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Object obj = scriptHost.getTarget();
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.Project");
            }
            Project $this$serviceOf$iv = project = (Project)obj;
            boolean $i$f$serviceOf = false;
            Project project2 = $this$serviceOf$iv;
            if (project2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
            }
            ServiceRegistry serviceRegistry = ((ProjectInternal)project2).getServices();
            Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"(this as ProjectInternal).services");
            ServiceRegistry $this$get$iv$iv = serviceRegistry;
            boolean $i$f$get = false;
            Object object = $this$get$iv$iv.get(ProjectAccessorsClassPathGenerator.class);
            Intrinsics.checkNotNull((Object)object);
            ProjectAccessorsClassPathGenerator projectAccessorsClassPathGenerator = (ProjectAccessorsClassPathGenerator)object;
            return projectAccessorsClassPathGenerator.projectAccessorsClassPath(project, Interpreter.this.getHost().compilationClassPathOf(scriptHost.getTargetScope())).getBin();
        }

        @Override
        @NotNull
        public CompiledScript compileSecondStageOf(@NotNull ExecutableProgram.StagedProgram program2, @NotNull KotlinScriptHost<?> scriptHost, @NotNull String scriptTemplateId, @NotNull HashCode sourceHash, @NotNull ProgramKind programKind, @NotNull ProgramTarget programTarget, @NotNull ClassPath accessorsClassPath) {
            Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Intrinsics.checkNotNullParameter((Object)scriptTemplateId, (String)"scriptTemplateId");
            Intrinsics.checkNotNullParameter((Object)sourceHash, (String)"sourceHash");
            Intrinsics.checkNotNullParameter((Object)((Object)programKind), (String)"programKind");
            Intrinsics.checkNotNullParameter((Object)((Object)programTarget), (String)"programTarget");
            Intrinsics.checkNotNullParameter((Object)accessorsClassPath, (String)"accessorsClassPath");
            String originalScriptPath = scriptHost.getFileName();
            ClassLoaderScope targetScope = scriptHost.getTargetScope();
            ScriptSource scriptSource = scriptHost.getScriptSource();
            ClassPath targetScopeClassPath = Interpreter.this.getHost().compilationClassPathOf(targetScope);
            ClassPath compilationClassPath = targetScopeClassPath.plus(accessorsClassPath);
            Host host = Interpreter.this.getHost();
            ClassPath classPath = compilationClassPath;
            Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"compilationClassPath");
            File cacheDir2 = host.cachedDirFor(scriptHost, scriptTemplateId, sourceHash, classPath, accessorsClassPath, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this, scriptSource, scriptTemplateId, scriptHost, originalScriptPath, program2, compilationClassPath, sourceHash, programKind, programTarget){
                final /* synthetic */ ProgramHost this$0;
                final /* synthetic */ ScriptSource $scriptSource;
                final /* synthetic */ String $scriptTemplateId;
                final /* synthetic */ KotlinScriptHost $scriptHost;
                final /* synthetic */ String $originalScriptPath;
                final /* synthetic */ ExecutableProgram.StagedProgram $program;
                final /* synthetic */ ClassPath $compilationClassPath;
                final /* synthetic */ HashCode $sourceHash;
                final /* synthetic */ ProgramKind $programKind;
                final /* synthetic */ ProgramTarget $programTarget;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull File outputDir) {
                    Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
                    AutoCloseable autoCloseable = Interpreter.access$startCompilerOperationFor(this.this$0.Interpreter.this, this.$scriptSource, this.$scriptTemplateId);
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        AutoCloseable it = autoCloseable;
                        boolean bl3 = false;
                        ScriptSource $this$withLocationAwareExceptionHandling$iv = this.$scriptSource;
                        boolean $i$f$withLocationAwareExceptionHandling = false;
                        try {
                            void $this$withTemporaryScriptFileFor$iv;
                            boolean bl4 = false;
                            TemporaryFileProvider temporaryFileProvider2 = this.$scriptHost.getTemporaryFileProvider$kotlin_dsl();
                            String string2 = this.$originalScriptPath;
                            String scriptText$iv = this.$program.getSecondStageScriptText();
                            boolean $i$f$withTemporaryScriptFileFor = false;
                            File file = $this$withTemporaryScriptFileFor$iv.createTemporaryDirectory("gradle-kotlin-dsl-", null, new String[0]);
                            boolean bl5 = false;
                            boolean bl6 = false;
                            File tempDir$iv = file;
                            boolean bl7 = false;
                            try {
                                Unit unit2;
                                void scriptPath$iv;
                                File file2 = tempDir$iv;
                                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempDir");
                                File tempFile$iv = TemporaryScriptFilesKt.access$canonicalScriptFileFor(file2, (String)scriptPath$iv, scriptText$iv);
                                try {
                                    File scriptFile = tempFile$iv;
                                    boolean bl8 = false;
                                    ClassPath classPath = this.$compilationClassPath;
                                    Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"compilationClassPath");
                                    new ResidualProgramCompiler(outputDir, classPath, this.$sourceHash, this.$programKind, this.$programTarget, this.this$0.Interpreter.this.getHost().getImplicitImports(), InterpreterKt.getInterpreterLogger(), this.$scriptHost.getTemporaryFileProvider$kotlin_dsl(), (Function3)new Function3<String, String, Function0<? extends String>, String>(this.this$0.Interpreter.this.getHost()){

                                        @NotNull
                                        public final String invoke(@NotNull String p1, @NotNull String p2, @NotNull Function0<String> p3) {
                                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                                            Intrinsics.checkNotNullParameter(p3, (String)"p3");
                                            return ((Host)this.receiver).runCompileBuildOperation(p1, p2, p3);
                                        }
                                    }, null, null, null, 3584, null).emitStage2ProgramFor(scriptFile, this.$originalScriptPath);
                                    unit2 = Unit.INSTANCE;
                                }
                                finally {
                                    tempFile$iv.delete();
                                }
                                Unit unit3 = unit2;
                            }
                            finally {
                                tempDir$iv.delete();
                            }
                            Unit unit4 = Unit.INSTANCE;
                        }
                        catch (ScriptCompilationException e$iv) {
                            throw (Throwable)new LocationAwareException((Throwable)e$iv, $this$withLocationAwareExceptionHandling$iv, e$iv.getFirstErrorLine());
                        }
                        Unit unit5 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
                {
                    this.this$0 = programHost;
                    this.$scriptSource = scriptSource;
                    this.$scriptTemplateId = string2;
                    this.$scriptHost = kotlinScriptHost;
                    this.$originalScriptPath = string3;
                    this.$program = stagedProgram;
                    this.$compilationClassPath = classPath;
                    this.$sourceHash = hashCode;
                    this.$programKind = programKind;
                    this.$programTarget = programTarget;
                    super(1);
                }
            }));
            return Interpreter.this.loadClassInChildScopeOf(targetScope, originalScriptPath, cacheDir2, scriptTemplateId, accessorsClassPath, scriptSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void eval(@NotNull CompiledScript compiledScript, @NotNull KotlinScriptHost<?> scriptHost) {
            Thread currentThread$iv;
            Intrinsics.checkNotNullParameter((Object)compiledScript, (String)"compiledScript");
            Intrinsics.checkNotNullParameter(scriptHost, (String)"scriptHost");
            Class<?> program2 = this.load(compiledScript, scriptHost);
            ClassLoader classLoader = program2.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"program.classLoader");
            ClassLoader classLoader$iv = classLoader;
            boolean $i$f$withContextClassLoader = false;
            Thread thread = currentThread$iv = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread");
            ClassLoader previous$iv = thread.getContextClassLoader();
            try {
                currentThread$iv.setContextClassLoader(classLoader$iv);
                boolean bl = false;
                Interpreter.this.getHost().onScriptClassLoaded(scriptHost.getScriptSource(), program2);
                this.instantiate(program2).execute(this, scriptHost);
            }
            finally {
                currentThread$iv.setContextClassLoader(previous$iv);
            }
        }

        private final Class<?> load(CompiledScript compiledScript, KotlinScriptHost<?> scriptHost) {
            Class<?> clazz;
            try {
                clazz = compiledScript.getProgram();
            }
            catch (Exception e) {
                throw (Throwable)new LocationAwareException((Throwable)new GradleScriptException("Failed to load compiled script from classpath " + compiledScript.getClassPath() + '.', (Throwable)e), scriptHost.getScriptSource(), Integer.valueOf(1));
            }
            return clazz;
        }

        private final ExecutableProgram instantiate(Class<?> specializedProgram) {
            Object obj = specializedProgram.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.kotlin.dsl.execution.ExecutableProgram");
            }
            return (ExecutableProgram)obj;
        }
    }
}

