/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticCallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "backend.jvm.lower"})
public final class StaticCallableReferenceLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext backendContext;

    public StaticCallableReferenceLowering(@NotNull JvmBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        this.backendContext = backendContext;
    }

    @NotNull
    public final JvmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.transformChildrenVoid(declaration2);
        if (JvmIrUtilsKt.isSyntheticSingleton(declaration2)) {
            void $this$visitClass_u24lambda_u2d1_u24lambda_u2d0;
            IrField irField;
            Collection collection = declaration2.getDeclarations();
            IrField $this$visitClass_u24lambda_u2d1 = irField = this.backendContext.getCachedDeclarations().getFieldForObjectInstance(declaration2);
            boolean bl = false;
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.backendContext, (IrSymbol)$this$visitClass_u24lambda_u2d1.getSymbol(), 0, 0, 6, null);
            IrField irField2 = $this$visitClass_u24lambda_u2d1;
            boolean bl2 = false;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitClass_u24lambda_u2d1_u24lambda_u2d0;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$visitClass_u24lambda_u2d1_u24lambda_u2d0;
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(declaration2);
            Intrinsics.checkNotNull((Object)irConstructor2);
            irField2.setInitializer(ExpressionHelpersKt.irExprBody(irBuilderWithScope, ExpressionHelpersKt.irCall(irBuilderWithScope2, irConstructor2)));
            collection.add(irField);
        }
        return declaration2;
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass constructedClass = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)expression2.getSymbol().getOwner());
        if (!JvmIrUtilsKt.isSyntheticSingleton(constructedClass)) {
            return super.visitConstructorCall(expression2);
        }
        IrField instanceField = this.backendContext.getCachedDeclarations().getFieldForObjectInstance(constructedClass);
        return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), instanceField.getSymbol(), expression2.getType(), null, null, 48, null);
    }
}

