/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnexpectedTypeArgumentsError;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.FirQualifierResolver;
import org.jetbrains.kotlin.fir.resolve.FirQualifierResolverKt;
import org.jetbrains.kotlin.fir.resolve.FirTypeResolver;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.TreeResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeOuterClassArgumentsRequired;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedQualifierError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnsupportedDynamicType;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeWrongNumberOfTypeArgumentsError;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeArgumentList;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003MNOB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J?\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J*\u0010 \u001a\u00020!2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J!\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001c\u001a\u00020\u00172\b\u0010'\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010(J\u001c\u0010)\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J$\u0010,\u001a\u0004\u0018\u00010-2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J0\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030/2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u00100\u001a\u000201H\u0002JF\u00102\u001a\u001e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010/\u0012\u0006\u0012\u0004\u0018\u000104\u0012\u0006\u0012\u0004\u0018\u000105032\u0006\u0010\u001c\u001a\u0002062\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<H\u0002JH\u0010=\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0006\u0012\u0004\u0018\u0001050>2\u0006\u0010\u001c\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<H\u0016JB\u0010C\u001a\u00020?2\u0006\u0010\u001c\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u0010D\u001a\u0004\u0018\u0001042\u0006\u0010@\u001a\u00020A2\b\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010B\u001a\u00020AH\u0002J2\u0010G\u001a\u00020A*\b\u0012\u0002\b\u0003\u0018\u00010/2\b\u00109\u001a\u0004\u0018\u00010:2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020F0#2\u0006\u0010;\u001a\u00020<H\u0002J*\u0010I\u001a\n\u0012\u0004\u0012\u00020K\u0018\u00010J*\u0002012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010L\u001a\u00020+H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirTypeResolver;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "implicitBuiltinTypeSymbols", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ClassIdInSession;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "symbolProvider$delegate", "Lkotlin/Lazy;", "createDiagnosticsIfExists", "Lorg/jetbrains/kotlin/fir/types/ConeClassErrorType;", "parameterClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "qualifierPartIndex", "", "symbol", "userTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "qualifierPartArgumentsCount", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;ILorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/fir/types/ConeClassErrorType;", "createFunctionalType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "getActualTypeParametersCount", "element", "getClassesAlignedToQualifierParts", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ParametersMapAndOuterClasses;", "qualifier", "", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "getTypeArgumentsOrNameSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "qualifierIndex", "(Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/KtSourceElement;", "resolveBuiltInQualified", "id", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveLocalClassChain", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "resolveSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "qualifierResolver", "Lorg/jetbrains/kotlin/fir/resolve/FirQualifierResolver;", "resolveToSymbol", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "scopeClassDeclaration", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "supertypeSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "resolveType", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "areBareTypesAllowed", "", "isOperandOfIsOperator", "resolveUserType", "substitutor", "topContainer", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isVisible", "containingDeclarations", "resolveEnumEntrySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "classId", "ClassIdInSession", "ClassWithQualifierPartIndex", "ParametersMapAndOuterClasses", "resolve"})
public final class FirTypeResolverImpl
extends FirTypeResolver {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy symbolProvider$delegate;
    @NotNull
    private final Map<ClassIdInSession, FirClassLikeSymbol<?>> implicitBuiltinTypeSymbols;

    public FirTypeResolverImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.symbolProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirSymbolProvider>(this){
            final /* synthetic */ FirTypeResolverImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FirSymbolProvider invoke() {
                return FirSymbolProviderKt.getSymbolProvider(FirTypeResolverImpl.access$getSession$p(this.this$0));
            }
        }));
        this.implicitBuiltinTypeSymbols = new LinkedHashMap();
    }

    private final FirSymbolProvider getSymbolProvider() {
        Lazy lazy = this.symbolProvider$delegate;
        return (FirSymbolProvider)lazy.getValue();
    }

    private final FirClassLikeSymbol<?> resolveBuiltInQualified(ClassId id, FirSession session2) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ClassIdInSession nameInSession = new ClassIdInSession(session2, id);
        Map<ClassIdInSession, FirClassLikeSymbol<?>> $this$getOrPut$iv = this.implicitBuiltinTypeSymbols;
        boolean $i$f$getOrPut = false;
        FirClassLikeSymbol<?> value$iv = $this$getOrPut$iv.get(nameInSession);
        if (value$iv == null) {
            boolean bl = false;
            FirClassLikeSymbol<?> firClassLikeSymbol2 = this.getSymbolProvider().getClassLikeSymbolByClassId(id);
            Intrinsics.checkNotNull(firClassLikeSymbol2);
            FirClassLikeSymbol<?> answer$iv = firClassLikeSymbol2;
            $this$getOrPut$iv.put(nameInSession, answer$iv);
            firClassLikeSymbol = answer$iv;
        } else {
            firClassLikeSymbol = value$iv;
        }
        return firClassLikeSymbol;
    }

    private final FirBasedSymbol<?> resolveSymbol(FirBasedSymbol<?> symbol2, List<? extends FirQualifierPart> qualifier, FirQualifierResolver qualifierResolver) {
        FirBasedSymbol firBasedSymbol;
        FirBasedSymbol firBasedSymbol2 = symbol2;
        if (firBasedSymbol2 instanceof FirClassLikeSymbol) {
            if (qualifier.size() == 1) {
                firBasedSymbol = symbol2;
            } else {
                FirRegularClassSymbol firRegularClassSymbol = this.resolveLocalClassChain((FirClassLikeSymbol)symbol2, qualifier);
                if (firRegularClassSymbol != null) {
                    firBasedSymbol = firRegularClassSymbol;
                } else {
                    FirClassifierSymbol<?> firClassifierSymbol = qualifierResolver.resolveSymbolWithPrefix(qualifier, ((FirClassLikeSymbol)symbol2).getClassId());
                    firBasedSymbol = firClassifierSymbol != null ? (FirBasedSymbol)firClassifierSymbol : (FirBasedSymbol)this.resolveEnumEntrySymbol(qualifierResolver, qualifier, ((FirClassLikeSymbol)symbol2).getClassId());
                }
            }
        } else if (firBasedSymbol2 instanceof FirTypeParameterSymbol) {
            boolean bl;
            boolean bl2 = bl = qualifier.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            firBasedSymbol = symbol2;
        } else {
            throw new IllegalStateException("!".toString());
        }
        return firBasedSymbol;
    }

    private final boolean isVisible(FirBasedSymbol<?> $this$isVisible, FirFile useSiteFile, List<? extends FirDeclaration> containingDeclarations, SupertypeSupplier supertypeSupplier) {
        FirBasedSymbol<?> firBasedSymbol = $this$isVisible;
        Object declaration2 = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return useSiteFile != null && declaration2 instanceof FirMemberDeclaration ? FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(this.session), (FirMemberDeclaration)declaration2, this.session, useSiteFile, containingDeclarations, null, false, false, supertypeSupplier, 64, null) : true;
    }

    /*
     * WARNING - void declaration
     */
    private final Triple<FirBasedSymbol<?>, ConeSubstitutor, ConeDiagnostic> resolveToSymbol(FirTypeRef typeRef, ScopeClassDeclaration scopeClassDeclaration, FirFile useSiteFile, SupertypeSupplier supertypeSupplier) {
        Triple triple;
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef instanceof FirResolvedTypeRef) {
            FirClassifierSymbol<?> firClassifierSymbol;
            Object object;
            FirTypeRef $this$coneTypeSafe$iv = typeRef;
            boolean $i$f$coneTypeSafe2 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                coneKotlinType = null;
            }
            if ((object = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType))) != null && (object = ((ConeLookupTagBasedType)object).getLookupTag()) != null) {
                Object $i$f$coneTypeSafe2 = object;
                FirSymbolProvider firSymbolProvider = this.getSymbolProvider();
                Object p0 = $i$f$coneTypeSafe2;
                boolean bl = false;
                firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag(firSymbolProvider, (ConeClassifierLookupTag)p0);
            } else {
                firClassifierSymbol = null;
            }
            FirClassifierSymbol<?> resultSymbol = firClassifierSymbol;
            triple = new Triple(resultSymbol, null, null);
        } else if (firTypeRef instanceof FirUserTypeRef) {
            FirQualifierResolver qualifierResolver = FirQualifierResolverKt.getQualifierResolver(this.session);
            Ref.ObjectRef acceptedSymbol = new Ref.ObjectRef();
            Ref.ObjectRef substitutor2 = new Ref.ObjectRef();
            List notApplicableSymbols = new ArrayList();
            List<FirQualifierPart> qualifier = ((FirUserTypeRef)typeRef).getQualifier();
            List<FirScope> scopes = scopeClassDeclaration.getScopes();
            List<FirDeclaration> containingDeclarations = scopeClassDeclaration.getContainingDeclarations();
            for (FirScope scope2 : scopes) {
                if (acceptedSymbol.element != null) break;
                boolean collectNonApplicable = notApplicableSymbols.isEmpty();
                scope2.processClassifiersByNameWithSubstitution(((FirQualifierPart)CollectionsKt.first(qualifier)).getName(), (Function2)new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(acceptedSymbol, this, qualifier, qualifierResolver, useSiteFile, containingDeclarations, supertypeSupplier, (Ref.ObjectRef<ConeSubstitutor>)substitutor2, collectNonApplicable, notApplicableSymbols){
                    final /* synthetic */ Ref.ObjectRef<FirBasedSymbol<?>> $acceptedSymbol;
                    final /* synthetic */ FirTypeResolverImpl this$0;
                    final /* synthetic */ List<FirQualifierPart> $qualifier;
                    final /* synthetic */ FirQualifierResolver $qualifierResolver;
                    final /* synthetic */ FirFile $useSiteFile;
                    final /* synthetic */ List<FirDeclaration> $containingDeclarations;
                    final /* synthetic */ SupertypeSupplier $supertypeSupplier;
                    final /* synthetic */ Ref.ObjectRef<ConeSubstitutor> $substitutor;
                    final /* synthetic */ boolean $collectNonApplicable;
                    final /* synthetic */ List<Pair<FirBasedSymbol<?>, ConeSubstitutor>> $notApplicableSymbols;
                    {
                        this.$acceptedSymbol = $acceptedSymbol;
                        this.this$0 = $receiver;
                        this.$qualifier = $qualifier;
                        this.$qualifierResolver = $qualifierResolver;
                        this.$useSiteFile = $useSiteFile;
                        this.$containingDeclarations = $containingDeclarations;
                        this.$supertypeSupplier = $supertypeSupplier;
                        this.$substitutor = $substitutor;
                        this.$collectNonApplicable = $collectNonApplicable;
                        this.$notApplicableSymbols = $notApplicableSymbols;
                        super(2);
                    }

                    public final void invoke(@NotNull FirClassifierSymbol<?> symbol2, @NotNull ConeSubstitutor substitutorFromScope) {
                        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
                        Intrinsics.checkNotNullParameter((Object)substitutorFromScope, (String)"substitutorFromScope");
                        if (this.$acceptedSymbol.element != null) {
                            return;
                        }
                        FirBasedSymbol firBasedSymbol = FirTypeResolverImpl.access$resolveSymbol(this.this$0, symbol2, this.$qualifier, this.$qualifierResolver);
                        if (firBasedSymbol == null) {
                            return;
                        }
                        FirBasedSymbol resolvedSymbol = firBasedSymbol;
                        if (FirTypeResolverImpl.access$isVisible(this.this$0, resolvedSymbol, this.$useSiteFile, this.$containingDeclarations, this.$supertypeSupplier)) {
                            this.$acceptedSymbol.element = resolvedSymbol;
                            this.$substitutor.element = substitutorFromScope;
                        } else if (this.$collectNonApplicable) {
                            FirTypeResolverImpl.access$isVisible(this.this$0, resolvedSymbol, this.$useSiteFile, this.$containingDeclarations, this.$supertypeSupplier);
                            ((Collection)this.$notApplicableSymbols).add(TuplesKt.to((Object)resolvedSymbol, (Object)substitutorFromScope));
                        }
                    }
                });
            }
            if (acceptedSymbol.element != null) {
                triple = new Triple(acceptedSymbol.element, substitutor2.element, null);
            } else if (notApplicableSymbols.size() == 1) {
                Pair pair = (Pair)CollectionsKt.single((List)notApplicableSymbols);
                FirBasedSymbol notApplicableSymbol = (FirBasedSymbol)pair.component1();
                ConeSubstitutor resultingSubstitutor2 = (ConeSubstitutor)pair.component2();
                triple = new Triple((Object)notApplicableSymbol, (Object)resultingSubstitutor2, (Object)new ConeVisibilityError(notApplicableSymbol));
            } else {
                ConeVisibilityError coneVisibilityError;
                void condition$iv;
                FirClassifierSymbol<?> symbolFromQualifier = qualifierResolver.resolveSymbol(qualifier);
                boolean resultingSubstitutor2 = symbolFromQualifier != null && !this.isVisible((FirBasedSymbol)symbolFromQualifier, useSiteFile, containingDeclarations, supertypeSupplier);
                boolean $i$f$runIf = false;
                if (condition$iv != false) {
                    boolean bl = false;
                    FirClassifierSymbol<?> firClassifierSymbol = symbolFromQualifier;
                    Intrinsics.checkNotNull(firClassifierSymbol);
                    coneVisibilityError = new ConeVisibilityError((FirBasedSymbol)firClassifierSymbol);
                } else {
                    coneVisibilityError = null;
                }
                ConeVisibilityError diagnostic = coneVisibilityError;
                triple = new Triple(symbolFromQualifier, null, (Object)diagnostic);
            }
        } else {
            triple = firTypeRef instanceof FirImplicitBuiltinTypeRef ? new Triple(this.resolveBuiltInQualified(((FirImplicitBuiltinTypeRef)typeRef).getId(), this.session), null, null) : new Triple(null, null, null);
        }
        return triple;
    }

    private final FirRegularClassSymbol resolveLocalClassChain(FirClassLikeSymbol<?> symbol2, List<? extends FirQualifierPart> qualifier) {
        block3: {
            block2: {
                if (!(symbol2 instanceof FirRegularClassSymbol)) break block2;
                FirClassLikeSymbol<?> $this$isLocal$iv = symbol2;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getClassId().isLocal()) break block3;
            }
            return null;
        }
        return FirTypeResolverImpl.resolveLocalClassChain$resolveLocalClassChain(qualifier, (FirRegularClassSymbol)symbol2, 1);
    }

    /*
     * WARNING - void declaration
     */
    private final FirVariableSymbol<FirEnumEntry> resolveEnumEntrySymbol(FirQualifierResolver $this$resolveEnumEntrySymbol, List<? extends FirQualifierPart> qualifier, ClassId classId) {
        FirEnumEntry enumEntryMatchingLastQualifier;
        Object v2;
        block4: {
            void $this$firstOrNull$iv;
            FirClassifierSymbol<?> firClassifierSymbol = $this$resolveEnumEntrySymbol.resolveSymbolWithPrefix(CollectionsKt.dropLast(qualifier, (int)1), classId);
            if (firClassifierSymbol == null) {
                return null;
            }
            FirClassifierSymbol<?> enumClassSymbol = firClassifierSymbol;
            Object e = enumClassSymbol.getFir();
            FirRegularClass firRegularClass = e instanceof FirRegularClass ? (FirRegularClass)e : null;
            if (firRegularClass == null) {
                return null;
            }
            FirRegularClass enumClassFir = firRegularClass;
            FirClass $this$isEnumClass$iv = enumClassFir;
            boolean $i$f$isEnumClass = false;
            Object $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
                return null;
            }
            $this$isEnumClass$iv$iv = enumClassFir.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirEnumEntry && Intrinsics.areEqual((Object)((FirEnumEntry)it).getName(), (Object)((FirQualifierPart)CollectionsKt.last(qualifier)).getName()))) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Object var7_7 = v2;
        FirEnumEntry firEnumEntry = enumEntryMatchingLastQualifier = var7_7 instanceof FirEnumEntry ? (FirEnumEntry)var7_7 : null;
        return firEnumEntry != null ? firEnumEntry.getSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType resolveUserType(FirUserTypeRef typeRef, FirBasedSymbol<?> symbol2, ConeSubstitutor substitutor2, boolean areBareTypesAllowed, FirDeclaration topContainer, boolean isOperandOfIsOperator) {
        ConeLookupTagBasedType coneLookupTagBasedType;
        if (symbol2 == null || !(symbol2 instanceof FirClassifierSymbol)) {
            FirBasedSymbol<?> firBasedSymbol = symbol2;
            ConeDiagnostic diagnostic = (firBasedSymbol != null ? firBasedSymbol.getFir() : null) instanceof FirEnumEntry ? (ConeDiagnostic)(isOperandOfIsOperator ? new ConeSimpleDiagnostic("'is' operator can not be applied to an enum entry.", DiagnosticKind.IsEnumEntry) : new ConeSimpleDiagnostic("An enum entry should not be used as a type.", DiagnosticKind.EnumEntryAsType)) : (ConeDiagnostic)new ConeUnresolvedQualifierError(FirRendererKt.render$default(typeRef, null, 1, null));
            return new ConeClassErrorType(diagnostic, false, 2, null);
        }
        if (symbol2 instanceof FirTypeParameterSymbol) {
            for (FirQualifierPart part : typeRef.getQualifier()) {
                if (!(!((Collection)part.getTypeArgumentList().getTypeArguments()).isEmpty())) continue;
                return new ConeClassErrorType(new ConeUnexpectedTypeArgumentsError("Type arguments not allowed", part.getTypeArgumentList().getSource()), false, 2, null);
            }
        }
        List allTypeArguments = new ArrayList();
        int typeArgumentsCount = 0;
        List<FirQualifierPart> qualifier = typeRef.getQualifier();
        for (int qualifierIndex = qualifier.size() - 1; -1 < qualifierIndex; --qualifierIndex) {
            List<FirTypeProjection> qualifierTypeArguments = qualifier.get(qualifierIndex).getTypeArgumentList().getTypeArguments();
            for (FirTypeProjection firTypeProjection : qualifierTypeArguments) {
                allTypeArguments.add(FirTypeUtilsKt.toConeTypeProjection(firTypeProjection));
                ++typeArgumentsCount;
            }
        }
        if (symbol2 instanceof FirRegularClassSymbol) {
            boolean isPossibleBareType;
            boolean bl = isPossibleBareType = areBareTypesAllowed && allTypeArguments.isEmpty();
            if (!isPossibleBareType) {
                int n;
                Object it;
                Object t;
                Object object;
                ConeSubstitutor coneSubstitutor = substitutor2;
                if (coneSubstitutor == null) {
                    coneSubstitutor = ConeSubstitutor.Empty.INSTANCE;
                }
                ConeSubstitutor actualSubstitutor = coneSubstitutor;
                List<FirTypeParameterRef> originalTypeParameters = ((FirRegularClass)((FirRegularClassSymbol)symbol2).getFir()).getTypeParameters();
                ParametersMapAndOuterClasses parametersMapAndOuterClasses = this.getClassesAlignedToQualifierParts((FirClassLikeSymbol)symbol2, qualifier, this.session);
                Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> typeParametersAlignedToQualifierParts = parametersMapAndOuterClasses.component1();
                List<FirClassLikeDeclaration> outerDeclarations = parametersMapAndOuterClasses.component2();
                if ((FirClassifierSymbol)symbol2 instanceof FirTypeAliasSymbol) {
                    Iterable iterable = outerDeclarations;
                    int n2 = 0;
                    object = iterable.iterator();
                    while (object.hasNext()) {
                        int n3;
                        t = object.next();
                        FirClassLikeDeclaration firClassLikeDeclaration = (FirClassLikeDeclaration)t;
                        int n4 = n2;
                        boolean bl2 = false;
                        if (it != null) {
                            void d;
                            boolean bl3 = false;
                            n3 = this.getActualTypeParametersCount((FirClassLikeDeclaration)d);
                        } else {
                            n3 = 0;
                        }
                        int n5 = n3;
                        n2 = n4 + n5;
                    }
                    n = n2;
                } else {
                    n = ((FirRegularClassSymbol)symbol2).getTypeParameterSymbols().size();
                }
                int actualTypeParametersCount = n;
                Iterator<FirTypeParameterRef> iterator2 = originalTypeParameters.iterator();
                int n6 = 0;
                while (iterator2.hasNext()) {
                    int typeParameterIndex = n6++;
                    FirTypeParameterRef typeParameter = iterator2.next();
                    if (typeParametersAlignedToQualifierParts.get(typeParameter.getSymbol()) == null) continue;
                    FirClassLikeDeclaration parameterClass = ((ClassWithQualifierPartIndex)t).component1();
                    int qualifierPartIndex = ((ClassWithQualifierPartIndex)t).component2();
                    if (typeParameterIndex < typeArgumentsCount) {
                        int qualifierPartArgumentsCount = qualifier.get(qualifierPartIndex).getTypeArgumentList().getTypeArguments().size();
                        ConeClassErrorType bl3 = this.createDiagnosticsIfExists(parameterClass, qualifierPartIndex, (FirClassLikeSymbol)symbol2, typeRef, qualifierPartArgumentsCount);
                        if (bl3 == null) continue;
                        ConeClassErrorType it2 = bl3;
                        boolean bl4 = false;
                        return it2;
                    }
                    if (!(typeParameter instanceof FirOuterClassTypeParameterRef) || DeclarationUtilsKt.isValidTypeParameterFromOuterDeclaration(typeParameter.getSymbol(), topContainer, this.session)) {
                        ConeTypeParameterTypeImpl type2 = new ConeTypeParameterTypeImpl(new ConeTypeParameterLookupTag(typeParameter.getSymbol()), false, null, 4, null);
                        ConeKotlinType substituted = actualSubstitutor.substituteOrNull(type2);
                        if (substituted == null) {
                            ConeClassErrorType coneClassErrorType = this.createDiagnosticsIfExists(parameterClass, qualifierPartIndex, (FirClassLikeSymbol)symbol2, typeRef, null);
                            if (coneClassErrorType == null) continue;
                            ConeClassErrorType it3 = coneClassErrorType;
                            boolean bl5 = false;
                            return it3;
                        }
                        allTypeArguments.add(substituted);
                        continue;
                    }
                    return new ConeClassErrorType(new ConeOuterClassArgumentsRequired(parameterClass.getSymbol()), false, 2, null);
                }
                if (typeArgumentsCount > actualTypeParametersCount) {
                    n6 = qualifier.size();
                    for (int index2 = 0; index2 < n6; ++index2) {
                        FirClassLikeDeclaration parameterClass;
                        if (!(!((Collection)qualifier.get(index2).getTypeArgumentList().getTypeArguments()).isEmpty()) || (object = this.createDiagnosticsIfExists(parameterClass = (FirClassLikeDeclaration)CollectionsKt.getOrNull(outerDeclarations, (int)index2), index2, (FirClassLikeSymbol)symbol2, typeRef, null)) == null) continue;
                        it = object;
                        boolean bl6 = false;
                        return (ConeKotlinType)it;
                    }
                }
            }
        }
        Collection $this$toTypedArray$iv = allTypeArguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ConeLookupTagBasedType it = coneLookupTagBasedType = TreeResolveUtilsKt.constructType((FirClassifierSymbol)symbol2, coneTypeProjectionArray, typeRef.isMarkedNullable(), FirTypeUtilsKt.computeTypeAttributes(typeRef.getAnnotations(), this.session));
        boolean bl = false;
        ConeClassifierLookupTag coneClassifierLookupTag = it.getLookupTag();
        if (coneClassifierLookupTag instanceof ConeClassLikeLookupTagImpl && symbol2 instanceof FirClassLikeSymbol) {
            LookupTagUtilsKt.bindSymbolToLookupTag((ConeClassLikeLookupTagImpl)coneClassifierLookupTag, this.session, (FirClassLikeSymbol)symbol2);
        }
        return coneLookupTagBasedType;
    }

    private final ParametersMapAndOuterClasses getClassesAlignedToQualifierParts(FirClassLikeSymbol<?> symbol2, List<? extends FirQualifierPart> qualifier, FirSession session2) {
        FirClassLikeDeclaration currentClassLikeDeclaration = null;
        List outerDeclarations = new ArrayList();
        for (int qualifierPartIndex = 0; qualifierPartIndex < qualifier.size() || currentClassLikeDeclaration != null; ++qualifierPartIndex) {
            if (qualifierPartIndex == 0) {
                currentClassLikeDeclaration = (FirClassLikeDeclaration)symbol2.getFir();
            } else if (currentClassLikeDeclaration != null) {
                currentClassLikeDeclaration = DeclarationUtilsKt.getContainingDeclaration(currentClassLikeDeclaration, session2);
            }
            outerDeclarations.add(currentClassLikeDeclaration);
        }
        int outerArgumentsCount = outerDeclarations.size() - qualifier.size();
        List reversedOuterClasses = CollectionsKt.asReversedMutable((List)outerDeclarations);
        Map result2 = new LinkedHashMap();
        int n = reversedOuterClasses.size();
        for (int index2 = 0; index2 < n; ++index2) {
            List<FirTypeParameter> typeParameters2;
            currentClassLikeDeclaration = (FirClassLikeDeclaration)reversedOuterClasses.get(index2);
            FirClassLikeDeclaration firClassLikeDeclaration = currentClassLikeDeclaration;
            List<FirTypeParameterRef> list2 = firClassLikeDeclaration instanceof FirTypeAlias ? ((FirTypeAlias)currentClassLikeDeclaration).getTypeParameters() : (typeParameters2 = firClassLikeDeclaration instanceof FirClass ? ((FirClass)currentClassLikeDeclaration).getTypeParameters() : null);
            if (currentClassLikeDeclaration == null || typeParameters2 == null) continue;
            for (FirTypeParameterRef firTypeParameterRef : typeParameters2) {
                FirTypeParameterSymbol typeParameterSymbol = firTypeParameterRef.getSymbol();
                if (result2.containsKey(typeParameterSymbol)) continue;
                result2.put(typeParameterSymbol, new ClassWithQualifierPartIndex(currentClassLikeDeclaration, index2 - outerArgumentsCount));
            }
        }
        return new ParametersMapAndOuterClasses(result2, CollectionsKt.drop((Iterable)reversedOuterClasses, (int)outerArgumentsCount));
    }

    private final ConeClassErrorType createDiagnosticsIfExists(FirClassLikeDeclaration parameterClass, int qualifierPartIndex, FirClassLikeSymbol<?> symbol2, FirUserTypeRef userTypeRef, Integer qualifierPartArgumentsCount) {
        KtSourceElement source;
        FirClassLikeDeclaration firClassLikeDeclaration = parameterClass;
        if (firClassLikeDeclaration == null) {
            firClassLikeDeclaration = (FirClassLikeDeclaration)symbol2.getFir();
        }
        int actualTypeParametersCount = this.getActualTypeParametersCount(firClassLikeDeclaration);
        if ((qualifierPartArgumentsCount == null || actualTypeParametersCount != qualifierPartArgumentsCount) && (source = this.getTypeArgumentsOrNameSource(userTypeRef, qualifierPartIndex)) != null) {
            Object object = parameterClass;
            if (object == null || (object = ((FirClassLikeDeclaration)object).getSymbol()) == null) {
                object = symbol2;
            }
            return new ConeClassErrorType(new ConeWrongNumberOfTypeArgumentsError(actualTypeParametersCount, (FirClassLikeSymbol<?>)object, source), false, 2, null);
        }
        return null;
    }

    private final int getActualTypeParametersCount(FirClassLikeDeclaration element) {
        int n;
        Iterable $this$count$iv = ((FirTypeParameterRefsOwner)element).getTypeParameters();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl = false;
                if (!(!(it instanceof FirOuterClassTypeParameterRef)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    private final KtSourceElement getTypeArgumentsOrNameSource(FirUserTypeRef typeRef, Integer qualifierIndex) {
        Object object;
        FirTypeArgumentList typeArgumentsList;
        FirQualifierPart qualifierPart;
        FirQualifierPart firQualifierPart;
        Integer n = qualifierIndex;
        if (n != null) {
            int n2 = n;
            firQualifierPart = (FirQualifierPart)CollectionsKt.getOrNull(typeRef.getQualifier(), (int)n2);
        } else {
            firQualifierPart = null;
        }
        FirQualifierPart firQualifierPart2 = qualifierPart = firQualifierPart;
        FirTypeArgumentList firTypeArgumentList = typeArgumentsList = firQualifierPart2 != null ? firQualifierPart2.getTypeArgumentList() : null;
        if (typeArgumentsList == null || typeArgumentsList.getTypeArguments().isEmpty()) {
            object = qualifierPart;
            if (object == null || (object = object.getSource()) == null) {
                object = typeRef.getSource();
            }
        } else {
            object = typeArgumentsList.getSource();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeClassLikeType createFunctionalType(FirFunctionTypeRef typeRef) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FirTypeRef firTypeRef = typeRef.getReceiverTypeRef();
        Iterable iterable = typeRef.getValueParameters();
        Collection collection = CollectionsKt.listOfNotNull((Object)(firTypeRef != null ? FirTypeUtilsKt.getConeType(firTypeRef) : null));
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(LookupTagUtilsKt.withParameterNameAnnotation(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), (FirValueParameter)it, TypeComponentsKt.getTypeContext(this.session)));
        }
        List parameters2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (Iterable)CollectionsKt.listOf((Object)FirTypeUtilsKt.getConeType(typeRef.getReturnTypeRef())));
        ClassId classId = typeRef.isSuspend() ? StandardClassIds.INSTANCE.SuspendFunctionN(FirTypeUtilsKt.getParametersCount(typeRef)) : StandardClassIds.INSTANCE.FunctionN(FirTypeUtilsKt.getParametersCount(typeRef));
        ConeAttributes attributes2 = FirTypeUtilsKt.computeTypeAttributes(typeRef.getAnnotations(), this.session);
        FirClassLikeSymbol<?> symbol2 = this.resolveBuiltInQualified(classId, this.session);
        Object it = destination$iv$iv = symbol2.toLookupTag();
        boolean bl = false;
        if (it instanceof ConeClassLikeLookupTagImpl) {
            LookupTagUtilsKt.bindSymbolToLookupTag((ConeClassLikeLookupTagImpl)it, this.session, symbol2);
        }
        Collection $this$toTypedArray$iv = parameters2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeKotlinType[] coneKotlinTypeArray = thisCollection$iv.toArray(new ConeKotlinType[0]);
        if (coneKotlinTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ConeAttributes coneAttributes = attributes2;
        boolean bl2 = typeRef.isMarkedNullable();
        ConeTypeProjection[] coneTypeProjectionArray = coneKotlinTypeArray;
        Object object = destination$iv$iv;
        return new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)object, coneTypeProjectionArray, bl2, coneAttributes);
    }

    @Override
    @NotNull
    public Pair<ConeKotlinType, ConeDiagnostic> resolveType(@NotNull FirTypeRef typeRef, @NotNull ScopeClassDeclaration scopeClassDeclaration, boolean areBareTypesAllowed, boolean isOperandOfIsOperator, @Nullable FirFile useSiteFile, @NotNull SupertypeSupplier supertypeSupplier) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)scopeClassDeclaration, (String)"scopeClassDeclaration");
        Intrinsics.checkNotNullParameter((Object)supertypeSupplier, (String)"supertypeSupplier");
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef instanceof FirResolvedTypeRef) {
            pair = TuplesKt.to((Object)((FirResolvedTypeRef)typeRef).getType(), null);
        } else if (firTypeRef instanceof FirUserTypeRef) {
            Triple<FirBasedSymbol<?>, ConeSubstitutor, ConeDiagnostic> triple = this.resolveToSymbol(typeRef, scopeClassDeclaration, useSiteFile, supertypeSupplier);
            FirBasedSymbol symbol2 = (FirBasedSymbol)triple.component1();
            ConeSubstitutor substitutor2 = (ConeSubstitutor)triple.component2();
            ConeDiagnostic diagnostic = (ConeDiagnostic)triple.component3();
            FirUserTypeRef firUserTypeRef = (FirUserTypeRef)typeRef;
            FirDeclaration firDeclaration = scopeClassDeclaration.getTopContainer();
            if (firDeclaration == null) {
                firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(scopeClassDeclaration.getContainingDeclarations());
            }
            pair = TuplesKt.to((Object)this.resolveUserType(firUserTypeRef, symbol2, substitutor2, areBareTypesAllowed, firDeclaration, isOperandOfIsOperator), (Object)diagnostic);
        } else if (firTypeRef instanceof FirFunctionTypeRef) {
            pair = TuplesKt.to((Object)this.createFunctionalType((FirFunctionTypeRef)typeRef), null);
        } else if (firTypeRef instanceof FirDynamicTypeRef) {
            pair = TuplesKt.to((Object)new ConeClassErrorType(new ConeUnsupportedDynamicType(), false, 2, null), null);
        } else {
            throw new IllegalStateException(FirRendererKt.render$default(typeRef, null, 1, null).toString());
        }
        return pair;
    }

    private static final FirRegularClassSymbol resolveLocalClassChain$resolveLocalClassChain(List<? extends FirQualifierPart> $qualifier, FirRegularClassSymbol classSymbol, int qualifierIndex) {
        if (qualifierIndex == $qualifier.size()) {
            return classSymbol;
        }
        Name qualifierName = $qualifier.get(qualifierIndex).getName();
        for (FirBasedSymbol<?> declarationSymbol : classSymbol.getDeclarationSymbols()) {
            if (!(declarationSymbol instanceof FirRegularClassSymbol) || !Intrinsics.areEqual((Object)((FirRegularClassSymbol)declarationSymbol).toLookupTag().getName(), (Object)qualifierName)) continue;
            return FirTypeResolverImpl.resolveLocalClassChain$resolveLocalClassChain($qualifier, (FirRegularClassSymbol)declarationSymbol, qualifierIndex + 1);
        }
        return null;
    }

    public static final /* synthetic */ FirBasedSymbol access$resolveSymbol(FirTypeResolverImpl $this, FirBasedSymbol symbol2, List qualifier, FirQualifierResolver qualifierResolver) {
        return $this.resolveSymbol(symbol2, qualifier, qualifierResolver);
    }

    public static final /* synthetic */ boolean access$isVisible(FirTypeResolverImpl $this, FirBasedSymbol $receiver, FirFile useSiteFile, List containingDeclarations, SupertypeSupplier supertypeSupplier) {
        return $this.isVisible($receiver, useSiteFile, containingDeclarations, supertypeSupplier);
    }

    public static final /* synthetic */ FirSession access$getSession$p(FirTypeResolverImpl $this) {
        return $this.session;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ClassIdInSession;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "id", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;)V", "getId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    private static final class ClassIdInSession {
        @NotNull
        private final FirSession session;
        @NotNull
        private final ClassId id;

        public ClassIdInSession(@NotNull FirSession session2, @NotNull ClassId id) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.session = session2;
            this.id = id;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final ClassId getId() {
            return this.id;
        }

        @NotNull
        public final FirSession component1() {
            return this.session;
        }

        @NotNull
        public final ClassId component2() {
            return this.id;
        }

        @NotNull
        public final ClassIdInSession copy(@NotNull FirSession session2, @NotNull ClassId id) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new ClassIdInSession(session2, id);
        }

        public static /* synthetic */ ClassIdInSession copy$default(ClassIdInSession classIdInSession, FirSession firSession, ClassId classId, int n, Object object) {
            if ((n & 1) != 0) {
                firSession = classIdInSession.session;
            }
            if ((n & 2) != 0) {
                classId = classIdInSession.id;
            }
            return classIdInSession.copy(firSession, classId);
        }

        @NotNull
        public String toString() {
            return "ClassIdInSession(session=" + this.session + ", id=" + this.id + ')';
        }

        public int hashCode() {
            int result2 = this.session.hashCode();
            result2 = result2 * 31 + this.id.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassIdInSession)) {
                return false;
            }
            ClassIdInSession classIdInSession = (ClassIdInSession)other;
            if (!Intrinsics.areEqual((Object)this.session, (Object)classIdInSession.session)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.id, (Object)classIdInSession.id);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0011\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0003J1\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ParametersMapAndOuterClasses;", "", "parameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ClassWithQualifierPartIndex;", "outerClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "(Ljava/util/Map;Ljava/util/List;)V", "getOuterClasses", "()Ljava/util/List;", "getParameters", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolve"})
    private static final class ParametersMapAndOuterClasses {
        @NotNull
        private final Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> parameters;
        @NotNull
        private final List<FirClassLikeDeclaration> outerClasses;

        public ParametersMapAndOuterClasses(@NotNull Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> parameters2, @NotNull List<? extends FirClassLikeDeclaration> outerClasses2) {
            Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
            Intrinsics.checkNotNullParameter(outerClasses2, (String)"outerClasses");
            this.parameters = parameters2;
            this.outerClasses = outerClasses2;
        }

        @NotNull
        public final Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> getParameters() {
            return this.parameters;
        }

        @NotNull
        public final List<FirClassLikeDeclaration> getOuterClasses() {
            return this.outerClasses;
        }

        @NotNull
        public final Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> component1() {
            return this.parameters;
        }

        @NotNull
        public final List<FirClassLikeDeclaration> component2() {
            return this.outerClasses;
        }

        @NotNull
        public final ParametersMapAndOuterClasses copy(@NotNull Map<FirTypeParameterSymbol, ClassWithQualifierPartIndex> parameters2, @NotNull List<? extends FirClassLikeDeclaration> outerClasses2) {
            Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
            Intrinsics.checkNotNullParameter(outerClasses2, (String)"outerClasses");
            return new ParametersMapAndOuterClasses(parameters2, outerClasses2);
        }

        public static /* synthetic */ ParametersMapAndOuterClasses copy$default(ParametersMapAndOuterClasses parametersMapAndOuterClasses, Map map, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                map = parametersMapAndOuterClasses.parameters;
            }
            if ((n & 2) != 0) {
                list2 = parametersMapAndOuterClasses.outerClasses;
            }
            return parametersMapAndOuterClasses.copy(map, list2);
        }

        @NotNull
        public String toString() {
            return "ParametersMapAndOuterClasses(parameters=" + this.parameters + ", outerClasses=" + this.outerClasses + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.parameters).hashCode();
            result2 = result2 * 31 + ((Object)this.outerClasses).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParametersMapAndOuterClasses)) {
                return false;
            }
            ParametersMapAndOuterClasses parametersMapAndOuterClasses = (ParametersMapAndOuterClasses)other;
            if (!Intrinsics.areEqual(this.parameters, parametersMapAndOuterClasses.parameters)) {
                return false;
            }
            return Intrinsics.areEqual(this.outerClasses, parametersMapAndOuterClasses.outerClasses);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeResolverImpl$ClassWithQualifierPartIndex;", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "index", "", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;I)V", "getIndex", "()I", "getKlass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "resolve"})
    private static final class ClassWithQualifierPartIndex {
        @NotNull
        private final FirClassLikeDeclaration klass;
        private final int index;

        public ClassWithQualifierPartIndex(@NotNull FirClassLikeDeclaration klass, int index2) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            this.klass = klass;
            this.index = index2;
        }

        @NotNull
        public final FirClassLikeDeclaration getKlass() {
            return this.klass;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final FirClassLikeDeclaration component1() {
            return this.klass;
        }

        public final int component2() {
            return this.index;
        }

        @NotNull
        public final ClassWithQualifierPartIndex copy(@NotNull FirClassLikeDeclaration klass, int index2) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            return new ClassWithQualifierPartIndex(klass, index2);
        }

        public static /* synthetic */ ClassWithQualifierPartIndex copy$default(ClassWithQualifierPartIndex classWithQualifierPartIndex, FirClassLikeDeclaration firClassLikeDeclaration, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                firClassLikeDeclaration = classWithQualifierPartIndex.klass;
            }
            if ((n2 & 2) != 0) {
                n = classWithQualifierPartIndex.index;
            }
            return classWithQualifierPartIndex.copy(firClassLikeDeclaration, n);
        }

        @NotNull
        public String toString() {
            return "ClassWithQualifierPartIndex(klass=" + this.klass + ", index=" + this.index + ')';
        }

        public int hashCode() {
            int result2 = this.klass.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.index);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassWithQualifierPartIndex)) {
                return false;
            }
            ClassWithQualifierPartIndex classWithQualifierPartIndex = (ClassWithQualifierPartIndex)other;
            if (!Intrinsics.areEqual((Object)this.klass, (Object)classWithQualifierPartIndex.klass)) {
                return false;
            }
            return this.index == classWithQualifierPartIndex.index;
        }
    }
}

