/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetectorKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0014\u0010\u0010\u001a\u00020\u000e*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "getMainFunctionOrNull", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "isMain", "", "allowEmptyParameters", "isSuitableForMainParametersSize", "backend.js"})
public final class JsMainFunctionDetector {
    @NotNull
    private final JsCommonBackendContext context;

    public JsMainFunctionDetector(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    private final boolean isSuitableForMainParametersSize(IrSimpleFunction $this$isSuitableForMainParametersSize, boolean allowEmptyParameters) {
        boolean bl;
        switch ($this$isSuitableForMainParametersSize.getValueParameters().size()) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            case 0: {
                bl = allowEmptyParameters;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMain(IrSimpleFunction $this$isMain, boolean allowEmptyParameters) {
        boolean bl;
        block13: {
            void $this$any$iv;
            void $this$filterIsInstanceTo$iv$iv;
            if (!((Collection)$this$isMain.getTypeParameters()).isEmpty()) {
                return false;
            }
            if (!this.isSuitableForMainParametersSize($this$isMain, allowEmptyParameters)) {
                return false;
            }
            boolean isLoweredSuspendFunction = JsMainFunctionDetectorKt.isLoweredSuspendFunction($this$isMain, this.context);
            if (!(IrTypePredicatesKt.isUnit($this$isMain.getReturnType()) || isLoweredSuspendFunction && (Intrinsics.areEqual((Object)$this$isMain.getReturnType(), (Object)this.context.getIrBuiltIns().getAnyNType()) || Intrinsics.areEqual((Object)$this$isMain.getReturnType(), (Object)this.context.getIrBuiltIns().getAnyType())))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)$this$isMain.getName().asString(), (Object)"main")) {
                return false;
            }
            if ($this$isMain.getExtensionReceiverParameter() != null) {
                return false;
            }
            if ($this$isMain.getValueParameters().size() == 1) {
                return isLoweredSuspendFunction || JsMainFunctionDetectorKt.isStringArrayParameter((IrValueParameter)CollectionsKt.single($this$isMain.getValueParameters()));
            }
            if ($this$isMain.getValueParameters().size() == 2) {
                return JsMainFunctionDetectorKt.isStringArrayParameter($this$isMain.getValueParameters().get(0)) && isLoweredSuspendFunction;
            }
            if (!allowEmptyParameters) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!$this$isMain.getValueParameters().isEmpty()) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            IrFile file2 = (IrFile)$this$isMain.getParent();
            Iterable $this$filterIsInstance$iv = file2.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl2 = false;
                    if (!this.isMain(it, false)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IrSimpleFunction getMainFunctionOrNull(@NotNull IrFile file2) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Iterable $this$filterIsInstance$iv = file2.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!this.isMain(it, true)) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    @Nullable
    public final IrSimpleFunction getMainFunctionOrNull(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Pair resultPair = null;
        Iterable $this$forEach$iv = module2.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSimpleFunction it;
            String fqn;
            IrFile f = (IrFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)f.getFqName().asString(), (String)"f.fqName.asString()");
            if (this.getMainFunctionOrNull(f) == null) continue;
            boolean bl2 = false;
            Pair result2 = resultPair;
            if (result2 == null) {
                resultPair = new Pair((Object)fqn, (Object)it);
                continue;
            }
            if (fqn.compareTo((String)result2.getFirst()) >= 0) continue;
            resultPair = new Pair((Object)fqn, (Object)it);
        }
        Pair pair = resultPair;
        return pair != null ? (IrSimpleFunction)pair.getSecond() : null;
    }
}

