/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiClassHolderFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportAliasStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004B!\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u000b\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStubImpl;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFileStub;", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/PsiClassHolderFileStub;", "jetFile", "packageName", "", "isScript", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;Z)V", "Lorg/jetbrains/kotlin/com/intellij/util/io/StringRef;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/util/io/StringRef;Z)V", "findImportsByAlias", "", "Lorg/jetbrains/kotlin/psi/stubs/KotlinImportDirectiveStub;", "alias", "getClasses", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClass;", "()[Lcom/intellij/psi/PsiClass;", "getPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IStubFileElementType;", "toString", "psi"})
public class KotlinFileStubImpl
extends PsiFileStubImpl<KtFile>
implements PsiClassHolderFileStub<KtFile>,
KotlinFileStub {
    @NotNull
    private final StringRef packageName;
    private final boolean isScript;

    public KotlinFileStubImpl(@Nullable KtFile jetFile, @NotNull StringRef packageName, boolean isScript) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        super((PsiFile)jetFile);
        this.packageName = packageName;
        this.isScript = isScript;
    }

    public KotlinFileStubImpl(@Nullable KtFile jetFile, @NotNull String packageName, boolean isScript) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        StringRef stringRef = StringRef.fromString(packageName);
        Intrinsics.checkNotNull((Object)stringRef);
        this(jetFile, stringRef, isScript);
    }

    @Override
    @NotNull
    public FqName getPackageFqName() {
        String string2 = StringRef.toString(this.packageName);
        Intrinsics.checkNotNull((Object)string2);
        return new FqName(string2);
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }

    @Override
    @NotNull
    public IStubFileElementType<KotlinFileStub> getType() {
        KtFileElementType ktFileElementType = KtStubElementTypes.FILE;
        Intrinsics.checkNotNullExpressionValue((Object)ktFileElementType, (String)"FILE");
        return ktFileElementType;
    }

    @Override
    @NotNull
    public String toString() {
        return "PsiJetFileStubImpl[package=" + this.getPackageFqName().asString() + ']';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PsiClass[] getClasses() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        List<StubElement> list2 = this.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"childrenStubs");
        Iterable $this$filterIsInstance$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiClassStub)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiClassStub psiClassStub = (PsiClassStub)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PsiClass)it.getPsi());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiClass[] psiClassArray = thisCollection$iv.toArray(new PsiClass[0]);
        if (psiClassArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return psiClassArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KotlinImportDirectiveStub> findImportsByAlias(@NotNull String alias) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object v1;
        block5: {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            List<StubElement> list2 = this.getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"childrenStubs");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StubElement it = (StubElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getStubType(), KtStubElementTypes.IMPORT_LIST)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        StubElement stubElement = v1;
        if (stubElement == null) {
            return CollectionsKt.emptyList();
        }
        StubElement importList = stubElement;
        List<StubElement> list3 = importList.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"importList.childrenStubs");
        Iterable $this$filterIsInstance$iv = list3;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$firstOrNull = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KotlinImportDirectiveStub)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Object v5;
            block6: {
                KotlinImportDirectiveStub it = (KotlinImportDirectiveStub)element$iv$iv;
                boolean bl = false;
                List<StubElement> list4 = it.getChildrenStubs();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"it.childrenStubs");
                Iterable $this$firstIsInstanceOrNull$iv = list4;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof KotlinImportAliasStub)) continue;
                    v5 = element$iv;
                    break block6;
                }
                v5 = null;
            }
            KotlinImportAliasStub kotlinImportAliasStub = v5;
            if (!Intrinsics.areEqual((Object)(kotlinImportAliasStub != null ? kotlinImportAliasStub.getName() : null), (Object)alias)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

