/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Buildable;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionBackedFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.FilteredFileCollection;
import org.gradle.api.internal.file.SubtractingFileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.FileBackedDirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.provider.BuildableBackedSetProvider;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.util.internal.GUtil;

public abstract class AbstractFileCollection
implements FileCollectionInternal {
    protected final Factory<PatternSet> patternSetFactory;

    protected AbstractFileCollection(Factory<PatternSet> patternSetFactory) {
        this.patternSetFactory = patternSetFactory;
    }

    public AbstractFileCollection() {
        this.patternSetFactory = PatternSets.getNonCachingPatternSetFactory();
    }

    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public final TreeFormatter describeContents(TreeFormatter formatter) {
        formatter.node("collection type: ").appendType(this.getClass()).append((CharSequence)" (id: ").append((CharSequence)String.valueOf(System.identityHashCode(this))).append((CharSequence)")");
        formatter.startChildren();
        this.appendContents(formatter);
        formatter.endChildren();
        return formatter;
    }

    protected void appendContents(TreeFormatter formatter) {
    }

    public final TaskDependency getBuildDependencies() {
        this.assertCanCarryBuildDependencies();
        return new AbstractTaskDependency(){

            public String toString() {
                return "Dependencies of " + AbstractFileCollection.this.getDisplayName();
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add((Object)AbstractFileCollection.this);
            }
        };
    }

    protected void assertCanCarryBuildDependencies() {
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
    }

    @Override
    public FileCollectionInternal replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
        if (original == this) {
            return supplier.get();
        }
        return this;
    }

    public Set<File> getFiles() {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.visitContents(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                for (File content : contents) {
                    files.add(content);
                }
            }

            private void addTreeContents(FileTreeInternal fileTree) {
                files.addAll(fileTree.getFiles());
            }

            @Override
            public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                this.addTreeContents(fileTree);
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                this.addTreeContents(fileTree);
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                this.addTreeContents(fileTree);
            }
        });
        return files;
    }

    public File getSingleFile() throws IllegalStateException {
        Iterator<File> iterator = this.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        File singleFile = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains more than one file.", this.getDisplayName()));
        }
        return singleFile;
    }

    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    public String getAsPath() {
        this.showGetAsPathDeprecationWarning();
        return GUtil.asPath((Iterable)((Object)this));
    }

    private void showGetAsPathDeprecationWarning() {
        List filesAsPaths = this.getFiles().stream().map(File::getPath).filter((? super T path) -> path.contains(File.pathSeparator)).collect(Collectors.toList());
        if (!filesAsPaths.isEmpty()) {
            String displayedFilePaths = filesAsPaths.stream().map(path -> "'" + path + "'").collect(Collectors.joining(","));
            ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)String.format("Converting files to a classpath string when their paths contain the path separator '%s' has been deprecated. The path separator is not a valid element of a file path. Problematic paths in '%s' are: %s.", File.pathSeparator, this.getDisplayName(), displayedFilePaths)).withAdvice("Add the individual files to the file collection instead.")).willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "file_collection_to_classpath").nagUser();
        }
    }

    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this, (FileCollectionInternal)collection);
    }

    public Provider<Set<FileSystemLocation>> getElements() {
        return new BuildableBackedSetProvider((Buildable)this, (Factory)new FileCollectionElementsFactory(this));
    }

    public FileCollection minus(FileCollection collection) {
        return new SubtractingFileCollection(this, collection);
    }

    public void addToAntBuilder(Object builder, String nodeName, FileCollection.AntType type) {
        if (type == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(builder, nodeName);
        } else if (type == FileCollection.AntType.FileSet) {
            this.addAsFileSet(builder, nodeName);
        } else {
            this.addAsMatchingTask(builder, nodeName);
        }
    }

    protected void addAsMatchingTask(Object builder, String nodeName) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsFileSet(Object builder, String nodeName) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileCollectionBuilder(this).addToAntBuilder(builder, nodeName);
    }

    protected Collection<DirectoryTree> getAsFileTrees() {
        final ArrayList<DirectoryTree> fileTrees = new ArrayList<DirectoryTree>();
        this.visitStructure(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                for (File file : contents) {
                    if (!file.isFile()) continue;
                    fileTrees.add(new FileBackedDirectoryFileTree(file));
                }
            }

            @Override
            public void visitFileTree(final File root, final PatternSet patterns, FileTreeInternal fileTree) {
                if (root.isFile()) {
                    fileTrees.add(new FileBackedDirectoryFileTree(root));
                } else if (root.isDirectory()) {
                    fileTrees.add(new DirectoryTree(){

                        public File getDir() {
                            return root;
                        }

                        public PatternSet getPatterns() {
                            return patterns;
                        }
                    });
                }
            }

            @Override
            public void visitGenericFileTree(FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                if (AbstractFileCollection.visitAll(sourceTree)) {
                    fileTrees.add(sourceTree.getMirror());
                }
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                this.visitGenericFileTree(fileTree, sourceTree);
            }
        });
        return fileTrees;
    }

    protected static boolean visitAll(FileSystemMirroringFileTree tree) {
        final MutableBoolean hasContent = new MutableBoolean();
        tree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                dirDetails.getFile();
                hasContent.set(true);
            }

            public void visitFile(FileVisitDetails fileDetails) {
                fileDetails.getFile();
                hasContent.set(true);
            }
        });
        return hasContent.get();
    }

    public Object addToAntBuilder(Object node, String childNodeName) {
        this.addToAntBuilder(node, childNodeName, FileCollection.AntType.ResourceCollection);
        return this;
    }

    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    @Override
    public FileTreeInternal getAsFileTree() {
        return new FileCollectionBackedFileTree(this.patternSetFactory, this);
    }

    public FileCollection filter(Closure filterClosure) {
        return this.filter(Specs.convertClosureToSpec((Closure)filterClosure));
    }

    @Override
    public FileCollectionInternal filter(Spec<? super File> filterSpec) {
        return new FilteredFileCollection(this, filterSpec);
    }

    @Override
    public final void visitStructure(FileCollectionStructureVisitor visitor) {
        if (visitor.startVisit(OTHER, this)) {
            this.visitContents(visitor);
        }
    }

    protected void visitContents(FileCollectionStructureVisitor visitor) {
        visitor.visitCollection(OTHER, (Iterable<File>)((Object)this));
    }

    private static class FileCollectionElementsFactory
    implements Factory<Set<FileSystemLocation>> {
        private final FileCollection fileCollection;

        private FileCollectionElementsFactory(FileCollection fileCollection) {
            this.fileCollection = fileCollection;
        }

        public Set<FileSystemLocation> create() {
            Set files = this.fileCollection.getFiles();
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)files.size());
            for (File file : files) {
                builder.add((Object)new DefaultFileSystemLocation(file));
            }
            return builder.build();
        }
    }
}

