/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.PropertyFileCollection;
import org.gradle.api.internal.tasks.properties.DefaultInputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.CompileClasspathNormalizer;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.IgnoredPathInputNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;

public class GetInputFilesVisitor
extends PropertyVisitor.Adapter {
    private static final ImmutableSet<Class<? extends FileNormalizer>> NORMALIZERS_IGNORING_DIRECTORIES = ImmutableSet.of(ClasspathNormalizer.class, CompileClasspathNormalizer.class, IgnoredPathInputNormalizer.class);
    private final List<InputFilePropertySpec> specs = Lists.newArrayList();
    private final FileCollectionFactory fileCollectionFactory;
    private final String ownerDisplayName;
    private boolean hasSourceFiles;
    private ImmutableSortedSet<InputFilePropertySpec> fileProperties;

    public GetInputFilesVisitor(String ownerDisplayName, FileCollectionFactory fileCollectionFactory) {
        this.ownerDisplayName = ownerDisplayName;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
        FileCollectionInternal actualValue = FileParameterUtils.resolveInputFileValue(this.fileCollectionFactory, filePropertyType, value);
        Class<? extends FileNormalizer> normalizer = FileParameterUtils.normalizerOrDefault(fileNormalizer);
        this.specs.add(new DefaultInputFilePropertySpec(propertyName, normalizer, (FileCollectionInternal)new PropertyFileCollection(this.ownerDisplayName, propertyName, "input", actualValue), value, skipWhenEmpty, incremental, this.normalizeDirectorySensitivity(normalizer, directorySensitivity), lineEndingSensitivity));
        if (skipWhenEmpty) {
            this.hasSourceFiles = true;
        }
    }

    private DirectorySensitivity normalizeDirectorySensitivity(Class<? extends FileNormalizer> fileNormalizer, DirectorySensitivity directorySensitivity) {
        return NORMALIZERS_IGNORING_DIRECTORIES.contains(fileNormalizer) ? DirectorySensitivity.DEFAULT : directorySensitivity;
    }

    public ImmutableSortedSet<InputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            this.fileProperties = FileParameterUtils.collectFileProperties("input", this.specs.iterator());
        }
        return this.fileProperties;
    }

    public boolean hasSourceFiles() {
        return this.hasSourceFiles;
    }
}

