/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.Action;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.VerificationException;
import org.gradle.execution.plan.CompositeNodeGroup;
import org.gradle.execution.plan.FinalizerGroup;
import org.gradle.execution.plan.HasFinalizers;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.NodeGroup;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.resources.ResourceLock;

public abstract class Node
implements Comparable<Node> {
    private ExecutionState state = ExecutionState.NOT_SCHEDULED;
    private boolean dependenciesProcessed;
    private DependenciesState dependenciesState = DependenciesState.NOT_COMPLETE;
    private Throwable executionFailure;
    private boolean filtered;
    private final NavigableSet<Node> dependencySuccessors = Sets.newTreeSet();
    private final NavigableSet<Node> dependencyPredecessors = Sets.newTreeSet();
    private final MutationInfo mutationInfo = new MutationInfo(this);
    private NodeGroup group = NodeGroup.DEFAULT_GROUP;

    @VisibleForTesting
    ExecutionState getState() {
        return this.state;
    }

    String healthDiagnostics() {
        if (this.isComplete()) {
            return this + " (state=" + (Object)((Object)this.state) + ")";
        }
        String specificState = this.nodeSpecificHealthDiagnostics();
        if (!specificState.isEmpty()) {
            specificState = ", " + specificState;
        }
        return this + " (state=" + (Object)((Object)this.state) + ", dependencies=" + (Object)((Object)this.dependenciesState) + specificState + ", group=" + this.group + ", successors=" + this.getHardSuccessors() + ")";
    }

    protected String nodeSpecificHealthDiagnostics() {
        return "";
    }

    public NodeGroup getGroup() {
        return this.group;
    }

    public void setGroup(NodeGroup group) {
        if (this.group != group) {
            this.group.removeMember(this);
            this.group = group;
            this.group.addMember(this);
        }
    }

    @Nullable
    public OrdinalGroup getOrdinal() {
        return this.group.asOrdinal();
    }

    public void maybeInheritOrdinalAsDependency(NodeGroup candidate) {
        if (this.group == candidate || candidate == NodeGroup.DEFAULT_GROUP) {
            return;
        }
        if (this.group == NodeGroup.DEFAULT_GROUP) {
            this.setGroup(candidate);
            return;
        }
        OrdinalGroup candidateOrdinal = (OrdinalGroup)candidate;
        OrdinalGroup currentOrdinal = (OrdinalGroup)this.group;
        if (candidateOrdinal.getOrdinal() < currentOrdinal.getOrdinal()) {
            this.setGroup(candidate);
        }
    }

    public void updateGroupOfFinalizer() {
        NodeGroup newGroup = this.group;
        for (Node predecessor : this.getDependencyPredecessors()) {
            if (!(predecessor.getGroup() instanceof HasFinalizers)) continue;
            newGroup = Node.maybeInheritGroupAsFinalizerDependency((HasFinalizers)predecessor.getGroup(), newGroup);
        }
        if (newGroup != this.group) {
            this.setGroup(newGroup);
        }
    }

    private static HasFinalizers maybeInheritGroupAsFinalizerDependency(HasFinalizers finalizers, NodeGroup current) {
        if (current == finalizers || current == NodeGroup.DEFAULT_GROUP) {
            return finalizers;
        }
        if (current instanceof OrdinalGroup) {
            return new CompositeNodeGroup(current, finalizers.getFinalizerGroups());
        }
        HasFinalizers currentFinalizers = (HasFinalizers)current;
        if (currentFinalizers.isReachableFromEntryPoint() == finalizers.isReachableFromEntryPoint() && currentFinalizers.getFinalizerGroups().containsAll(finalizers.getFinalizerGroups())) {
            return currentFinalizers;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(currentFinalizers.getFinalizerGroups());
        builder.addAll(finalizers.getFinalizerGroups());
        return new CompositeNodeGroup(currentFinalizers.getOrdinalGroup(), (Set<FinalizerGroup>)builder.build());
    }

    public void maybeUpdateOrdinalGroup() {
        OrdinalGroup ordinal;
        OrdinalGroup newOrdinal = ordinal = this.getGroup().asOrdinal();
        for (Node successor : this.getHardSuccessors()) {
            OrdinalGroup successorOrdinal = successor.getGroup().asOrdinal();
            if (successorOrdinal == null || ordinal != null && successorOrdinal.getOrdinal() <= ordinal.getOrdinal()) continue;
            newOrdinal = successorOrdinal;
        }
        if (newOrdinal != ordinal) {
            this.setGroup(this.getGroup().withOrdinalGroup(newOrdinal));
        }
    }

    @Nullable
    public FinalizerGroup getFinalizerGroup() {
        return this.group.asFinalizer();
    }

    public boolean isRequired() {
        return this.state == ExecutionState.SHOULD_RUN;
    }

    public boolean isDoNotIncludeInPlan() {
        return this.filtered || this.state == ExecutionState.NOT_SCHEDULED || this.isCannotRunInAnyPlan();
    }

    public boolean isCannotRunInAnyPlan() {
        return this.state == ExecutionState.EXECUTED || this.state == ExecutionState.FAILED_DEPENDENCY;
    }

    public boolean isReady() {
        return this.state == ExecutionState.SHOULD_RUN;
    }

    public boolean isCanCancel() {
        return true;
    }

    public boolean isInKnownState() {
        return this.state != ExecutionState.NOT_SCHEDULED;
    }

    public boolean isExecuting() {
        return this.state == ExecutionState.EXECUTING;
    }

    public boolean isComplete() {
        return this.state == ExecutionState.EXECUTED || this.state == ExecutionState.FAILED_DEPENDENCY || this.state == ExecutionState.NOT_SCHEDULED || this.filtered;
    }

    public boolean isSuccessful() {
        return this.filtered || this.state == ExecutionState.EXECUTED && !this.isFailed();
    }

    public boolean isVerificationFailure() {
        return this.getNodeFailure() != null && this.getNodeFailure().getCause() instanceof VerificationException;
    }

    public boolean isFailed() {
        return this.getNodeFailure() != null || this.getExecutionFailure() != null;
    }

    public boolean isExecuted() {
        return this.state == ExecutionState.EXECUTED;
    }

    public boolean isPriority() {
        return false;
    }

    @Nullable
    public abstract Throwable getNodeFailure();

    public void startExecution(Consumer<Node> nodeStartAction) {
        assert (this.allDependenciesComplete() && this.allDependenciesSuccessful());
        this.state = ExecutionState.EXECUTING;
        nodeStartAction.accept(this);
    }

    public void finishExecution(Consumer<Node> completionAction) {
        assert (this.state == ExecutionState.EXECUTING);
        this.state = ExecutionState.EXECUTED;
        completionAction.accept(this);
    }

    public void markFailedDueToDependencies(Consumer<Node> completionAction) {
        assert (this.state == ExecutionState.SHOULD_RUN);
        this.state = ExecutionState.FAILED_DEPENDENCY;
        completionAction.accept(this);
    }

    public void cancelExecution(Consumer<Node> completionAction) {
        if (this.isCannotRunInAnyPlan()) {
            throw new IllegalStateException("Cannot cancel node " + this);
        }
        this.state = ExecutionState.NOT_SCHEDULED;
        completionAction.accept(this);
    }

    public void require() {
        if (this.isCannotRunInAnyPlan()) {
            return;
        }
        if (this.state != ExecutionState.SHOULD_RUN) {
            this.dependenciesProcessed = false;
            this.state = ExecutionState.SHOULD_RUN;
        }
    }

    public void filtered() {
        if (this.isCannotRunInAnyPlan()) {
            return;
        }
        this.filtered = true;
    }

    public void reset() {
        this.group = NodeGroup.DEFAULT_GROUP;
        if (!this.isCannotRunInAnyPlan()) {
            this.filtered = false;
            this.dependenciesProcessed = false;
            this.state = ExecutionState.NOT_SCHEDULED;
            this.dependenciesState = DependenciesState.NOT_COMPLETE;
        }
    }

    public void setExecutionFailure(Throwable failure) {
        assert (this.state == ExecutionState.EXECUTING);
        this.executionFailure = failure;
    }

    @Nullable
    public Throwable getExecutionFailure() {
        return this.executionFailure;
    }

    public Set<Node> getDependencyPredecessors() {
        return this.dependencyPredecessors;
    }

    public Set<Node> getDependencySuccessors() {
        return this.dependencySuccessors;
    }

    public Iterable<Node> getDependencySuccessorsInReverseOrder() {
        return this.dependencySuccessors.descendingSet();
    }

    public void addDependencySuccessor(Node toNode) {
        this.dependencySuccessors.add(toNode);
        toNode.getDependencyPredecessors().add(this);
    }

    @OverridingMethodsMustInvokeSuper
    protected DependenciesState doCheckDependenciesComplete() {
        for (Node dependency : this.dependencySuccessors) {
            if (!dependency.isComplete()) {
                return DependenciesState.NOT_COMPLETE;
            }
            if (this.shouldContinueExecution(dependency)) continue;
            return DependenciesState.COMPLETE_AND_NOT_SUCCESSFUL;
        }
        return this.group.checkSuccessorsCompleteFor(this);
    }

    public boolean updateAllDependenciesComplete() {
        if (this.dependenciesState == DependenciesState.NOT_COMPLETE) {
            this.forceAllDependenciesCompleteUpdate();
            return this.dependenciesState != DependenciesState.NOT_COMPLETE;
        }
        return false;
    }

    public void forceAllDependenciesCompleteUpdate() {
        this.dependenciesState = this.doCheckDependenciesComplete();
    }

    public boolean allDependenciesComplete() {
        return this.state == ExecutionState.SHOULD_RUN && this.dependenciesState != DependenciesState.NOT_COMPLETE;
    }

    public boolean allDependenciesSuccessful() {
        return this.dependenciesState == DependenciesState.COMPLETE_AND_SUCCESSFUL;
    }

    public boolean shouldCancelExecutionDueToDependencies() {
        return this.dependenciesState == DependenciesState.COMPLETE_AND_CAN_SKIP;
    }

    protected boolean shouldContinueExecution(Node dependency) {
        return dependency.isSuccessful() || dependency.isVerificationFailure() && !this.dependsOnOutcome(dependency);
    }

    protected boolean dependsOnOutcome(Node dependency) {
        return false;
    }

    protected void visitAllNodesWaitingForThisNode(Consumer<Node> visitor) {
        for (Node node : this.getDependencyPredecessors()) {
            visitor.accept(node);
        }
    }

    public void prepareForExecution(Action<Node> monitor) {
    }

    public abstract void resolveDependencies(TaskDependencyResolver var1);

    public boolean getDependenciesProcessed() {
        return this.dependenciesProcessed;
    }

    public void dependenciesProcessed() {
        this.dependenciesProcessed = true;
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getAllSuccessors() {
        return this.getHardSuccessors();
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getHardSuccessors() {
        return this.dependencySuccessors;
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getAllSuccessorsInReverseOrder() {
        return this.dependencySuccessors.descendingSet();
    }

    public Set<Node> getFinalizers() {
        return Collections.emptySet();
    }

    public void addFinalizer(Node finalizer) {
    }

    public Set<Node> getFinalizingSuccessors() {
        return Collections.emptySet();
    }

    @Nullable
    public Node getPrepareNode() {
        return null;
    }

    public MutationInfo getMutationInfo() {
        return this.mutationInfo;
    }

    public boolean isPublicNode() {
        return false;
    }

    @Nullable
    public ResourceLock getProjectToLock() {
        return null;
    }

    @Nullable
    public ProjectInternal getOwningProject() {
        return null;
    }

    public List<? extends ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    public abstract String toString();

    public static enum DependenciesState {
        NOT_COMPLETE,
        COMPLETE_AND_SUCCESSFUL,
        COMPLETE_AND_NOT_SUCCESSFUL,
        COMPLETE_AND_CAN_SKIP;

    }

    @VisibleForTesting
    static enum ExecutionState {
        NOT_SCHEDULED,
        SHOULD_RUN,
        EXECUTING,
        EXECUTED,
        FAILED_DEPENDENCY;

    }
}

