/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.gradle.api.file.FileCollection;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionResult;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.history.impl.DefaultAfterExecutionState;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.ChangingOutputsContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class CaptureStateAfterExecutionStep<C extends InputChangesContext>
extends BuildOperationStep<C, AfterExecutionResult> {
    private final UniqueId buildInvocationScopeId;
    private final OutputSnapshotter outputSnapshotter;
    private final OutputChangeListener outputChangeListener;
    private final Step<? super ChangingOutputsContext, ? extends Result> delegate;

    public CaptureStateAfterExecutionStep(BuildOperationExecutor buildOperationExecutor, UniqueId buildInvocationScopeId, OutputSnapshotter outputSnapshotter, OutputChangeListener outputChangeListener, Step<? super ChangingOutputsContext, ? extends Result> delegate) {
        super(buildOperationExecutor);
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.outputSnapshotter = outputSnapshotter;
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    @Override
    public AfterExecutionResult execute(UnitOfWork work, C context) {
        final Result result = this.executeDelegateBroadcastingChanges(work, context);
        final Duration duration = result.getDuration();
        final Optional afterExecutionState = context.getBeforeExecutionState().flatMap(beforeExecutionState -> this.captureStateAfterExecution(work, (BeforeExecutionContext)context, (BeforeExecutionState)beforeExecutionState, duration));
        return new AfterExecutionResult(){

            @Override
            public Optional<AfterExecutionState> getAfterExecutionState() {
                return afterExecutionState;
            }

            @Override
            public Try<ExecutionResult> getExecutionResult() {
                return result.getExecutionResult();
            }

            @Override
            public Duration getDuration() {
                return duration;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeDelegateBroadcastingChanges(UnitOfWork work, C context) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        work.visitOutputs(context.getWorkspace(), new UnitOfWork.OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, File root, FileCollection contents) {
                builder.add((Object)root.getAbsolutePath());
            }

            @Override
            public void visitLocalState(File localStateRoot) {
                builder.add((Object)localStateRoot.getAbsolutePath());
            }

            @Override
            public void visitDestroyable(File destroyableRoot) {
                builder.add((Object)destroyableRoot.getAbsolutePath());
            }
        });
        ImmutableList outputsToBeChanged = builder.build();
        this.outputChangeListener.invalidateCachesFor((Iterable<String>)outputsToBeChanged);
        try {
            Result result = this.delegate.execute(work, this.wrapInChangesOutputsContext(context));
            return result;
        }
        finally {
            this.outputChangeListener.invalidateCachesFor((Iterable<String>)outputsToBeChanged);
        }
    }

    private Optional<AfterExecutionState> captureStateAfterExecution(UnitOfWork work, BeforeExecutionContext context, BeforeExecutionState beforeExecutionState, Duration duration) {
        return this.operation(operationContext -> {
            try {
                Timer timer = Time.startTimer();
                ImmutableSortedMap<String, FileSystemSnapshot> outputsProducedByWork = this.captureOutputs(work, context, beforeExecutionState);
                long snapshotOutputDuration = timer.getElapsedMillis();
                Duration originExecutionTime = duration.plus(Duration.ofMillis(snapshotOutputDuration));
                OriginMetadata originMetadata = new OriginMetadata(this.buildInvocationScopeId.asString(), originExecutionTime);
                DefaultAfterExecutionState afterExecutionState = new DefaultAfterExecutionState(beforeExecutionState, outputsProducedByWork, originMetadata, false);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return Optional.of(afterExecutionState);
            }
            catch (OutputSnapshotter.OutputFileSnapshottingException e) {
                work.handleUnreadableOutputs(e);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return Optional.empty();
            }
        }, BuildOperationDescriptor.displayName((String)("Snapshot outputs after executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE));
    }

    private ImmutableSortedMap<String, FileSystemSnapshot> captureOutputs(UnitOfWork work, BeforeExecutionContext context, BeforeExecutionState beforeExecutionState) {
        ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshotsAfterExecution = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
        if (beforeExecutionState.getDetectedOverlappingOutputs().isPresent()) {
            ImmutableSortedMap previousExecutionOutputSnapshots = context.getPreviousExecutionState().map(OutputExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
            ImmutableSortedMap unfilteredOutputSnapshotsBeforeExecution = context.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileLocationSnapshots).orElse(ImmutableSortedMap.of());
            return OutputSnapshotUtil.filterOutputsAfterExecution((ImmutableSortedMap<String, FileSystemSnapshot>)previousExecutionOutputSnapshots, (ImmutableSortedMap<String, FileSystemSnapshot>)unfilteredOutputSnapshotsBeforeExecution, unfilteredOutputSnapshotsAfterExecution);
        }
        return unfilteredOutputSnapshotsAfterExecution;
    }

    private ChangingOutputsContext wrapInChangesOutputsContext(C context) {
        return new ChangingOutputsContext((InputChangesContext)context){
            final /* synthetic */ InputChangesContext val$context;
            {
                this.val$context = inputChangesContext;
            }

            @Override
            public File getWorkspace() {
                return this.val$context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return this.val$context.getHistory();
            }

            @Override
            public Optional<ValidationFinishedContext.ValidationResult> getValidationProblems() {
                return this.val$context.getValidationProblems();
            }

            @Override
            public Optional<PreviousExecutionState> getPreviousExecutionState() {
                return this.val$context.getPreviousExecutionState();
            }

            @Override
            public Optional<InputChangesInternal> getInputChanges() {
                return this.val$context.getInputChanges();
            }

            @Override
            public boolean isIncrementalExecution() {
                return this.val$context.isIncrementalExecution();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.val$context.getInputProperties();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.val$context.getInputFileProperties();
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return this.val$context.getIdentity();
            }

            @Override
            public Optional<String> getNonIncrementalReason() {
                return this.val$context.getNonIncrementalReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return this.val$context.getValidationContext();
            }

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return this.val$context.getBeforeExecutionState();
            }
        };
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

