/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.MutableModuleSources;

public class ImmutableModuleSources
implements ModuleSources {
    private static final ImmutableModuleSources EMPTY = new ImmutableModuleSources(null, null);
    private final ImmutableModuleSources previous;
    private final ModuleSource value;
    private final int hashCode;
    private final int size;

    public static ImmutableModuleSources of() {
        return EMPTY;
    }

    public static ImmutableModuleSources of(ModuleSource ... sources) {
        ImmutableModuleSources cur = EMPTY;
        for (ModuleSource source : sources) {
            cur = new ImmutableModuleSources(cur, source);
        }
        return cur;
    }

    private ImmutableModuleSources(@Nullable ImmutableModuleSources previous, @Nullable ModuleSource value) {
        if (previous != null && value == null) {
            throw new AssertionError((Object)"value must not be null");
        }
        this.previous = previous;
        this.value = value;
        this.hashCode = 31 * (previous == null ? 0 : previous.hashCode) + (value == null ? 0 : value.hashCode());
        this.size = previous == null ? 0 : 1 + previous.size;
    }

    public static ImmutableModuleSources of(ModuleSources sources, ModuleSource source) {
        if (sources instanceof ImmutableModuleSources) {
            return new ImmutableModuleSources((ImmutableModuleSources)sources, source);
        }
        ArrayList all = Lists.newArrayList();
        sources.withSources(all::add);
        all.add(source);
        return ImmutableModuleSources.of(all.toArray(new ModuleSource[0]));
    }

    public static ImmutableModuleSources of(ModuleSources sources) {
        if (sources instanceof ImmutableModuleSources) {
            return (ImmutableModuleSources)sources;
        }
        return ((MutableModuleSources)sources).asImmutable();
    }

    @Override
    public <T extends ModuleSource> Optional<T> getSource(Class<T> sourceType) {
        if (this.previous == null) {
            return Optional.empty();
        }
        if (sourceType.isAssignableFrom(this.value.getClass())) {
            ModuleSource src = (ModuleSource)Cast.uncheckedCast((Object)this.value);
            return Optional.of(src);
        }
        return this.previous.getSource(sourceType);
    }

    @Override
    public void withSources(Consumer<ModuleSource> consumer) {
        ImmutableModuleSources cur = this;
        while (cur.value != null) {
            consumer.accept(cur.value);
            cur = cur.previous;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableModuleSources that = (ImmutableModuleSources)o;
        if (!Objects.equals(this.previous, that.previous)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Sources = [");
        this.withSources(src -> sb.append(src).append(","));
        sb.append("]}");
        return sb.toString();
    }
}

