/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.execution.plan.HasFinalizers;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeGroup;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.TaskNode;

public class FinalizerGroup
extends HasFinalizers {
    private final TaskNode node;
    private final NodeGroup delegate;
    private final Set<Node> members = new LinkedHashSet<Node>();
    @Nullable
    private OrdinalGroup ordinal;
    @Nullable
    private ElementSuccessors successors;

    public FinalizerGroup(TaskNode node, NodeGroup delegate) {
        this.ordinal = delegate.asOrdinal();
        this.node = node;
        this.delegate = delegate;
    }

    public String toString() {
        return "finalizer " + this.node + " ordinal: " + this.ordinal + ", delegate: " + this.delegate;
    }

    public TaskNode getNode() {
        return this.node;
    }

    @Override
    public NodeGroup getOrdinalGroup() {
        return this.delegate;
    }

    @Override
    public NodeGroup withOrdinalGroup(OrdinalGroup newOrdinal) {
        this.ordinal = newOrdinal;
        return this;
    }

    public NodeGroup getDelegate() {
        return this.delegate;
    }

    public Set<Node> getFinalizedNodes() {
        return this.node.getFinalizingSuccessors();
    }

    @Override
    @Nullable
    public OrdinalGroup asOrdinal() {
        return this.ordinal;
    }

    @Override
    public boolean isReachableFromEntryPoint() {
        return this.delegate.isReachableFromEntryPoint();
    }

    @Override
    @Nullable
    public FinalizerGroup asFinalizer() {
        return this;
    }

    public Collection<Node> getSuccessorsFor(Node node) {
        assert (this.members.contains(node)) : "Node " + node + " is not part of the finalizer group of " + this.node;
        if (this.successors == null) {
            this.successors = this.createSuccessors();
        }
        return this.successors.successorsFor(node);
    }

    public Collection<Node> getSuccessorsInReverseOrderFor(Node node) {
        ArrayList<Node> successors = new ArrayList<Node>((Collection<Node>)this.getSuccessorsFor(node));
        Collections.reverse(successors);
        return successors;
    }

    private ElementSuccessors createSuccessors() {
        for (Node finalizedNode : this.getFinalizedNodes()) {
            if (!this.members.contains(finalizedNode)) continue;
            return new FinalizesMembers();
        }
        return new DoesNotFinalizeMembers();
    }

    private static boolean memberCanStartAtAnyTime(Node node) {
        return node.getGroup().isReachableFromEntryPoint();
    }

    @Override
    public Set<FinalizerGroup> getFinalizerGroups() {
        return ImmutableSet.of((Object)this);
    }

    @Override
    public void addMember(Node node) {
        this.members.add(node);
        this.delegate.addMember(node);
        this.successors = null;
    }

    @Override
    public void removeMember(Node node) {
        this.members.remove(node);
        this.delegate.removeMember(node);
        this.successors = null;
    }

    public void visitAllMembers(Consumer<Node> visitor) {
        for (Node member : this.members) {
            visitor.accept(member);
        }
    }

    @Override
    public boolean isCanCancel() {
        for (Node node : this.getFinalizedNodes()) {
            if (!node.isExecuting() && !node.isExecuted() && node.isCanCancel()) continue;
            return false;
        }
        return this.delegate.isCanCancel();
    }

    @Override
    public Node.DependenciesState checkSuccessorsCompleteFor(Node node) {
        if (!this.isFinalizerNode(node) && FinalizerGroup.memberCanStartAtAnyTime(node)) {
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
        Iterable successors = this.getSuccessorsFor(node);
        if (successors.isEmpty()) {
            return this.checkPeersCompleteFor(node);
        }
        boolean isAnyExecuted = false;
        for (Node finalized : successors) {
            if (!finalized.isComplete()) {
                return Node.DependenciesState.NOT_COMPLETE;
            }
            isAnyExecuted |= finalized.isExecuted();
        }
        if (isAnyExecuted || this.delegate.isReachableFromEntryPoint()) {
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
        if (this.delegate instanceof HasFinalizers) {
            return this.delegate.checkSuccessorsCompleteFor(node);
        }
        return Node.DependenciesState.COMPLETE_AND_CAN_SKIP;
    }

    private Node.DependenciesState checkPeersCompleteFor(Node node) {
        for (Node member : this.members) {
            if (!member.isComplete()) continue;
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
        HasFinalizers hasFinalizers = (HasFinalizers)node.getGroup();
        for (FinalizerGroup group : hasFinalizers.getFinalizerGroups()) {
            if (group == this || !group.isActivated(node)) continue;
            return Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
        return Node.DependenciesState.NOT_COMPLETE;
    }

    private boolean isActivated(Node node) {
        if (node == this.node) {
            return this.checkSuccessorsCompleteFor(node) == Node.DependenciesState.COMPLETE_AND_SUCCESSFUL;
        }
        return false;
    }

    private boolean isFinalizerNode(Node node) {
        return node == this.node;
    }

    private class FinalizesMembers
    extends ElementSuccessors {
        private final Set<Node> finalizedNodesThatCanStartAtAnyTime;
        private final Set<Node> membersThatAreDeferred;

        public FinalizesMembers() {
            Set<Node> successors = FinalizerGroup.this.getFinalizedNodes();
            this.finalizedNodesThatCanStartAtAnyTime = new LinkedHashSet<Node>(successors.size());
            ArrayList<Node> queue = new ArrayList<Node>();
            for (Node successor : successors) {
                if (!FinalizerGroup.this.members.contains(successor)) {
                    this.finalizedNodesThatCanStartAtAnyTime.add(successor);
                    continue;
                }
                if (FinalizerGroup.memberCanStartAtAnyTime(successor)) {
                    this.finalizedNodesThatCanStartAtAnyTime.add(successor);
                    continue;
                }
                queue.add(successor);
            }
            this.membersThatAreDeferred = new HashSet<Node>();
            while (!queue.isEmpty()) {
                Node node = (Node)queue.remove(0);
                if (!this.membersThatAreDeferred.add(node)) continue;
                queue.addAll(0, node.getDependencySuccessors());
            }
        }

        @Override
        protected Set<Node> getFilteredSuccessorsFor(Node node) {
            if (!this.membersThatAreDeferred.contains(node)) {
                return FinalizerGroup.this.getFinalizedNodes();
            }
            return this.finalizedNodesThatCanStartAtAnyTime;
        }
    }

    private class DoesNotFinalizeMembers
    extends ElementSuccessors {
        private DoesNotFinalizeMembers() {
        }

        @Override
        protected Set<Node> getFilteredSuccessorsFor(Node node) {
            return FinalizerGroup.this.getFinalizedNodes();
        }
    }

    private abstract class ElementSuccessors {
        private ElementSuccessors() {
        }

        public Set<Node> successorsFor(Node node) {
            if (FinalizerGroup.this.isFinalizerNode(node)) {
                return FinalizerGroup.this.getFinalizedNodes();
            }
            if (FinalizerGroup.memberCanStartAtAnyTime(node)) {
                return Collections.emptySet();
            }
            return this.getFilteredSuccessorsFor(node);
        }

        protected abstract Set<Node> getFilteredSuccessorsFor(Node var1);
    }
}

