/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.internal.vfs.impl.VersionHierarchyRoot;
import org.gradle.internal.vfs.impl.VfsRootReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVirtualFileSystem
implements VirtualFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVirtualFileSystem.class);
    protected final VfsRootReference rootReference;
    private volatile VersionHierarchyRoot versionHierarchyRoot;

    protected AbstractVirtualFileSystem(VfsRootReference rootReference) {
        this.rootReference = rootReference;
        this.versionHierarchyRoot = VersionHierarchyRoot.empty(0L, rootReference.getRoot().getCaseSensitivity());
    }

    @Override
    public Optional<FileSystemLocationSnapshot> findSnapshot(String absolutePath) {
        return this.rootReference.getRoot().findSnapshot(absolutePath);
    }

    @Override
    public Optional<MetadataSnapshot> findMetadata(String absolutePath) {
        return this.rootReference.getRoot().findMetadata(absolutePath);
    }

    @Override
    public FileSystemLocationSnapshot store(String absolutePath, Supplier<FileSystemLocationSnapshot> snapshotSupplier) {
        long versionBefore = this.versionHierarchyRoot.getVersion(absolutePath);
        FileSystemLocationSnapshot snapshot = snapshotSupplier.get();
        this.storeIfUnchanged(absolutePath, versionBefore, snapshot);
        return snapshot;
    }

    @Override
    public FileSystemLocationSnapshot store(String baseLocation, VirtualFileSystem.StoringAction storingAction) {
        long versionBefore = this.versionHierarchyRoot.getVersion(baseLocation);
        return storingAction.snapshot(snapshot -> this.storeIfUnchanged(snapshot.getAbsolutePath(), versionBefore, (FileSystemLocationSnapshot)snapshot));
    }

    private void storeIfUnchanged(String absolutePath, long versionBefore, FileSystemLocationSnapshot snapshot) {
        long versionAfter = this.versionHierarchyRoot.getVersion(absolutePath);
        if (versionBefore >= versionAfter) {
            this.rootReference.updateUnderLock(root -> this.updateNotifyingListeners(diffListener -> root.store(absolutePath, snapshot, diffListener)));
        } else {
            LOGGER.debug("Changes to the virtual file system happened while snapshotting '{}', not storing resulting snapshot", (Object)absolutePath);
        }
    }

    @Override
    public void invalidate(Iterable<String> locations) {
        LOGGER.debug("Invalidating VFS paths: {}", locations);
        this.rootReference.updateUnderLock(root -> {
            SnapshotHierarchy result = root;
            VersionHierarchyRoot newVersionHierarchyRoot = this.versionHierarchyRoot;
            for (String location : locations) {
                SnapshotHierarchy currentRoot = result;
                result = this.updateNotifyingListeners(diffListener -> currentRoot.invalidate(location, diffListener));
                newVersionHierarchyRoot = newVersionHierarchyRoot.updateVersion(location);
            }
            this.versionHierarchyRoot = newVersionHierarchyRoot;
            return result;
        });
    }

    @Override
    public void invalidateAll() {
        LOGGER.debug("Invalidating the whole VFS");
        this.invalidate(Collections.singletonList(""));
    }

    protected abstract SnapshotHierarchy updateNotifyingListeners(UpdateFunction var1);

    public static interface UpdateFunction {
        public SnapshotHierarchy update(SnapshotHierarchy.NodeDiffListener var1);
    }
}

