/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ByteArrayExternalizer;", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "bytes", "kotlin-build-common"})
public final class ByteArrayExternalizer
implements DataExternalizer<byte[]> {
    @NotNull
    public static final ByteArrayExternalizer INSTANCE = new ByteArrayExternalizer();

    private ByteArrayExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    @Override
    @NotNull
    public byte[] read(@NotNull DataInput input) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int size = input.readInt();
        byte[] it = byArray = new byte[size];
        boolean bl = false;
        input.readFully(it, 0, size);
        return byArray;
    }
}

