/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
public class BuildInclusionCoordinator {
    private final Set<IncludedBuildState> loadedBuilds = new CopyOnWriteArraySet<IncludedBuildState>();
    private final List<IncludedBuildState> libraryBuilds = new CopyOnWriteArrayList<IncludedBuildState>();
    private final BuildStateRegistry buildStateRegistry;

    public BuildInclusionCoordinator(BuildStateRegistry buildStateRegistry) {
        this.buildStateRegistry = buildStateRegistry;
    }

    public void prepareForInclusion(IncludedBuildState build, boolean asPlugin) {
        if (this.loadedBuilds.add(build)) {
            build.ensureProjectsLoaded();
        }
        if (!asPlugin && !this.libraryBuilds.contains(build)) {
            this.libraryBuilds.add(build);
        }
    }

    public void registerGlobalLibrarySubstitutions() {
        for (IncludedBuildState includedBuild : this.libraryBuilds) {
            this.buildStateRegistry.registerSubstitutionsFor(includedBuild);
        }
    }
}

