/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Namer;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectList;
import org.gradle.api.internal.artifacts.repositories.AuthenticationSupporter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultAuthenticationContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.toolchain.JavaToolchainRepository;
import org.gradle.jvm.toolchain.JavaToolchainRepositoryHandler;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainRepository;
import org.gradle.jvm.toolchain.internal.JavaToolchainResolverRegistryInternal;

public class DefaultJavaToolchainRepositoryHandler
extends DefaultNamedDomainObjectList<JavaToolchainRepository>
implements JavaToolchainRepositoryHandler {
    private final JavaToolchainResolverRegistryInternal registry;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;
    private final AuthenticationSchemeRegistry authenticationSchemeRegistry;

    @Inject
    public DefaultJavaToolchainRepositoryHandler(JavaToolchainResolverRegistryInternal registry, Instantiator instantiator, ObjectFactory objectFactory, ProviderFactory providerFactory, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
        super(JavaToolchainRepository.class, instantiator, (Namer)new RepositoryNamer(), CollectionCallbackActionDecorator.NOOP);
        this.registry = registry;
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
        this.authenticationSchemeRegistry = authenticationSchemeRegistry;
    }

    @Override
    public void repository(String name, Action<? super JavaToolchainRepository> configureAction) {
        DefaultAuthenticationContainer authenticationContainer = new DefaultAuthenticationContainer(this.instantiator, CollectionCallbackActionDecorator.NOOP);
        for (Map.Entry e : this.authenticationSchemeRegistry.getRegisteredSchemes().entrySet()) {
            authenticationContainer.registerBinding((Class)e.getKey(), (Class)e.getValue());
        }
        AuthenticationSupporter authenticationSupporter = new AuthenticationSupporter(this.instantiator, this.objectFactory, (AuthenticationContainer)authenticationContainer, this.providerFactory);
        DefaultJavaToolchainRepository repository = (DefaultJavaToolchainRepository)this.objectFactory.newInstance(DefaultJavaToolchainRepository.class, new Object[]{name, authenticationContainer, authenticationSupporter, this.providerFactory});
        configureAction.execute((Object)repository);
        boolean isNew = this.registry.getRepositories().add(repository);
        if (!isNew) {
            throw new GradleException("Duplicate configuration for repository '" + name + "'.");
        }
    }

    public String getTypeDisplayName() {
        return "repository";
    }

    private static class RepositoryNamer
    implements Namer<JavaToolchainRepository> {
        private RepositoryNamer() {
        }

        public String determineName(JavaToolchainRepository repository) {
            return repository.getName();
        }
    }
}

