/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaToolchainMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkCacheDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkCacheDirectory.class);
    private static final String MARKER_FILE = "provisioned.ok";
    private static final String MAC_OS_JAVA_HOME_FOLDER = "Contents/Home";
    private final FileOperations operations;
    private final File jdkDirectory;
    private final FileLockManager lockManager;
    private final JvmMetadataDetector detector;

    @Inject
    public JdkCacheDirectory(GradleUserHomeDirProvider homeDirProvider, FileOperations operations, FileLockManager lockManager, JvmMetadataDetector detector) {
        this.operations = operations;
        this.jdkDirectory = new File(homeDirProvider.getGradleUserHomeDirectory(), "jdks");
        this.lockManager = lockManager;
        this.detector = detector;
        this.jdkDirectory.mkdir();
    }

    public Set<File> listJavaHomes() {
        File[] candidates = this.jdkDirectory.listFiles();
        if (candidates != null) {
            return Arrays.stream(candidates).flatMap(this::allMarkedLocations).map(this::getJavaHome).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Stream<File> allMarkedLocations(File candidate) {
        if (this.isMarkedLocation(candidate)) {
            return Stream.of(candidate);
        }
        File[] subFolders = candidate.listFiles();
        if (subFolders == null) {
            return Stream.empty();
        }
        return Arrays.stream(subFolders).filter(this::isMarkedLocation);
    }

    private boolean isMarkedLocation(File candidate) {
        return candidate.isDirectory() && new File(candidate, MARKER_FILE).exists();
    }

    private File getJavaHome(File markedLocation) {
        if (OperatingSystem.current().isMacOsX()) {
            if (new File(markedLocation, MAC_OS_JAVA_HOME_FOLDER).exists()) {
                return new File(markedLocation, MAC_OS_JAVA_HOME_FOLDER);
            }
            File[] subfolders = markedLocation.listFiles(File::isDirectory);
            if (subfolders != null) {
                for (File subfolder : subfolders) {
                    if (!new File(subfolder, MAC_OS_JAVA_HOME_FOLDER).exists()) continue;
                    return new File(subfolder, MAC_OS_JAVA_HOME_FOLDER);
                }
            }
        }
        return markedLocation;
    }

    public File provisionFromArchive(JavaToolchainSpec spec, File jdkArchive, URI uri) {
        File unpackFolder = this.unpack(jdkArchive);
        File markedLocation = this.markedLocation(unpackFolder);
        this.markAsReady(markedLocation);
        File javaHome = this.getJavaHome(markedLocation);
        JvmInstallationMetadata metadata = this.detector.getMetadata(new InstallationLocation(javaHome, "provisioned toolchain"));
        if (!metadata.isValidInstallation()) {
            throw new GradleException("Provisioned toolchain '" + javaHome + "' could not be probed.");
        }
        if (!new JavaToolchainMatcher(spec).test(metadata)) {
            throw new GradleException("Toolchain provisioned from '" + uri + "' doesn't satisfy the specification: " + spec.getDisplayName() + ".");
        }
        File installFolder = new File(this.jdkDirectory, JdkCacheDirectory.toDirectoryName(metadata));
        this.operations.copy(copySpec -> {
            copySpec.from(new Object[]{unpackFolder});
            copySpec.into((Object)installFolder);
        });
        this.operations.delete(new Object[]{unpackFolder});
        LOGGER.info("Installed toolchain from {} into {}", (Object)uri, (Object)installFolder);
        return this.getJavaHome(this.markedLocation(installFolder));
    }

    private static String toDirectoryName(JvmInstallationMetadata metadata) {
        String vendor = metadata.getJvmVendor();
        if (vendor == null || vendor.isEmpty()) {
            vendor = metadata.getVendor().getRawVendor();
        }
        String version = metadata.getLanguageVersion().getMajorVersion();
        String architecture = metadata.getArchitecture();
        String os = OperatingSystem.current().getFamilyName();
        return String.format("%s-%s-%s-%s", vendor, version, architecture, os).replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase();
    }

    private File unpack(File jdkArchive) {
        FileTree fileTree = this.asFileTree(jdkArchive);
        String unpackFolderName = JdkCacheDirectory.getNameWithoutExtension(jdkArchive);
        File unpackFolder = new File(this.jdkDirectory, unpackFolderName);
        if (!unpackFolder.exists()) {
            this.operations.copy(spec -> {
                spec.from(new Object[]{fileTree});
                spec.into((Object)unpackFolder);
            });
        }
        return unpackFolder;
    }

    private File markedLocation(File unpackFolder) {
        File[] content = unpackFolder.listFiles();
        if (content == null) {
            throw new RuntimeException("Programming error");
        }
        for (File file : content) {
            if (!file.isDirectory()) continue;
            return file;
        }
        return unpackFolder;
    }

    private File markAsReady(File destination) {
        try {
            new File(destination, MARKER_FILE).createNewFile();
            return destination;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create .ok file", (Throwable)e);
        }
    }

    private FileTree asFileTree(File jdkArchive) {
        String extension = FilenameUtils.getExtension((String)jdkArchive.getName());
        if (Objects.equals(extension, "zip")) {
            return this.operations.zipTree((Object)jdkArchive);
        }
        return this.operations.tarTree((Object)this.operations.getResources().gzip((Object)jdkArchive));
    }

    public FileLock acquireWriteLock(File destinationFile, String operationName) {
        return this.lockManager.lock(destinationFile, (LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive), destinationFile.getName(), operationName);
    }

    public File getDownloadLocation() {
        return this.jdkDirectory;
    }

    private static String getNameWithoutExtension(File file) {
        String input;
        String output = file.getName();
        while (!(input = output).equals(output = Files.getNameWithoutExtension((String)input))) {
        }
        return output;
    }
}

