/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;

public final class MethodSignature {
    private final String methodName;
    private final MethodType methodType;

    public static MethodSignature from(Method method) {
        return new MethodSignature(method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()));
    }

    private MethodSignature(String methodName, MethodType methodType) {
        this.methodName = methodName;
        this.methodType = methodType;
    }

    public String methodName() {
        return this.methodName;
    }

    public MethodType methodType() {
        return this.methodType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        return this.methodName.equals(that.methodName) && this.methodType.equals((Object)that.methodType);
    }

    public int hashCode() {
        return Objects.hash(this.methodName, this.methodType);
    }
}

