/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public abstract class JavaLibraryPlugin
implements Plugin<Project> {
    private final JvmEcosystemUtilities jvmEcosystemUtilities;

    @Inject
    public JavaLibraryPlugin(JvmEcosystemUtilities jvmEcosystemUtilities) {
        this.jvmEcosystemUtilities = jvmEcosystemUtilities;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        ConfigurationContainer configurations = project.getConfigurations();
        SourceSet sourceSet = (SourceSet)sourceSets.getByName("main");
        JvmPluginsHelper.addApiToSourceSet(sourceSet, configurations);
        this.makeCompileOnlyApiVisibleToTests(configurations);
        Configuration apiElements = configurations.getByName(sourceSet.getApiElementsConfigurationName());
        this.jvmEcosystemUtilities.configureClassesDirectoryVariant(apiElements, sourceSet);
    }

    private void makeCompileOnlyApiVisibleToTests(ConfigurationContainer configurations) {
        Configuration testCompileOnly = configurations.getByName("testCompileOnly");
        Configuration compileOnlyApi = configurations.getByName("compileOnlyApi");
        testCompileOnly.extendsFrom(new Configuration[]{compileOnlyApi});
    }
}

