/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.internal.JvmModelingServices;
import org.gradle.api.plugins.jvm.internal.JvmVariantBuilder;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.ProjectTestFixtures;

public abstract class JavaTestFixturesPlugin
implements Plugin<Project> {
    private final JvmModelingServices jvmEcosystemUtilities;

    @Inject
    public JavaTestFixturesPlugin(JvmModelingServices jvmModelingServices) {
        this.jvmEcosystemUtilities = jvmModelingServices;
    }

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            SourceSet testFixturesSourceSet = (SourceSet)extension.getSourceSets().maybeCreate("testFixtures");
            this.jvmEcosystemUtilities.createJvmVariant("testFixtures", testFixturesSourceSet, (Action<? super JvmVariantBuilder>)((Action)builder -> builder.published()));
            this.createImplicitTestFixturesDependencies(project);
        });
    }

    private void createImplicitTestFixturesDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("testFixturesApi", (Object)dependencies.create((Object)project));
        SourceSet testSourceSet = JavaPluginHelper.getDefaultTestSuite(project).getSources();
        ProjectDependency testDependency = (ProjectDependency)dependencies.add(testSourceSet.getImplementationConfigurationName(), (Object)dependencies.create((Object)project));
        testDependency.capabilities((Action)new ProjectTestFixtures(project));
        ConfigurationContainer configurations = project.getConfigurations();
        testSourceSet.setCompileClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{configurations.getByName(testSourceSet.getCompileClasspathConfigurationName())}));
        testSourceSet.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{testSourceSet.getOutput(), configurations.getByName(testSourceSet.getRuntimeClasspathConfigurationName())}));
    }
}

