/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.plugins.internal.FeatureSpecInternal;
import org.gradle.api.plugins.jvm.internal.JvmModelingServices;
import org.gradle.api.plugins.jvm.internal.JvmVariantBuilder;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;

public class DefaultJavaFeatureSpec
implements FeatureSpecInternal {
    private final String name;
    private final List<Capability> capabilities = Lists.newArrayListWithExpectedSize((int)2);
    private final JvmModelingServices jvmEcosystemUtilities;
    private boolean overrideDefaultCapability = true;
    private SourceSet sourceSet;
    private boolean withJavadocJar = false;
    private boolean withSourcesJar = false;
    private boolean allowPublication = true;

    public DefaultJavaFeatureSpec(String name, Capability defaultCapability, JvmModelingServices jvmModelingServices) {
        this.name = name;
        this.jvmEcosystemUtilities = jvmModelingServices;
        this.capabilities.add(defaultCapability);
    }

    @Override
    public void usingSourceSet(SourceSet sourceSet) {
        this.sourceSet = sourceSet;
    }

    @Override
    public void capability(String group, String name, String version) {
        if (this.overrideDefaultCapability) {
            this.capabilities.clear();
            this.overrideDefaultCapability = false;
        }
        this.capabilities.add((Capability)new DefaultImmutableCapability(group, name, version));
    }

    @Override
    public void create() {
        this.setupConfigurations(this.sourceSet);
    }

    @Override
    public void withJavadocJar() {
        this.withJavadocJar = true;
    }

    @Override
    public void withSourcesJar() {
        this.withSourcesJar = true;
    }

    @Override
    public void disablePublication() {
        this.allowPublication = false;
    }

    private void setupConfigurations(SourceSet sourceSet) {
        if (sourceSet == null) {
            throw new InvalidUserCodeException("You must specify which source set to use for feature '" + this.name + "'");
        }
        this.jvmEcosystemUtilities.createJvmVariant(this.name, sourceSet, (Action<? super JvmVariantBuilder>)((Action)builder -> {
            builder.withDisplayName("feature " + this.name);
            if (this.withJavadocJar) {
                builder.withJavadocJar();
            }
            if (this.withSourcesJar) {
                builder.withSourcesJar();
            }
            if (this.allowPublication) {
                builder.published();
            }
            for (Capability capability : this.capabilities) {
                builder.capability(capability);
            }
        }));
    }
}

