/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.FileBasedInstallationFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class LinuxInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private final String[] roots;
    private final OperatingSystem os;

    @Inject
    public LinuxInstallationSupplier(ProviderFactory factory) {
        this(factory, OperatingSystem.current(), "/usr/lib/jvm", "/usr/lib64/jvm", "/usr/java", "/usr/local/java");
    }

    private LinuxInstallationSupplier(ProviderFactory factory, OperatingSystem os, String ... roots) {
        super(factory);
        this.roots = roots;
        this.os = os;
    }

    @Override
    protected Set<InstallationLocation> findCandidates() {
        if (this.os.isLinux()) {
            return Arrays.stream(this.roots).map(root -> FileBasedInstallationFactory.fromDirectory(new File((String)root), "Common Linux Locations")).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

