/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.internal.ClasspathFactory;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.resolver.DefaultGradleApiSourcesResolver;
import org.gradle.util.internal.ConfigureUtil;

public abstract class EclipseClasspath {
    private Iterable<SourceSet> sourceSets;
    private Collection<Configuration> plusConfigurations = new ArrayList<Configuration>();
    private Collection<Configuration> minusConfigurations = new ArrayList<Configuration>();
    private Set<String> containers = new LinkedHashSet<String>();
    private File defaultOutputDir;
    private boolean downloadSources = true;
    private boolean downloadJavadoc;
    private XmlFileContentMerger file = new XmlFileContentMerger(new XmlTransformer());
    private Map<String, File> pathVariables = new HashMap<String, File>();
    private boolean projectDependenciesOnly;
    private List<File> classFolders;
    private final Project project;
    private final Property<Boolean> containsTestFixtures;
    private final SetProperty<SourceSet> testSourceSets;
    private final SetProperty<Configuration> testConfigurations;

    @Inject
    public EclipseClasspath(Project project) {
        this.project = project;
        this.containsTestFixtures = project.getObjects().property(Boolean.class).convention((Object)false);
        this.testSourceSets = project.getObjects().setProperty(SourceSet.class);
        this.testConfigurations = project.getObjects().setProperty(Configuration.class);
    }

    public Iterable<SourceSet> getSourceSets() {
        return this.sourceSets;
    }

    public void setSourceSets(Iterable<SourceSet> sourceSets) {
        this.sourceSets = sourceSets;
    }

    public Collection<Configuration> getPlusConfigurations() {
        return this.plusConfigurations;
    }

    public void setPlusConfigurations(Collection<Configuration> plusConfigurations) {
        this.plusConfigurations = plusConfigurations;
    }

    public Collection<Configuration> getMinusConfigurations() {
        return this.minusConfigurations;
    }

    public void setMinusConfigurations(Collection<Configuration> minusConfigurations) {
        this.minusConfigurations = minusConfigurations;
    }

    public Set<String> getContainers() {
        return this.containers;
    }

    public void setContainers(Set<String> containers) {
        this.containers = containers;
    }

    public File getDefaultOutputDir() {
        return this.defaultOutputDir;
    }

    public void setDefaultOutputDir(File defaultOutputDir) {
        this.defaultOutputDir = defaultOutputDir;
    }

    @Incubating
    public abstract Property<File> getBaseSourceOutputDir();

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    public boolean isDownloadJavadoc() {
        return this.downloadJavadoc;
    }

    public void setDownloadJavadoc(boolean downloadJavadoc) {
        this.downloadJavadoc = downloadJavadoc;
    }

    public XmlFileContentMerger getFile() {
        return this.file;
    }

    public void setFile(XmlFileContentMerger file) {
        this.file = file;
    }

    public Map<String, File> getPathVariables() {
        return this.pathVariables;
    }

    public void setPathVariables(Map<String, File> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public boolean isProjectDependenciesOnly() {
        return this.projectDependenciesOnly;
    }

    public void setProjectDependenciesOnly(boolean projectDependenciesOnly) {
        this.projectDependenciesOnly = projectDependenciesOnly;
    }

    public List<File> getClassFolders() {
        return this.classFolders;
    }

    public void setClassFolders(List<File> classFolders) {
        this.classFolders = classFolders;
    }

    public Project getProject() {
        return this.project;
    }

    public void containers(String ... containers) {
        Preconditions.checkNotNull((Object)containers);
        this.containers.addAll(Arrays.asList(containers));
    }

    public void file(@DelegatesTo(value=XmlFileContentMerger.class) Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.file);
    }

    public void file(Action<? super XmlFileContentMerger> action) {
        action.execute((Object)this.file);
    }

    public List<ClasspathEntry> resolveDependencies() {
        JavaCompile javaCompile;
        ProjectInternal projectInternal = (ProjectInternal)this.project;
        IdeArtifactRegistry ideArtifactRegistry = (IdeArtifactRegistry)projectInternal.getServices().get(IdeArtifactRegistry.class);
        boolean inferModulePath = false;
        Task javaCompileTask = (Task)this.project.getTasks().findByName("compileJava");
        if (javaCompileTask instanceof JavaCompile && (inferModulePath = ((Boolean)(javaCompile = (JavaCompile)javaCompileTask).getModularity().getInferModulePath().get()).booleanValue())) {
            List sourceRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)((FileTreeInternal)javaCompile.getSource()));
            inferModulePath = JavaModuleDetector.isModuleSource((boolean)true, (Iterable)sourceRoots);
        }
        ClasspathFactory classpathFactory = new ClasspathFactory(this, ideArtifactRegistry, new DefaultGradleApiSourcesResolver(projectInternal.newDetachedResolver()), inferModulePath);
        return classpathFactory.createEntries();
    }

    public void mergeXmlClasspath(Classpath xmlClasspath) {
        this.file.getBeforeMerged().execute((Object)xmlClasspath);
        List<ClasspathEntry> entries = this.resolveDependencies();
        xmlClasspath.configure(entries);
        this.file.getWhenMerged().execute((Object)xmlClasspath);
    }

    public FileReferenceFactory getFileReferenceFactory() {
        FileReferenceFactory referenceFactory = new FileReferenceFactory();
        this.pathVariables.forEach((key, value) -> referenceFactory.addPathVariable((String)key, (File)value));
        return referenceFactory;
    }

    public Property<Boolean> getContainsTestFixtures() {
        return this.containsTestFixtures;
    }

    @Incubating
    public SetProperty<SourceSet> getTestSourceSets() {
        return this.testSourceSets;
    }

    @Incubating
    public SetProperty<Configuration> getTestConfigurations() {
        return this.testConfigurations;
    }
}

