/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;

public class DetachedDependencyMetadataProvider
implements DependencyMetaDataProvider {
    private final DependencyMetaDataProvider delegate;
    private final String suffix;

    public DetachedDependencyMetadataProvider(DependencyMetaDataProvider delegate, String suffix) {
        this.delegate = delegate;
        this.suffix = suffix;
    }

    public Module getModule() {
        Module module = this.delegate.getModule();
        return new DetachedModule(this.suffix, module);
    }

    private static class DetachedModule
    implements Module {
        private final Module module;
        private final String suffix;

        public DetachedModule(String suffix, Module module) {
            this.module = module;
            this.suffix = suffix;
        }

        public ComponentIdentifier getComponentId() {
            return new DefaultModuleComponentIdentifier(DefaultModuleIdentifier.newId(this.getGroup(), this.getName()), this.getVersion());
        }

        public String getGroup() {
            return this.module.getGroup();
        }

        public String getName() {
            return this.module.getVersion() + "-" + this.suffix;
        }

        public String getVersion() {
            return this.module.getVersion();
        }

        public String getStatus() {
            return this.module.getStatus();
        }
    }
}

