/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.internal.sharedruntime.support;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.kotlin.dsl.internal.sharedruntime.support.ClassBytesRepository;
import org.gradle.kotlin.dsl.internal.sharedruntime.support.ClassBytesRepositoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0014\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u00160\u0015J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u000bJ.\u0010\u0019\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e0\nj\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u001e\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J.\u0010!\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e0\nj\u0002`\u000f2\u0006\u0010\"\u001a\u00020\u0006H\u0002J.\u0010#\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e0\nj\u0002`\u000f2\u0006\u0010$\u001a\u00020\u0006H\u0002J.\u0010%\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e0\nj\u0002`\u000f2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0006H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010$\u001a\u00020\u0006H\u0002R2\u0010\t\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u000b\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e0\nj\u0002`\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gradle/kotlin/dsl/internal/sharedruntime/support/ClassBytesRepository;", "Ljava/io/Closeable;", "platformClassLoader", "Ljava/lang/ClassLoader;", "classPathFiles", "", "Ljava/io/File;", "classPathDependencies", "(Ljava/lang/ClassLoader;Ljava/util/List;Ljava/util/List;)V", "classBytesIndex", "Lkotlin/Function1;", "", "Lkotlin/Function0;", "", "Lorg/gradle/kotlin/dsl/internal/sharedruntime/support/ClassBytesSupplier;", "Lorg/gradle/kotlin/dsl/internal/sharedruntime/support/ClassBytesIndex;", "openJars", "", "Ljava/util/jar/JarFile;", "relevantClassPathFiles", "allClassesBytesBySourceName", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "classBytesFor", "sourceName", "classBytesIndexFor", "entry", "", "classBytesSupplierForFilePath", "classFilePath", "classBytesSupplierForSourceName", "close", "", "directoryClassBytesIndexFor", "dir", "jarClassBytesIndexFor", "jar", "loaderClassBytesIndexFor", "loader", "openJarFile", "file", "sourceNamesFrom", "sourceNamesFromDir", "sourceNamesFromJar", "kotlin-dsl-shared-runtime"})
@SourceDebugExtension(value={"SMAP\nClassBytesRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassBytesRepository.kt\norg/gradle/kotlin/dsl/internal/sharedruntime/support/ClassBytesRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n766#2:213\n857#2,2:214\n1549#2:216\n1620#2,3:217\n1855#2,2:221\n1#3:220\n*S KotlinDebug\n*F\n+ 1 ClassBytesRepository.kt\norg/gradle/kotlin/dsl/internal/sharedruntime/support/ClassBytesRepository\n*L\n47#1:213\n47#1:214,2\n53#1:216\n53#1:217,3\n143#1:221,2\n*E\n"})
public final class ClassBytesRepository
implements Closeable {
    @NotNull
    private final List<File> relevantClassPathFiles;
    @NotNull
    private final Map<File, JarFile> openJars;
    @NotNull
    private final List<Function1<String, Function0<byte[]>>> classBytesIndex;

    /*
     * WARNING - void declaration
     */
    public ClassBytesRepository(@NotNull ClassLoader platformClassLoader, @NotNull List<? extends File> classPathFiles, @NotNull List<? extends File> classPathDependencies) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)platformClassLoader, (String)"platformClassLoader");
        Intrinsics.checkNotNullParameter(classPathFiles, (String)"classPathFiles");
        Intrinsics.checkNotNullParameter(classPathDependencies, (String)"classPathDependencies");
        Iterable iterable = classPathFiles;
        ClassBytesRepository classBytesRepository = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!(it.isDirectory() || it.isFile() && it.length() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        classBytesRepository.relevantClassPathFiles = (List)destination$iv$iv;
        this.openJars = new LinkedHashMap();
        $this$filter$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.relevantClassPathFiles, (Iterable)classPathDependencies), (Object)platformClassLoader);
        classBytesRepository = this;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.classBytesIndexFor(it));
        }
        classBytesRepository.classBytesIndex = (List)destination$iv$iv;
    }

    public /* synthetic */ ClassBytesRepository(ClassLoader classLoader, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(classLoader, list, list2);
    }

    @Nullable
    public final byte[] classBytesFor(@NotNull String sourceName) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Function0<byte[]> function0 = this.classBytesSupplierForSourceName(sourceName);
        if (function0 != null) {
            Function0<byte[]> it = function0;
            boolean bl = false;
            byArray = (byte[])it.invoke();
        } else {
            byArray = null;
        }
        return byArray;
    }

    @NotNull
    public final Sequence<Pair<String, Function0<byte[]>>> allClassesBytesBySourceName() {
        return SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.relevantClassPathFiles), (Function1)((Function1)new Function1<File, Sequence<? extends String>>(this){
            final /* synthetic */ ClassBytesRepository this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<String> invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ClassBytesRepository.access$sourceNamesFrom(this.this$0, it);
            }
        })), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends Function0<? extends byte[]>>>(this){
            final /* synthetic */ ClassBytesRepository this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<String, Function0<byte[]>> invoke(@NotNull String sourceName) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
                Function0 function0 = ClassBytesRepository.access$classBytesSupplierForSourceName(this.this$0, sourceName);
                if (function0 != null) {
                    Function0 it = function0;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)sourceName, (Object)it);
                } else {
                    pair = null;
                }
                return pair;
            }
        }));
    }

    private final Function0<byte[]> classBytesSupplierForSourceName(String sourceName) {
        return (Function0)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull(ClassBytesRepositoryKt.classFilePathCandidatesFor(sourceName), (Function1)((Function1)new Function1<String, Function0<? extends byte[]>>((Object)this){

            @Nullable
            public final Function0<byte[]> invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ClassBytesRepository.access$classBytesSupplierForFilePath((ClassBytesRepository)this.receiver, p0);
            }
        })));
    }

    private final Function0<byte[]> classBytesSupplierForFilePath(String classFilePath) {
        return (Function0)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.classBytesIndex), (Function1)((Function1)new Function1<Function1<? super String, ? extends Function0<? extends byte[]>>, Function0<? extends byte[]>>(classFilePath){
            final /* synthetic */ String $classFilePath;
            {
                this.$classFilePath = $classFilePath;
                super(1);
            }

            @Nullable
            public final Function0<byte[]> invoke(@NotNull Function1<? super String, ? extends Function0<byte[]>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Function0)it.invoke((Object)this.$classFilePath);
            }
        })));
    }

    private final Sequence<String> sourceNamesFrom(File entry) {
        return ClassBytesRepositoryKt.access$isClassPathArchive(entry) ? this.sourceNamesFromJar(entry) : (entry.isDirectory() ? this.sourceNamesFromDir(entry) : SequencesKt.emptySequence());
    }

    private final Sequence<String> sourceNamesFromJar(File jar) {
        JarFile $this$sourceNamesFromJar_u24lambda_u243 = this.openJarFile(jar);
        boolean bl = false;
        Enumeration<JarEntry> enumeration = $this$sourceNamesFromJar_u24lambda_u243.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)sourceNamesFromJar.1.1.INSTANCE), (Function1)sourceNamesFromJar.1.2.INSTANCE);
    }

    private final Sequence<String> sourceNamesFromDir(File dir) {
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)dir)), (Function1)sourceNamesFromDir.1.INSTANCE), (Function1)((Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = FilesKt.relativeTo((File)it, (File)this.$dir).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                return ClassBytesRepositoryKt.kotlinSourceNameOf(ClassBytesRepositoryKt.access$normaliseFileSeparators(string));
            }
        }));
    }

    private final Function1<String, Function0<byte[]>> classBytesIndexFor(Object entry) {
        Object object = entry;
        return object instanceof File ? (ClassBytesRepositoryKt.access$isClassPathArchive((File)entry) ? this.jarClassBytesIndexFor((File)entry) : (((File)entry).isDirectory() ? this.directoryClassBytesIndexFor((File)entry) : (Function1<String, Function0<byte[]>>)classBytesIndexFor.1.INSTANCE)) : (object instanceof ClassLoader ? this.loaderClassBytesIndexFor((ClassLoader)entry) : (Function1<String, Function0<byte[]>>)classBytesIndexFor.2.INSTANCE);
    }

    private final Function1<String, Function0<byte[]>> jarClassBytesIndexFor(File jar) {
        return (Function1)new Function1<String, Function0<? extends byte[]>>(this, jar){
            final /* synthetic */ ClassBytesRepository this$0;
            final /* synthetic */ File $jar;
            {
                this.this$0 = $receiver;
                this.$jar = $jar;
                super(1);
            }

            @Nullable
            public final Function0<byte[]> invoke(@NotNull String classFilePath) {
                Function0 function0;
                JarEntry jarEntry;
                Intrinsics.checkNotNullParameter((Object)classFilePath, (String)"classFilePath");
                JarFile $this$invoke_u24lambda_u241 = ClassBytesRepository.access$openJarFile(this.this$0, this.$jar);
                boolean bl = false;
                JarEntry jarEntry2 = jarEntry = $this$invoke_u24lambda_u241.getJarEntry(classFilePath);
                if (jarEntry2 != null) {
                    Intrinsics.checkNotNull((Object)jarEntry2);
                    JarEntry jarEntry3 = jarEntry;
                    boolean bl2 = false;
                    function0 = (Function0)new Function0<byte[]>($this$invoke_u24lambda_u241, jarEntry3){
                        final /* synthetic */ JarFile $this_run;
                        final /* synthetic */ JarEntry $jarEntry;
                        {
                            this.$this_run = $receiver;
                            this.$jarEntry = $jarEntry;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @NotNull
                        public final byte[] invoke() {
                            byte[] byArray;
                            Closeable closeable = this.$this_run.getInputStream(this.$jarEntry);
                            Throwable throwable = null;
                            try {
                                InputStream jarInput = (InputStream)closeable;
                                boolean bl = false;
                                Intrinsics.checkNotNull((Object)jarInput);
                                byArray = ByteStreamsKt.readBytes((InputStream)jarInput);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            return byArray;
                        }
                    };
                } else {
                    function0 = null;
                }
                return function0;
            }
        };
    }

    private final Function1<String, Function0<byte[]>> directoryClassBytesIndexFor(File dir) {
        return (Function1)new Function1<String, Function0<? extends byte[]>>(dir){
            final /* synthetic */ File $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            @Nullable
            public final Function0<byte[]> invoke(@NotNull String classFilePath) {
                Function0 function0;
                File file;
                Intrinsics.checkNotNullParameter((Object)classFilePath, (String)"classFilePath");
                File it = file = FilesKt.resolve((File)this.$dir, (String)classFilePath);
                boolean bl = false;
                File file2 = it.isFile() ? file : null;
                if (file2 != null) {
                    File classFile = file2;
                    boolean bl2 = false;
                    function0 = (Function0)new Function0<byte[]>(classFile){
                        final /* synthetic */ File $classFile;
                        {
                            this.$classFile = $classFile;
                            super(0);
                        }

                        @NotNull
                        public final byte[] invoke() {
                            return FilesKt.readBytes((File)this.$classFile);
                        }
                    };
                } else {
                    function0 = null;
                }
                return function0;
            }
        };
    }

    private final Function1<String, Function0<byte[]>> loaderClassBytesIndexFor(ClassLoader loader) {
        return (Function1)new Function1<String, Function0<? extends byte[]>>(loader){
            final /* synthetic */ ClassLoader $loader;
            {
                this.$loader = $loader;
                super(1);
            }

            @Nullable
            public final Function0<byte[]> invoke(@NotNull String classFilePath) {
                Function0 function0;
                Intrinsics.checkNotNullParameter((Object)classFilePath, (String)"classFilePath");
                URL uRL = this.$loader.getResource(classFilePath);
                if (uRL != null) {
                    URL uRL2 = uRL;
                    ClassLoader classLoader = this.$loader;
                    URL it = uRL2;
                    boolean bl = false;
                    function0 = (Function0)new Function0<byte[]>(classLoader, classFilePath){
                        final /* synthetic */ ClassLoader $loader;
                        final /* synthetic */ String $classFilePath;
                        {
                            this.$loader = $loader;
                            this.$classFilePath = $classFilePath;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @NotNull
                        public final byte[] invoke() {
                            byte[] byArray;
                            Closeable closeable = this.$loader.getResourceAsStream(this.$classFilePath);
                            Throwable throwable = null;
                            try {
                                InputStream it = (InputStream)closeable;
                                boolean bl = false;
                                InputStream inputStream = it;
                                Intrinsics.checkNotNull((Object)inputStream);
                                byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            return byArray;
                        }
                    };
                } else {
                    function0 = null;
                }
                return function0;
            }
        };
    }

    private final JarFile openJarFile(File file) {
        JarFile jarFile = this.openJars.computeIfAbsent(file, arg_0 -> ClassBytesRepository.openJarFile$lambda$4(openJarFile.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jarFile, (String)"computeIfAbsent(...)");
        return jarFile;
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.openJars.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarFile p0 = (JarFile)element$iv;
            boolean bl = false;
            p0.close();
        }
    }

    private static final JarFile openJarFile$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JarFile)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Sequence access$sourceNamesFrom(ClassBytesRepository $this, File entry) {
        return $this.sourceNamesFrom(entry);
    }

    public static final /* synthetic */ Function0 access$classBytesSupplierForSourceName(ClassBytesRepository $this, String sourceName) {
        return $this.classBytesSupplierForSourceName(sourceName);
    }

    public static final /* synthetic */ Function0 access$classBytesSupplierForFilePath(ClassBytesRepository $this, String classFilePath) {
        return $this.classBytesSupplierForFilePath(classFilePath);
    }

    public static final /* synthetic */ JarFile access$openJarFile(ClassBytesRepository $this, File file) {
        return $this.openJarFile(file);
    }
}

