/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponent;
import org.jetbrains.kotlin.fir.FirEnumWhenTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNothingExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnSealedClassExhaustivenessChecker;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J)\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u0002H\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "computeStatusForNonIntersectionType", "Lorg/jetbrains/kotlin/fir/expressions/ExhaustivenessStatus;", "unwrappedSubjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "processExhaustivenessCheck", "", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformWhenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,414:1\n1747#2,3:415\n59#3:418\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer\n*L\n108#1:415,3\n126#1:418\n*E\n"})
public final class FirWhenExhaustivenessTransformer
extends FirTransformer<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    public FirWhenExhaustivenessTransformer(@NotNull BodyResolveComponents bodyResolveComponents) {
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents, (String)"bodyResolveComponents");
        this.bodyResolveComponents = bodyResolveComponents;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        throw new IllegalArgumentException("Should not be there");
    }

    @Override
    @NotNull
    public FirStatement transformWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Object data2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            this.processExhaustivenessCheck(whenExpression);
            FirEnumWhenTrackerComponent firEnumWhenTrackerComponent = FirEnumWhenTrackerComponentKt.getEnumWhenTracker(this.bodyResolveComponents.getSession());
            if (firEnumWhenTrackerComponent == null) break block0;
            KtSourceFile ktSourceFile = this.bodyResolveComponents.getFile().getSourceFile();
            FirEnumWhenTrackerComponentKt.reportEnumUsageInWhen(firEnumWhenTrackerComponent, ktSourceFile != null ? ktSourceFile.getPath() : null, FirWhenExhaustivenessTransformer.Companion.getSubjectType(this.bodyResolveComponents.getSession(), whenExpression));
        }
        return whenExpression;
    }

    private final void processExhaustivenessCheck(FirWhenExpression whenExpression) {
        boolean bl;
        boolean bl2;
        block11: {
            Iterable $this$any$iv = whenExpression.getBranches();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirWhenBranch it = (FirWhenBranch)element$iv;
                    boolean bl3 = false;
                    if (!(it.getCondition() instanceof FirElseIfTrueCondition)) continue;
                    bl2 = true;
                    break block11;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.ProperlyExhaustive.INSTANCE);
            return;
        }
        FirSession session2 = this.bodyResolveComponents.getSession();
        ConeKotlinType coneKotlinType = FirWhenExhaustivenessTransformer.Companion.getSubjectType(session2, whenExpression);
        if (coneKotlinType == null) {
            FirWhenExhaustivenessTransformer $this$processExhaustivenessCheck_u24lambda_u241 = this;
            boolean bl4 = false;
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH());
            return;
        }
        ConeKotlinType subjectType = coneKotlinType;
        if (whenExpression.getBranches().isEmpty() && ConeBuiltinTypeUtilsKt.isNothing(subjectType)) {
            whenExpression.replaceExhaustivenessStatus(ExhaustivenessStatus.ExhaustiveAsNothing.INSTANCE);
            return;
        }
        ExhaustivenessStatus status2 = ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH();
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(subjectType, session2);
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isExpect$iv = firRegularClassSymbol;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else {
            bl = false;
        }
        if (!bl) {
            Collection unwrappedIntersectionTypes = FirWhenExhaustivenessTransformer.Companion.unwrapIntersectionType(subjectType);
            for (ConeKotlinType unwrappedSubjectType : unwrappedIntersectionTypes) {
                ExhaustivenessStatus localStatus = this.computeStatusForNonIntersectionType(unwrappedSubjectType, session2, whenExpression);
                if (localStatus == ExhaustivenessStatus.ProperlyExhaustive.INSTANCE) {
                    status2 = localStatus;
                    break;
                }
                if (localStatus == ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH() || status2 != ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH()) continue;
                status2 = localStatus;
            }
        }
        whenExpression.replaceExhaustivenessStatus(status2);
    }

    private final ExhaustivenessStatus computeStatusForNonIntersectionType(ConeKotlinType unwrappedSubjectType, FirSession session2, FirWhenExpression whenExpression) {
        List checkers = FirWhenExhaustivenessTransformer.Companion.getCheckers(unwrappedSubjectType, session2);
        if (checkers.isEmpty()) {
            return ExhaustivenessStatus.NotExhaustive.Companion.getNO_ELSE_BRANCH();
        }
        List whenMissingCases = new ArrayList();
        FirWhenExhaustivenessTransformer.Companion.collectMissingCases(whenMissingCases, checkers, whenExpression, unwrappedSubjectType, session2);
        return whenMissingCases.isEmpty() ? (ExhaustivenessStatus)ExhaustivenessStatus.ProperlyExhaustive.INSTANCE : (ExhaustivenessStatus)new ExhaustivenessStatus.NotExhaustive(whenMissingCases);
    }

    static {
        Object[] objectArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedClassExhaustivenessChecker.INSTANCE, WhenOnNothingExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J8\u0010\u0010\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00070\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015*\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion;", "", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "computeAllMissingCases", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "getCheckers", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSubjectType", "collectMissingCases", "", "", "checkers", "unwrapIntersectionType", "", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,414:1\n857#2,2:415\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirWhenExhaustivenessTransformer$Companion\n*L\n67#1:415,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<WhenMissingCase> computeAllMissingCases(@NotNull FirSession session2, @NotNull FirWhenExpression whenExpression) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            ConeKotlinType coneKotlinType = this.getSubjectType(session2, whenExpression);
            if (coneKotlinType == null) {
                return CollectionsKt.emptyList();
            }
            ConeKotlinType subjectType = coneKotlinType;
            List $this$computeAllMissingCases_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (ConeKotlinType type2 : Companion.unwrapIntersectionType(subjectType)) {
                List<WhenExhaustivenessChecker> checkers = Companion.getCheckers(type2, session2);
                Companion.collectMissingCases($this$computeAllMissingCases_u24lambda_u240, checkers, whenExpression, type2, session2);
            }
            return CollectionsKt.build((List)list2);
        }

        private final ConeKotlinType getSubjectType(FirSession session2, FirWhenExpression whenExpression) {
            Object object = whenExpression.getSubjectVariable();
            if (object == null || (object = ((FirVariable)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                FirPureAbstractElement firPureAbstractElement = whenExpression.getSubject();
                if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
                    object = FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement);
                } else {
                    return null;
                }
            }
            Object subjectType = object;
            return ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)subjectType, session2));
        }

        private final Collection<ConeKotlinType> unwrapIntersectionType(ConeKotlinType $this$unwrapIntersectionType) {
            Object object = $this$unwrapIntersectionType instanceof ConeIntersectionType ? (ConeIntersectionType)$this$unwrapIntersectionType : null;
            if (object == null || (object = ((ConeIntersectionType)object).getIntersectedTypes()) == null) {
                object = CollectionsKt.listOf((Object)$this$unwrapIntersectionType);
            }
            return object;
        }

        private final List<WhenExhaustivenessChecker> getCheckers(ConeKotlinType subjectType, FirSession session2) {
            List list2;
            List $this$getCheckers_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterable $this$filterTo$iv = exhaustivenessCheckers;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                WhenExhaustivenessChecker it = (WhenExhaustivenessChecker)element$iv;
                boolean bl2 = false;
                if (!it.isApplicable(subjectType, session2)) continue;
                ((Collection)$this$getCheckers_u24lambda_u242).add(element$iv);
            }
            if (!((Collection)$this$getCheckers_u24lambda_u242).isEmpty() && ConeTypeUtilsKt.isMarkedNullable(subjectType)) {
                $this$getCheckers_u24lambda_u242.add(WhenOnNullableExhaustivenessChecker.INSTANCE);
            }
            return CollectionsKt.build((List)list2);
        }

        private final void collectMissingCases(List<WhenMissingCase> $this$collectMissingCases, List<? extends WhenExhaustivenessChecker> checkers, FirWhenExpression whenExpression, ConeKotlinType subjectType, FirSession session2) {
            for (WhenExhaustivenessChecker whenExhaustivenessChecker : checkers) {
                whenExhaustivenessChecker.computeMissingCases(whenExpression, subjectType, session2, (Collection<WhenMissingCase>)$this$collectMissingCases);
            }
            if ($this$collectMissingCases.isEmpty() && whenExpression.getBranches().isEmpty()) {
                $this$collectMissingCases.add(WhenMissingCase.Unknown.INSTANCE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

