/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.MutableModuleSources;
import org.gradle.internal.component.model.PersistentModuleSource;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class ModuleSourcesSerializer
implements Serializer<ModuleSources> {
    private final Map<Integer, PersistentModuleSource.Codec<? extends PersistentModuleSource>> moduleSourceCodecs;

    public ModuleSourcesSerializer(Map<Integer, PersistentModuleSource.Codec<? extends PersistentModuleSource>> moduleSourceCodecs) {
        this.moduleSourceCodecs = moduleSourceCodecs;
    }

    public void write(Encoder encoder, ModuleSources value) throws IOException {
        value.withSources(source -> {
            try {
                if (source instanceof PersistentModuleSource) {
                    PersistentModuleSource persistentModuleSource = (PersistentModuleSource)source;
                    int codecId = this.assertValidId(persistentModuleSource.getCodecId());
                    encoder.writeSmallInt(codecId);
                    PersistentModuleSource.Codec codec = (PersistentModuleSource.Codec)Cast.uncheckedCast(this.moduleSourceCodecs.get(codecId));
                    codec.encode(persistentModuleSource, encoder);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        encoder.writeSmallInt(0);
    }

    private int assertValidId(int codecId) {
        assert (codecId >= 0) : "Module source must have a strictly positive source id";
        return codecId;
    }

    public ModuleSources read(Decoder decoder) throws IOException {
        int codecId;
        MutableModuleSources sources = new MutableModuleSources();
        while ((codecId = decoder.readSmallInt()) > 0) {
            sources.add(this.moduleSourceCodecs.get(codecId).decode(decoder));
        }
        return sources;
    }
}

