/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.ReadStdInEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;
import org.gradle.internal.logging.events.UserInputValidationProblemEvent;

public abstract class AbstractUserInputRenderer
implements OutputEventListener {
    protected final OutputEventListener delegate;
    private final GlobalUserInputReceiver userInput;
    private final List<OutputEvent> eventQueue = new ArrayList<OutputEvent>();
    private boolean paused;

    public AbstractUserInputRenderer(OutputEventListener delegate, GlobalUserInputReceiver userInput) {
        this.delegate = delegate;
        this.userInput = userInput;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof UserInputRequestEvent) {
            this.handleUserInputRequestEvent();
            return;
        }
        if (event instanceof UserInputResumeEvent) {
            this.handleUserInputResumeEvent((UserInputResumeEvent)event);
            return;
        }
        if (event instanceof PromptOutputEvent) {
            this.handlePromptOutputEvent((PromptOutputEvent)event);
            return;
        }
        if (event instanceof UserInputValidationProblemEvent) {
            this.handleValidationProblemEvent((UserInputValidationProblemEvent)event);
            return;
        }
        if (event instanceof ReadStdInEvent) {
            this.userInput.readAndForwardStdin((ReadStdInEvent)event);
            return;
        }
        if (this.paused) {
            this.eventQueue.add(event);
            return;
        }
        this.delegate.onOutput(event);
    }

    private void handleValidationProblemEvent(UserInputValidationProblemEvent event) {
        this.handlePrompt(event);
    }

    private void handlePromptOutputEvent(PromptOutputEvent event) {
        this.userInput.readAndForwardText(event);
        this.handlePrompt(event);
    }

    private void handleUserInputRequestEvent() {
        this.startInput();
        this.paused = true;
    }

    private void handleUserInputResumeEvent(UserInputResumeEvent event) {
        if (!this.paused) {
            throw new IllegalStateException("Cannot resume user input if not paused yet");
        }
        this.paused = false;
        this.finishInput(event);
        this.replayEvents();
    }

    private void replayEvents() {
        ListIterator<OutputEvent> iterator = this.eventQueue.listIterator();
        while (iterator.hasNext()) {
            this.delegate.onOutput(iterator.next());
            iterator.remove();
        }
    }

    List<OutputEvent> getEventQueue() {
        return this.eventQueue;
    }

    abstract void startInput();

    abstract void handlePrompt(RenderableOutputEvent var1);

    abstract void finishInput(RenderableOutputEvent var1);
}

