/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.gradle.cache.FileLockReleasedSignal;
import org.gradle.cache.internal.locklistener.FileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.GracefullyStoppedException;
import org.gradle.cache.internal.locklistener.InetAddressProvider;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockContentionHandler
implements FileLockContentionHandler,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockContentionHandler.class);
    private static final int PING_DELAY = 1000;
    private final Lock lock = new ReentrantLock();
    private final Map<Long, ContendedAction> contendedActions = new HashMap<Long, ContendedAction>();
    private final Map<Long, FileLockReleasedSignal> lockReleasedSignals = new HashMap<Long, FileLockReleasedSignal>();
    private final Map<Long, Integer> unlocksRequestedFrom = new HashMap<Long, Integer>();
    private final Map<Long, Integer> unlocksConfirmedFrom = new HashMap<Long, Integer>();
    private final ExecutorFactory executorFactory;
    private final InetAddressProvider inetAddressProvider;
    private FileLockCommunicator communicator;
    private ManagedExecutor fileLockRequestListener;
    private ManagedExecutor unlockActionExecutor;
    private boolean stopped;

    public DefaultFileLockContentionHandler(ExecutorFactory executorFactory, InetAddressProvider inetAddressProvider) {
        this.executorFactory = executorFactory;
        this.inetAddressProvider = inetAddressProvider;
    }

    private Runnable listener() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    LOGGER.debug("Starting file lock listener thread.");
                    this.doRun();
                }
                catch (Throwable t) {
                    LOGGER.error("Problems handling incoming cache access requests.", t);
                }
                finally {
                    LOGGER.debug("File lock listener thread completed.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doRun() {
                while (true) {
                    FileLockPacketPayload payload;
                    DatagramPacket packet;
                    try {
                        packet = DefaultFileLockContentionHandler.this.communicator.receive();
                        payload = DefaultFileLockContentionHandler.this.communicator.decode(packet);
                    }
                    catch (GracefullyStoppedException e) {
                        return;
                    }
                    DefaultFileLockContentionHandler.this.lock.lock();
                    try {
                        ContendedAction contendedAction = (ContendedAction)DefaultFileLockContentionHandler.this.contendedActions.get(payload.getLockId());
                        if (contendedAction == null) {
                            DefaultFileLockContentionHandler.this.acceptConfirmationAsLockRequester(payload, packet.getPort());
                            continue;
                        }
                        contendedAction.addRequester(packet.getSocketAddress());
                        if (!contendedAction.running) {
                            DefaultFileLockContentionHandler.this.startLockReleaseAsLockHolder(contendedAction);
                        }
                        DefaultFileLockContentionHandler.this.communicator.confirmUnlockRequest(packet.getSocketAddress(), payload.getLockId());
                        continue;
                    }
                    finally {
                        DefaultFileLockContentionHandler.this.lock.unlock();
                        continue;
                    }
                    break;
                }
            }
        };
    }

    private void startLockReleaseAsLockHolder(ContendedAction contendedAction) {
        contendedAction.running = true;
        this.unlockActionExecutor.execute((Runnable)contendedAction);
    }

    private void acceptConfirmationAsLockRequester(FileLockPacketPayload payload, Integer port) {
        long lockId = payload.getLockId();
        if (payload.getType() == FileLockPacketType.LOCK_RELEASE_CONFIRMATION) {
            LOGGER.debug("Gradle process at port {} confirmed lock release for lock with id {}.", (Object)port, (Object)lockId);
            FileLockReleasedSignal signal = this.lockReleasedSignals.get(lockId);
            if (signal != null) {
                LOGGER.debug("Triggering lock release signal for lock with id {}.", (Object)lockId);
                signal.trigger();
            }
        } else {
            LOGGER.debug("Gradle process at port {} confirmed unlock request for lock with id {}.", (Object)port, (Object)lockId);
            this.unlocksConfirmedFrom.put(lockId, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(long lockId, Consumer<FileLockReleasedSignal> whenContended) {
        this.lock.lock();
        try {
            this.lockReleasedSignals.remove(lockId);
            this.unlocksRequestedFrom.remove(lockId);
            this.unlocksConfirmedFrom.remove(lockId);
            this.assertNotStopped();
            if (this.communicator == null) {
                throw new IllegalStateException("Must initialize the handler by reserving the port first.");
            }
            if (this.fileLockRequestListener == null) {
                this.fileLockRequestListener = this.executorFactory.create("File lock request listener");
                this.fileLockRequestListener.execute(this.listener());
            }
            if (this.unlockActionExecutor == null) {
                this.unlockActionExecutor = this.executorFactory.create("File lock release action executor");
            }
            if (this.contendedActions.containsKey(lockId)) {
                throw new UnsupportedOperationException("Multiple contention actions for a given lock are currently not supported.");
            }
            this.contendedActions.put(lockId, new ContendedAction(lockId, whenContended));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean maybePingOwner(int port, long lockId, String displayName, long timeElapsed, FileLockReleasedSignal signal) {
        if (Integer.valueOf(port).equals(this.unlocksConfirmedFrom.get(lockId))) {
            return false;
        }
        if (Integer.valueOf(port).equals(this.unlocksRequestedFrom.get(lockId)) && timeElapsed < 1000L) {
            return false;
        }
        boolean pingSentSuccessfully = this.getCommunicator().pingOwner(port, lockId, displayName);
        if (pingSentSuccessfully) {
            this.lock.lock();
            try {
                this.unlocksRequestedFrom.put(lockId, port);
                this.lockReleasedSignals.put(lockId, signal);
            }
            finally {
                this.lock.unlock();
            }
        }
        return pingSentSuccessfully;
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot start managing file contention because this handler has been closed.");
        }
    }

    @Override
    public void stop(long lockId) {
        this.lock.lock();
        try {
            this.contendedActions.remove(lockId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            this.contendedActions.clear();
            if (this.communicator != null) {
                this.communicator.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.fileLockRequestListener != null) {
            this.fileLockRequestListener.stop();
        }
        if (this.unlockActionExecutor != null) {
            this.unlockActionExecutor.stop();
        }
    }

    @Override
    public int reservePort() {
        return this.getCommunicator().getPort();
    }

    private FileLockCommunicator getCommunicator() {
        this.lock.lock();
        try {
            this.assertNotStopped();
            if (this.communicator == null) {
                this.communicator = new FileLockCommunicator(this.inetAddressProvider);
            }
            FileLockCommunicator fileLockCommunicator = this.communicator;
            return fileLockCommunicator;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class ContendedAction
    implements Runnable {
        private final Lock lock = new ReentrantLock();
        private final long lockId;
        private final Consumer<FileLockReleasedSignal> action;
        private Set<SocketAddress> requesters = new LinkedHashSet<SocketAddress>();
        private boolean running;

        private ContendedAction(long lockId, Consumer<FileLockReleasedSignal> action) {
            this.lockId = lockId;
            this.action = action;
        }

        @Override
        public void run() {
            this.action.accept(() -> {
                Set<SocketAddress> requesters = this.consumeRequesters();
                if (requesters == null) {
                    throw new IllegalStateException("trigger() has already been called and must at most be called once");
                }
                DefaultFileLockContentionHandler.this.communicator.confirmLockRelease(requesters, this.lockId);
            });
        }

        private void addRequester(SocketAddress contender) {
            this.lock.lock();
            try {
                if (this.requesters != null) {
                    this.requesters.add(contender);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private Set<SocketAddress> consumeRequesters() {
            this.lock.lock();
            try {
                Set<SocketAddress> set = this.requesters;
                return set;
            }
            finally {
                this.requesters = null;
                this.lock.unlock();
            }
        }
    }
}

