/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.Cast;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.Path;

@ServiceScope(value={Scope.Build.class})
public class DefaultProjectDependencyPublicationResolver
implements ProjectDependencyPublicationResolver {
    private final ProjectPublicationRegistry publicationRegistry;
    private final ProjectConfigurer projectConfigurer;
    private final ProjectStateRegistry projects;
    private final VariantCoordinateResolverCache resolverCache = new VariantCoordinateResolverCache();

    public DefaultProjectDependencyPublicationResolver(ProjectPublicationRegistry publicationRegistry, ProjectConfigurer projectConfigurer, ProjectStateRegistry projects) {
        this.publicationRegistry = publicationRegistry;
        this.projectConfigurer = projectConfigurer;
        this.projects = projects;
    }

    @Override
    public <T> T resolveComponent(Class<T> coordsType, Path identityPath) {
        return (T)this.withCoordinateResolver(coordsType, identityPath, VariantCoordinateResolver::getComponentCoordinates);
    }

    @Override
    @Nullable
    public <T> T resolveVariant(Class<T> coordsType, Path identityPath, String variantName) {
        return (T)this.withCoordinateResolver(coordsType, identityPath, resolver -> resolver.getVariantCoordinates(variantName));
    }

    private <T> T withCoordinateResolver(Class<T> coordsType, Path identityPath, Function<VariantCoordinateResolver<T>, T> action) {
        ProjectState projectState = this.projects.stateFor(identityPath);
        this.projectConfigurer.configureFully(projectState);
        return (T)projectState.fromMutableState(project -> {
            VariantCoordinateResolver resolver = this.resolverCache.computeIfAbsent(identityPath, coordsType, key -> this.createCoordinateResolver(identityPath, coordsType, (ProjectInternal)project));
            return action.apply(resolver);
        });
    }

    private <T> VariantCoordinateResolver<T> createCoordinateResolver(Path identityPath, Class<T> coordsType, ProjectInternal project) {
        Map<ProjectComponentPublication, T> publications = this.getPublications(identityPath, coordsType);
        if (publications.isEmpty()) {
            return VariantCoordinateResolver.fixed(DefaultProjectDependencyPublicationResolver.getImplicitCoordinates(coordsType, (Project)project));
        }
        LinkedHashSet<ProjectComponentPublication> topLevel = new LinkedHashSet<ProjectComponentPublication>();
        LinkedHashSet<ProjectComponentPublication> topLevelWithComponent = new LinkedHashSet<ProjectComponentPublication>();
        Set<SoftwareComponent> childComponents = DefaultProjectDependencyPublicationResolver.getChildComponents(publications.keySet());
        for (Map.Entry<ProjectComponentPublication, T> entry : publications.entrySet()) {
            ProjectComponentPublication publication = entry.getKey();
            SoftwareComponent component = (SoftwareComponent)publication.getComponent().getOrNull();
            if (publication.isAlias() || childComponents.contains(component)) continue;
            topLevel.add(publication);
            if (component == null) continue;
            topLevelWithComponent.add(publication);
        }
        if (topLevelWithComponent.size() == 1) {
            SoftwareComponentInternal singleComponent = (SoftwareComponentInternal)((ProjectComponentPublication)topLevelWithComponent.iterator().next()).getComponent().get();
            Map<SoftwareComponent, T> componentCoordinates = DefaultProjectDependencyPublicationResolver.getComponentCoordinates(coordsType, publications.keySet());
            return new MultiCoordinateVariantResolver((SoftwareComponent)singleComponent, identityPath, componentCoordinates);
        }
        return VariantCoordinateResolver.fixed(DefaultProjectDependencyPublicationResolver.getCommonCoordinates((Project)project, coordsType, topLevel));
    }

    private static <T> T getImplicitCoordinates(Class<T> coordsType, Project project) {
        if (coordsType.equals(ModuleVersionIdentifier.class)) {
            return coordsType.cast(DefaultModuleVersionIdentifier.newId(project.getGroup().toString(), project.getName(), project.getVersion().toString()));
        }
        throw new UnsupportedOperationException(String.format("Could not find any publications of type %s in %s.", coordsType.getSimpleName(), project.getDisplayName()));
    }

    private static <T> T getCommonCoordinates(Project project, Class<T> coordsType, Collection<ProjectComponentPublication> topLevel) {
        Iterator<ProjectComponentPublication> iterator = topLevel.iterator();
        T candidate = iterator.next().getCoordinates(coordsType);
        while (iterator.hasNext()) {
            T alternative = iterator.next().getCoordinates(coordsType);
            if (candidate.equals(alternative)) continue;
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Publishing is not able to resolve a dependency on a project with multiple publications that have different coordinates.");
            formatter.node("Found the following publications in " + project.getDisplayName());
            formatter.startChildren();
            for (ProjectComponentPublication publication : topLevel) {
                formatter.node(publication.getDisplayName().getCapitalizedDisplayName() + " with coordinates " + publication.getCoordinates(coordsType));
            }
            formatter.endChildren();
            throw new UnsupportedOperationException(formatter.toString());
        }
        return candidate;
    }

    private static <T> Map<SoftwareComponent, T> getComponentCoordinates(Class<T> coordsType, Collection<ProjectComponentPublication> publications) {
        HashMap<SoftwareComponent, T> coordinatesMap = new HashMap<SoftwareComponent, T>();
        for (ProjectComponentPublication publication : publications) {
            T coordinates;
            SoftwareComponent component = (SoftwareComponent)publication.getComponent().getOrNull();
            if (component == null || publication.isAlias() || (coordinates = publication.getCoordinates(coordsType)) == null) continue;
            coordinatesMap.put(component, coordinates);
        }
        return coordinatesMap;
    }

    private <T> Map<ProjectComponentPublication, T> getPublications(Path identityPath, Class<T> coordsType) {
        Collection<ProjectComponentPublication> allPublications = this.publicationRegistry.getPublicationsForProject(ProjectComponentPublication.class, identityPath);
        LinkedHashMap<ProjectComponentPublication, T> publications = new LinkedHashMap<ProjectComponentPublication, T>(allPublications.size());
        for (ProjectComponentPublication publication : allPublications) {
            T coordinates = publication.getCoordinates(coordsType);
            if (publication.isLegacy() || coordinates == null) continue;
            publications.put(publication, coordinates);
        }
        return publications;
    }

    private static Set<SoftwareComponent> getChildComponents(Collection<ProjectComponentPublication> publications) {
        HashSet<SoftwareComponent> children = new HashSet<SoftwareComponent>();
        for (ProjectComponentPublication publication : publications) {
            SoftwareComponent component = (SoftwareComponent)publication.getComponent().getOrNull();
            if (!(component instanceof ComponentWithVariants)) continue;
            ComponentWithVariants parent = (ComponentWithVariants)component;
            children.addAll(parent.getVariants());
        }
        return children;
    }

    private static class VariantCoordinateResolverCache {
        private final Map<Key, VariantCoordinateResolver<?>> cache = new ConcurrentHashMap();

        private VariantCoordinateResolverCache() {
        }

        public <T> VariantCoordinateResolver<T> computeIfAbsent(Path identityPath, Class<T> coordsType, Function<Key, VariantCoordinateResolver<T>> factory) {
            Key key = new Key(identityPath, coordsType);
            VariantCoordinateResolver<T> result = this.cache.computeIfAbsent(key, factory);
            return (VariantCoordinateResolver)Cast.uncheckedCast(result);
        }

        private static class Key {
            private final Path identityPath;
            private final Class<?> coordsType;

            public Key(Path identityPath, Class<?> coordsType) {
                this.identityPath = identityPath;
                this.coordsType = coordsType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                return Objects.equals(this.identityPath, key.identityPath) && Objects.equals(this.coordsType, key.coordsType);
            }

            public int hashCode() {
                return this.identityPath.hashCode() ^ this.coordsType.hashCode();
            }
        }
    }

    private static class ComponentWalker {
        private ComponentWalker() {
        }

        public static <T> void walkComponent(SoftwareComponent component, Map<SoftwareComponent, T> componentsMap, ComponentVisitor<T> visitor) {
            ComponentWalker.walkComponent(component, componentsMap, new LinkedHashSet<SoftwareComponent>(), new HashSet(), visitor);
        }

        private static <T> void walkComponent(SoftwareComponent component, Map<SoftwareComponent, T> componentCoordinates, Set<SoftwareComponent> componentsSeen, Set<T> coordinatesSeen, ComponentVisitor<T> visitor) {
            if (!componentsSeen.add(component)) {
                String allComponents = componentsSeen.stream().map(Named::getName).collect(Collectors.joining(", "));
                throw new InvalidUserDataException("Circular dependency detected while resolving component coordinates. Found the following components: " + allComponents);
            }
            T coordinates = componentCoordinates.get(component);
            if (!coordinatesSeen.add(coordinates)) {
                throw new InvalidUserDataException("Multiple child components may not share the same coordinates: " + coordinates);
            }
            if (component instanceof SoftwareComponentInternal) {
                SoftwareComponentInternal componentInternal = (SoftwareComponentInternal)component;
                for (SoftwareComponentVariant variant : componentInternal.getUsages()) {
                    visitor.visitVariant(variant, coordinates);
                }
            }
            if (component instanceof ComponentWithVariants) {
                ComponentWithVariants parent = (ComponentWithVariants)component;
                for (SoftwareComponent child : parent.getVariants()) {
                    ComponentWalker.walkComponent(child, componentCoordinates, componentsSeen, coordinatesSeen, visitor);
                }
            }
        }

        static interface ComponentVisitor<T> {
            public void visitVariant(SoftwareComponentVariant var1, T var2);
        }
    }

    private static class MultiCoordinateVariantResolver<T>
    implements VariantCoordinateResolver<T> {
        private final SoftwareComponent root;
        private final Map<SoftwareComponent, T> componentCoordinates;
        private final Lazy<Map<String, T>> variantCoordinatesMap;

        private MultiCoordinateVariantResolver(SoftwareComponent root, Path identityPath, Map<SoftwareComponent, T> componentCoordinates) {
            this.root = root;
            this.componentCoordinates = componentCoordinates;
            this.variantCoordinatesMap = Lazy.locking().of(() -> MultiCoordinateVariantResolver.mapVariantNamesToCoordinates(root, componentCoordinates, identityPath));
        }

        @Override
        public T getComponentCoordinates() {
            return this.componentCoordinates.get(this.root);
        }

        @Override
        @Nullable
        public T getVariantCoordinates(String resolvedVariant) {
            return (T)((Map)this.variantCoordinatesMap.get()).get(resolvedVariant);
        }

        private static <T> Map<String, T> mapVariantNamesToCoordinates(SoftwareComponent root, Map<SoftwareComponent, T> componentsMap, Path identityPath) {
            HashMap result = new HashMap();
            ComponentWalker.walkComponent(root, componentsMap, (variant, coordinates) -> {
                if (result.put(variant.getName(), coordinates) != null) {
                    throw new InvalidUserDataException(String.format("Found multiple variants with name '%s' in component '%s' of project '%s'", variant.getName(), root.getName(), identityPath));
                }
            });
            return result;
        }
    }

    private static interface VariantCoordinateResolver<T> {
        public T getComponentCoordinates();

        @Nullable
        public T getVariantCoordinates(String var1);

        public static <T> VariantCoordinateResolver<T> fixed(T coordinates) {
            return new FixedVariantCoordinateResolver(coordinates);
        }

        public static class FixedVariantCoordinateResolver<T>
        implements VariantCoordinateResolver<T> {
            private final T coordinates;

            private FixedVariantCoordinateResolver(T coordinates) {
                this.coordinates = coordinates;
            }

            @Override
            public T getComponentCoordinates() {
                return this.coordinates;
            }

            @Override
            public T getVariantCoordinates(String resolvedVariant) {
                return this.coordinates;
            }
        }
    }
}

