/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.InputArtifactDependencies;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.transform.DefaultTransformOutputs;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.properties.AbstractValidatingProperty;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputParameterUtils;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.InjectionPointQualifier;
import org.gradle.internal.Describables;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.properties.InputFilePropertyType;
import org.gradle.internal.properties.OutputFilePropertyType;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.internal.TextUtil;
import org.gradle.work.InputChanges;

public class DefaultTransform
implements Transform {
    private final Class<? extends TransformAction<?>> implementationClass;
    private final ImmutableAttributes fromAttributes;
    private final ImmutableAttributes toAttributes;
    private final FileNormalizer fileNormalizer;
    private final FileNormalizer dependenciesNormalizer;
    private final FileLookup fileLookup;
    private final ServiceLookup internalServices;
    private final boolean requiresDependencies;
    private final boolean requiresInputChanges;
    private final InstanceFactory<? extends TransformAction<?>> instanceFactory;
    private final boolean cacheable;
    private final CalculatedValueContainer<IsolatedParameters, IsolateTransformParameters> isolatedParameters;
    private final DirectorySensitivity artifactDirectorySensitivity;
    private final DirectorySensitivity dependenciesDirectorySensitivity;
    private final LineEndingSensitivity artifactLineEndingSensitivity;
    private final LineEndingSensitivity dependenciesLineEndingSensitivity;
    private static final String CACHEABLE_TRANSFORM_CANT_USE_ABSOLUTE_SENSITIVITY = "CACHEABLE_TRANSFORM_CANT_USE_ABSOLUTE_SENSITIVITY";
    private static final String ARTIFACT_TRANSFORM_SHOULD_NOT_DECLARE_OUTPUT = "ARTIFACT_TRANSFORM_SHOULD_NOT_DECLARE_OUTPUT";

    public DefaultTransform(Class<? extends TransformAction<?>> implementationClass, @Nullable TransformParameters parameterObject, ImmutableAttributes fromAttributes, ImmutableAttributes toAttributes, FileNormalizer inputArtifactNormalizer, FileNormalizer dependenciesNormalizer, boolean cacheable, DirectorySensitivity artifactDirectorySensitivity, DirectorySensitivity dependenciesDirectorySensitivity, LineEndingSensitivity artifactLineEndingSensitivity, LineEndingSensitivity dependenciesLineEndingSensitivity, BuildOperationRunner buildOperationRunner, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, IsolatableFactory isolatableFactory, FileCollectionFactory fileCollectionFactory, FileLookup fileLookup, PropertyWalker parameterPropertyWalker, InstantiationScheme actionInstantiationScheme, DomainObjectContext owner, CalculatedValueContainerFactory calculatedValueContainerFactory, ServiceLookup internalServices) {
        this.implementationClass = implementationClass;
        this.fromAttributes = fromAttributes;
        this.toAttributes = toAttributes;
        this.fileNormalizer = inputArtifactNormalizer;
        this.dependenciesNormalizer = dependenciesNormalizer;
        this.fileLookup = fileLookup;
        this.internalServices = internalServices;
        this.instanceFactory = actionInstantiationScheme.forType(implementationClass);
        this.requiresDependencies = this.instanceFactory.serviceInjectionTriggeredByAnnotation(InputArtifactDependencies.class);
        this.requiresInputChanges = this.instanceFactory.requiresService(InputChanges.class);
        this.cacheable = cacheable;
        this.artifactDirectorySensitivity = artifactDirectorySensitivity;
        this.dependenciesDirectorySensitivity = dependenciesDirectorySensitivity;
        this.artifactLineEndingSensitivity = artifactLineEndingSensitivity;
        this.dependenciesLineEndingSensitivity = dependenciesLineEndingSensitivity;
        this.isolatedParameters = calculatedValueContainerFactory.create(Describables.of((Object)"parameters of", (Object)this), (ValueCalculator)new IsolateTransformParameters(parameterObject, implementationClass, cacheable, owner, parameterPropertyWalker, isolatableFactory, buildOperationRunner, classLoaderHierarchyHasher, fileCollectionFactory, (InternalProblems)internalServices.get(InternalProblems.class)));
    }

    public DefaultTransform(Class<? extends TransformAction<?>> implementationClass, CalculatedValueContainer<IsolatedParameters, IsolateTransformParameters> isolatedParameters, ImmutableAttributes fromAttributes, ImmutableAttributes toAttributes, FileNormalizer inputArtifactNormalizer, FileNormalizer dependenciesNormalizer, boolean cacheable, FileLookup fileLookup, InstantiationScheme actionInstantiationScheme, ServiceLookup internalServices, DirectorySensitivity artifactDirectorySensitivity, DirectorySensitivity dependenciesDirectorySensitivity, LineEndingSensitivity artifactLineEndingSensitivity, LineEndingSensitivity dependenciesLineEndingSensitivity) {
        this.implementationClass = implementationClass;
        this.fromAttributes = fromAttributes;
        this.toAttributes = toAttributes;
        this.fileNormalizer = inputArtifactNormalizer;
        this.dependenciesNormalizer = dependenciesNormalizer;
        this.fileLookup = fileLookup;
        this.internalServices = internalServices;
        this.instanceFactory = actionInstantiationScheme.forType(implementationClass);
        this.requiresDependencies = this.instanceFactory.serviceInjectionTriggeredByAnnotation(InputArtifactDependencies.class);
        this.requiresInputChanges = this.instanceFactory.requiresService(InputChanges.class);
        this.cacheable = cacheable;
        this.isolatedParameters = isolatedParameters;
        this.artifactDirectorySensitivity = artifactDirectorySensitivity;
        this.dependenciesDirectorySensitivity = dependenciesDirectorySensitivity;
        this.artifactLineEndingSensitivity = artifactLineEndingSensitivity;
        this.dependenciesLineEndingSensitivity = dependenciesLineEndingSensitivity;
    }

    public static void validateInputFileNormalizer(String propertyName, @Nullable FileNormalizer normalizer, boolean cacheable, TypeValidationContext validationContext) {
        if (cacheable && normalizer == InputNormalizer.ABSOLUTE_PATH) {
            validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)CACHEABLE_TRANSFORM_CANT_USE_ABSOLUTE_SENSITIVITY), "Property declared to be sensitive to absolute paths", GradleCoreProblemGroup.validation().property()).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"cacheable_transform_cant_use_absolute_sensitivity")).contextualLabel("is declared to be sensitive to absolute paths").severity(Severity.ERROR).details("This is not allowed for cacheable transforms").solution("Use a different normalization strategy via @PathSensitive, @Classpath or @CompileClasspath"));
        }
    }

    @Override
    public FileNormalizer getInputArtifactNormalizer() {
        return this.fileNormalizer;
    }

    @Override
    public FileNormalizer getInputArtifactDependenciesNormalizer() {
        return this.dependenciesNormalizer;
    }

    @Override
    public boolean isIsolated() {
        return this.isolatedParameters.isFinalized();
    }

    @Override
    public boolean requiresDependencies() {
        return this.requiresDependencies;
    }

    @Override
    public boolean requiresInputChanges() {
        return this.requiresInputChanges;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public DirectorySensitivity getInputArtifactDirectorySensitivity() {
        return this.artifactDirectorySensitivity;
    }

    @Override
    public DirectorySensitivity getInputArtifactDependenciesDirectorySensitivity() {
        return this.dependenciesDirectorySensitivity;
    }

    @Override
    public LineEndingSensitivity getInputArtifactLineEndingNormalization() {
        return this.artifactLineEndingSensitivity;
    }

    @Override
    public LineEndingSensitivity getInputArtifactDependenciesLineEndingNormalization() {
        return this.dependenciesLineEndingSensitivity;
    }

    @Override
    public HashCode getSecondaryInputHash() {
        return ((IsolatedParameters)this.isolatedParameters.get()).getSecondaryInputsHash();
    }

    @Override
    public TransformExecutionResult transform(Provider<FileSystemLocation> inputArtifactProvider, File outputDir, TransformDependencies dependencies, @Nullable InputChanges inputChanges) {
        TransformAction<?> transformAction = this.newTransformAction(inputArtifactProvider, dependencies, inputChanges);
        DefaultTransformOutputs transformOutputs = new DefaultTransformOutputs(((FileSystemLocation)inputArtifactProvider.get()).getAsFile(), outputDir, this.fileLookup);
        transformAction.transform((TransformOutputs)transformOutputs);
        return transformOutputs.getRegisteredOutputs();
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add(this.isolatedParameters);
    }

    @Override
    public void isolateParametersIfNotAlready() {
        this.isolatedParameters.finalizeIfNotAlready();
    }

    private static void fingerprintParameters(InputFingerprinter inputFingerprinter, FileCollectionFactory fileCollectionFactory, PropertyWalker propertyWalker, Hasher hasher, Object parameterObject, boolean cacheable, InternalProblems problems) {
        final DefaultTypeValidationContext validationContext = DefaultTypeValidationContext.withoutRootType((boolean)cacheable, (InternalProblems)problems);
        InputFingerprinter.Result result = inputFingerprinter.fingerprintInputProperties(ImmutableSortedMap.of(), ImmutableSortedMap.of(), ImmutableSortedMap.of(), ImmutableSortedMap.of(), visitor -> propertyWalker.visitProperties(parameterObject, (TypeValidationContext)validationContext, new PropertyVisitor((UnitOfWork.InputVisitor)visitor, parameterObject, cacheable, fileCollectionFactory){
            final /* synthetic */ UnitOfWork.InputVisitor val$visitor;
            final /* synthetic */ Object val$parameterObject;
            final /* synthetic */ boolean val$cacheable;
            final /* synthetic */ FileCollectionFactory val$fileCollectionFactory;
            {
                this.val$visitor = inputVisitor;
                this.val$parameterObject = object;
                this.val$cacheable = bl;
                this.val$fileCollectionFactory = fileCollectionFactory;
            }

            public void visitInputProperty(String propertyName, PropertyValue value, boolean optional) {
                try {
                    Object preparedValue = InputParameterUtils.prepareInputParameterValue((Object)value);
                    if (preparedValue == null && !optional) {
                        AbstractValidatingProperty.reportValueNotSet((String)propertyName, (TypeValidationContext)validationContext, (boolean)true);
                    }
                    this.val$visitor.visitInputProperty(propertyName, () -> preparedValue);
                }
                catch (Throwable e) {
                    throw new InvalidUserDataException(String.format("Error while evaluating property '%s' of %s", propertyName, DefaultTransform.getParameterObjectDisplayName(this.val$parameterObject)), e);
                }
            }

            public void visitInputFileProperty(String propertyName, boolean optional, InputBehavior behavior, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingNormalization, @Nullable FileNormalizer normalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                DefaultTransform.validateInputFileNormalizer(propertyName, normalizer, this.val$cacheable, (TypeValidationContext)validationContext);
                this.val$visitor.visitInputFileProperty(propertyName, behavior, new UnitOfWork.InputFileValueSupplier((Object)value, (FileNormalizer)(normalizer == null ? InputNormalizer.ABSOLUTE_PATH : normalizer), directorySensitivity, lineEndingNormalization, () -> FileParameterUtils.resolveInputFileValue((FileCollectionFactory)this.val$fileCollectionFactory, (InputFilePropertyType)filePropertyType, (Object)value)));
            }

            public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
                validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)DefaultTransform.ARTIFACT_TRANSFORM_SHOULD_NOT_DECLARE_OUTPUT), "Artifact transform should not declare output", GradleCoreProblemGroup.validation().property()).contextualLabel("declares an output").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)DefaultTransform.ARTIFACT_TRANSFORM_SHOULD_NOT_DECLARE_OUTPUT.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("is annotated with an output annotation").solution("Remove the output property and use the TransformOutputs parameter from transform(TransformOutputs) instead"));
            }
        }));
        ImmutableList validationMessages = validationContext.getProblems();
        if (!validationMessages.isEmpty()) {
            throw new DefaultMultiCauseException(String.format(validationMessages.size() == 1 ? "A problem was found with the configuration of the artifact transform parameter %s." : "Some problems were found with the configuration of the artifact transform parameter %s.", DefaultTransform.getParameterObjectDisplayName(parameterObject)), (Iterable)validationMessages.stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
        }
        for (Map.Entry entry : result.getValueSnapshots().entrySet()) {
            hasher.putString((CharSequence)entry.getKey());
            ((ValueSnapshot)entry.getValue()).appendToHasher(hasher);
        }
        for (Map.Entry entry : result.getFileFingerprints().entrySet()) {
            hasher.putString((CharSequence)entry.getKey());
            hasher.putHash(((CurrentFileCollectionFingerprint)entry.getValue()).getHash());
        }
    }

    private static String getParameterObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }

    private TransformAction<?> newTransformAction(Provider<FileSystemLocation> inputArtifactProvider, TransformDependencies transformDependencies, @Nullable InputChanges inputChanges) {
        TransformParameters parameters = (TransformParameters)((IsolatedParameters)this.isolatedParameters.get()).getIsolatedParameterObject().isolate();
        ServiceLookup services = new IsolationScheme(TransformAction.class, TransformParameters.class, TransformParameters.None.class).servicesForImplementation((Object)parameters, this.internalServices);
        services = new TransformServiceLookup(inputArtifactProvider, this.requiresDependencies ? transformDependencies : null, inputChanges, services);
        return (TransformAction)this.instanceFactory.newInstance(services, new Object[0]);
    }

    public CalculatedValueContainer<IsolatedParameters, IsolateTransformParameters> getIsolatedParameters() {
        return this.isolatedParameters;
    }

    @Override
    public ImmutableAttributes getFromAttributes() {
        return this.fromAttributes;
    }

    @Override
    public ImmutableAttributes getToAttributes() {
        return this.toAttributes;
    }

    public Class<? extends TransformAction<?>> getImplementationClass() {
        return this.implementationClass;
    }

    public String getDisplayName() {
        return this.implementationClass.getSimpleName();
    }

    public static interface FingerprintTransformInputsOperation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }

    public static class IsolateTransformParameters
    implements ValueCalculator<IsolatedParameters> {
        private final TransformParameters parameterObject;
        private final DomainObjectContext owner;
        private final IsolatableFactory isolatableFactory;
        private final PropertyWalker parameterPropertyWalker;
        private final BuildOperationRunner buildOperationRunner;
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
        private final FileCollectionFactory fileCollectionFactory;
        private final boolean cacheable;
        private final Class<?> implementationClass;
        private final InternalProblems problems;

        public IsolateTransformParameters(@Nullable TransformParameters parameterObject, Class<?> implementationClass, boolean cacheable, DomainObjectContext owner, PropertyWalker parameterPropertyWalker, IsolatableFactory isolatableFactory, BuildOperationRunner buildOperationRunner, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, FileCollectionFactory fileCollectionFactory, InternalProblems problems) {
            this.parameterObject = parameterObject;
            this.implementationClass = implementationClass;
            this.cacheable = cacheable;
            this.owner = owner;
            this.parameterPropertyWalker = parameterPropertyWalker;
            this.isolatableFactory = isolatableFactory;
            this.buildOperationRunner = buildOperationRunner;
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
            this.fileCollectionFactory = fileCollectionFactory;
            this.problems = problems;
        }

        @Nullable
        public TransformParameters getParameterObject() {
            return this.parameterObject;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public Class<?> getImplementationClass() {
            return this.implementationClass;
        }

        public boolean usesMutableProjectState() {
            return this.owner.getProject() != null;
        }

        @Nullable
        public ProjectInternal getOwningProject() {
            return this.owner.getProject();
        }

        public void visitDependencies(final TaskDependencyResolveContext context) {
            if (this.parameterObject != null) {
                this.parameterPropertyWalker.visitProperties((Object)this.parameterObject, TypeValidationContext.NOOP, new PropertyVisitor(){

                    public void visitInputFileProperty(String propertyName, boolean optional, InputBehavior behavior, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, @Nullable FileNormalizer fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                        context.add((Object)value.getTaskDependencies());
                    }
                });
            }
        }

        public IsolatedParameters calculateValue(NodeExecutionContext context) {
            InputFingerprinter inputFingerprinter = (InputFingerprinter)context.getService(InputFingerprinter.class);
            return this.isolateParameters(inputFingerprinter);
        }

        private IsolatedParameters isolateParameters(InputFingerprinter inputFingerprinter) {
            ModelContainer model = this.owner.getModel();
            if (!model.hasMutableState()) {
                return (IsolatedParameters)model.forceAccessToMutableState(o -> this.doIsolateParameters(inputFingerprinter));
            }
            return this.doIsolateParameters(inputFingerprinter);
        }

        private IsolatedParameters doIsolateParameters(InputFingerprinter inputFingerprinter) {
            try {
                return this.isolateParametersExclusively(inputFingerprinter);
            }
            catch (Exception e) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Could not isolate parameters ").appendValue((Object)this.parameterObject).append((CharSequence)" of artifact transform ").appendType(this.implementationClass);
                throw new VariantTransformConfigurationException(formatter.toString(), (Throwable)e);
            }
        }

        private IsolatedParameters isolateParametersExclusively(final InputFingerprinter inputFingerprinter) {
            Isolatable isolatedParameterObject = this.isolatableFactory.isolate((Object)this.parameterObject);
            final Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.implementationClass.getName());
            hasher.putHash(this.classLoaderHierarchyHasher.getClassLoaderHash(this.implementationClass.getClassLoader()));
            if (this.parameterObject != null) {
                final TransformParameters isolatedTransformParameters = (TransformParameters)isolatedParameterObject.isolate();
                this.buildOperationRunner.run(new RunnableBuildOperation(){

                    public void run(BuildOperationContext context) {
                        DefaultTransform.fingerprintParameters(inputFingerprinter, fileCollectionFactory, parameterPropertyWalker, hasher, isolatedTransformParameters, cacheable, problems);
                        context.setResult((Object)FingerprintTransformInputsOperation.Result.INSTANCE);
                    }

                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName((String)"Fingerprint transform inputs").details((Object)FingerprintTransformInputsOperation.Details.INSTANCE);
                    }
                });
            }
            HashCode secondaryInputsHash = hasher.hash();
            return new IsolatedParameters((Isolatable<? extends TransformParameters>)isolatedParameterObject, secondaryInputsHash);
        }
    }

    public static class IsolatedParameters {
        private final HashCode secondaryInputsHash;
        private final Isolatable<? extends TransformParameters> isolatedParameterObject;

        public IsolatedParameters(Isolatable<? extends TransformParameters> isolatedParameterObject, HashCode secondaryInputsHash) {
            this.secondaryInputsHash = secondaryInputsHash;
            this.isolatedParameterObject = isolatedParameterObject;
        }

        public HashCode getSecondaryInputsHash() {
            return this.secondaryInputsHash;
        }

        public Isolatable<? extends TransformParameters> getIsolatedParameterObject() {
            return this.isolatedParameterObject;
        }
    }

    private static class TransformServiceLookup
    implements ServiceLookup {
        private static final Type FILE_SYSTEM_LOCATION_PROVIDER = new TypeToken<Provider<FileSystemLocation>>(){}.getType();
        private final ImmutableList<InjectionPoint> injectionPoints;
        private final ServiceLookup delegate;

        public TransformServiceLookup(Provider<FileSystemLocation> inputFileProvider, @Nullable TransformDependencies transformDependencies, @Nullable InputChanges inputChanges, ServiceLookup delegate) {
            this.delegate = delegate;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)InjectionPoint.injectedByAnnotation(InputArtifact.class, FILE_SYSTEM_LOCATION_PROVIDER, () -> inputFileProvider));
            if (transformDependencies != null) {
                builder.add((Object)InjectionPoint.injectedByAnnotation(InputArtifactDependencies.class, () -> transformDependencies.getFiles().orElseThrow(() -> new IllegalStateException("Transform does not use artifact dependencies."))));
            }
            if (inputChanges != null) {
                builder.add((Object)InjectionPoint.injectedByType(InputChanges.class, () -> inputChanges));
            }
            this.injectionPoints = builder.build();
        }

        @Nullable
        private Object find(Type serviceType, @Nullable Class<? extends Annotation> annotatedWith) {
            TypeToken serviceTypeToken = TypeToken.of((Type)serviceType);
            for (InjectionPoint injectionPoint : this.injectionPoints) {
                if (annotatedWith != injectionPoint.getAnnotation() || !serviceTypeToken.isSupertypeOf(injectionPoint.getInjectedType())) continue;
                return injectionPoint.getValueToInject();
            }
            return null;
        }

        @Nullable
        public Object find(Type serviceType) throws ServiceLookupException {
            Object result = this.find(serviceType, null);
            if (result != null) {
                return result;
            }
            return this.delegate.find(serviceType);
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType);
            if (result == null) {
                throw new UnknownServiceException(serviceType, "No service of type " + serviceType + " available.");
            }
            return result;
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType, annotatedWith);
            if (result != null) {
                return result;
            }
            return this.delegate.get(serviceType, annotatedWith);
        }

        private static class InjectionPoint {
            private final Class<? extends Annotation> annotation;
            private final Type injectedType;
            private final Supplier<Object> valueToInject;

            public static InjectionPoint injectedByAnnotation(Class<? extends Annotation> annotation, Supplier<Object> valueToInject) {
                return new InjectionPoint(annotation, InjectionPoint.determineTypeFromAnnotation(annotation), valueToInject);
            }

            public static InjectionPoint injectedByAnnotation(Class<? extends Annotation> annotation, Type injectedType, Supplier<Object> valueToInject) {
                return new InjectionPoint(annotation, injectedType, valueToInject);
            }

            public static InjectionPoint injectedByType(Class<?> injectedType, Supplier<Object> valueToInject) {
                return new InjectionPoint(null, injectedType, valueToInject);
            }

            private InjectionPoint(@Nullable Class<? extends Annotation> annotation, Type injectedType, Supplier<Object> valueToInject) {
                this.annotation = annotation;
                this.injectedType = injectedType;
                this.valueToInject = valueToInject;
            }

            private static Class<?> determineTypeFromAnnotation(Class<? extends Annotation> annotation) {
                Class[] supportedTypes = annotation.getAnnotation(InjectionPointQualifier.class).supportedTypes();
                if (supportedTypes.length != 1) {
                    throw new IllegalArgumentException("Cannot determine supported type for annotation " + annotation.getName());
                }
                return supportedTypes[0];
            }

            @Nullable
            public Class<? extends Annotation> getAnnotation() {
                return this.annotation;
            }

            public Type getInjectedType() {
                return this.injectedType;
            }

            public Object getValueToInject() {
                return this.valueToInject.get();
            }
        }
    }
}

