/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByNameException;
import org.gradle.internal.component.resolution.failure.type.ConfigurationDoesNotExistFailure;
import org.gradle.util.Path;

public abstract class ConfigurationDoesNotExistFailureDescriber
extends AbstractResolutionFailureDescriber<ConfigurationDoesNotExistFailure> {
    public VariantSelectionByNameException describeFailure(ConfigurationDoesNotExistFailure failure) {
        String message = this.buildFailureMsg(failure);
        ImmutableList.Builder resolutions = ImmutableList.builder();
        boolean isLocalComponent = failure.getTargetComponent() instanceof ProjectComponentIdentifier;
        if (isLocalComponent) {
            ProjectComponentIdentifierInternal id = (ProjectComponentIdentifierInternal)failure.getTargetComponent();
            Path outgoingVariantsPath = id.getIdentityPath().append(Path.path((String)"outgoingVariants"));
            resolutions.add((Object)("To determine which configurations are available in the target " + failure.getTargetComponent().getDisplayName() + ", run " + outgoingVariantsPath.getPath() + "."));
        }
        resolutions.addAll(this.buildResolutions(this.suggestReviewAlgorithm()));
        return new VariantSelectionByNameException(message, failure, (List<String>)resolutions.build());
    }

    private String buildFailureMsg(ConfigurationDoesNotExistFailure failure) {
        return String.format("A dependency was declared on configuration '%s' of '%s' but no variant with that configuration name exists.", failure.getRequestedConfigurationName(), failure.getTargetComponent().getDisplayName());
    }

    private String quoteNameOnly(String formattedId) {
        int projectIdIdx = formattedId.indexOf("project ");
        return projectIdIdx < 0 ? '\'' + formattedId + '\'' : formattedId.substring(0, projectIdIdx + 8) + '\'' + formattedId.substring(projectIdIdx + 8) + '\'';
    }
}

