/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.ide.visualstudio.TextProvider;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioSolution;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfigurationMetadata;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectMetadata;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioSolutionFile;
import org.gradle.internal.serialization.Cached;
import org.gradle.plugins.ide.api.GeneratorTask;
import org.gradle.plugins.ide.internal.generator.generator.PersistableConfigurationObjectGenerator;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class GenerateSolutionFileTask
extends GeneratorTask<VisualStudioSolutionFile> {
    private transient DefaultVisualStudioSolution solution;
    private final Provider<File> outputFile = this.getProject().provider(SerializableLambdas.callable((SerializableLambdas.SerializableCallable & Serializable)() -> this.solution.getSolutionFile().getLocation()));
    private final Cached<SolutionSpec> spec = Cached.of(this::calculateSpec);

    @Inject
    public GenerateSolutionFileTask(DefaultVisualStudioSolution solution) {
        this.generator = new ConfigurationObjectGenerator();
        this.setVisualStudioSolution(solution);
    }

    protected boolean getIncremental() {
        return true;
    }

    public void setVisualStudioSolution(VisualStudioSolution solution) {
        this.solution = (DefaultVisualStudioSolution)solution;
    }

    @Internal
    public VisualStudioSolution getSolution() {
        return this.solution;
    }

    @Nested
    @Incubating
    protected SolutionSpec getSpec() {
        return (SolutionSpec)this.spec.get();
    }

    @Internal
    public File getInputFile() {
        return null;
    }

    @OutputFile
    public File getOutputFile() {
        return (File)this.outputFile.get();
    }

    private SolutionSpec calculateSpec() {
        DefaultVisualStudioSolution solution = (DefaultVisualStudioSolution)this.getSolution();
        ArrayList<VisualStudioSolutionFile.ProjectSpec> projects = new ArrayList<VisualStudioSolutionFile.ProjectSpec>();
        for (VisualStudioProjectMetadata project : solution.getProjects()) {
            ArrayList<VisualStudioSolutionFile.ConfigurationSpec> configurations = new ArrayList<VisualStudioSolutionFile.ConfigurationSpec>();
            for (VisualStudioProjectConfigurationMetadata configuration : project.getConfigurations()) {
                configurations.add(new VisualStudioSolutionFile.ConfigurationSpec(configuration.getName(), configuration.isBuildable()));
            }
            projects.add(new VisualStudioSolutionFile.ProjectSpec(project.getName(), project.getFile(), configurations));
        }
        return new SolutionSpec(projects, solution.getSolutionFile().getTextActions());
    }

    @Incubating
    protected static class SolutionSpec {
        final List<VisualStudioSolutionFile.ProjectSpec> projects;
        final List<Action<? super TextProvider>> textActions;

        private SolutionSpec(List<VisualStudioSolutionFile.ProjectSpec> projects, List<Action<? super TextProvider>> textActions) {
            this.projects = projects;
            this.textActions = textActions;
        }

        @Nested
        @Incubating
        public List<VisualStudioSolutionFile.ProjectSpec> getProjects() {
            return this.projects;
        }

        @Nested
        @Incubating
        public List<Action<? super TextProvider>> getTextActions() {
            return this.textActions;
        }
    }

    private class ConfigurationObjectGenerator
    extends PersistableConfigurationObjectGenerator<VisualStudioSolutionFile> {
        private ConfigurationObjectGenerator() {
        }

        public VisualStudioSolutionFile create() {
            return new VisualStudioSolutionFile();
        }

        public void configure(VisualStudioSolutionFile solutionFile) {
            SolutionSpec spec = (SolutionSpec)GenerateSolutionFileTask.this.spec.get();
            solutionFile.setProjects(spec.projects);
            for (Action<? super TextProvider> textAction : spec.textActions) {
                solutionFile.getActions().add(textAction);
            }
        }
    }
}

