/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;
import org.gradle.util.internal.TextUtil;

public class LoggingConfigurationBuildOptions
extends BuildOptionSet<LoggingConfiguration> {
    private static List<BuildOption<LoggingConfiguration>> options = ImmutableList.of((Object)((Object)new LogLevelOption()), (Object)((Object)new StacktraceOption()), (Object)((Object)new ConsoleOption()), (Object)((Object)new WarningsOption()));

    public static List<BuildOption<LoggingConfiguration>> get() {
        return options;
    }

    public List<? extends BuildOption<? super LoggingConfiguration>> getAllOptions() {
        return options;
    }

    public Collection<String> getLongLogLevelOptions() {
        return ImmutableList.of((Object)"debug", (Object)"warn", (Object)"info", (Object)"quiet");
    }

    public static class WarningsOption
    extends StringBuildOption<LoggingConfiguration> {
        public static final String LONG_OPTION = "warning-mode";
        public static final String GRADLE_PROPERTY = "org.gradle.warning.mode";

        public WarningsOption() {
            super(GRADLE_PROPERTY, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Specifies which mode of warnings to generate. Values are 'all', 'fail', 'summary'(default) or 'none'")});
        }

        public void applyTo(String value, LoggingConfiguration settings, Origin origin) {
            try {
                settings.setWarningMode(WarningMode.valueOf((String)TextUtil.capitalize((String)value.toLowerCase(Locale.ROOT))));
            }
            catch (IllegalArgumentException e) {
                origin.handleInvalidValue(value);
            }
        }
    }

    public static class ConsoleOption
    extends StringBuildOption<LoggingConfiguration> {
        public static final String LONG_OPTION = "console";
        public static final String GRADLE_PROPERTY = "org.gradle.console";

        public ConsoleOption() {
            super(GRADLE_PROPERTY, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Specifies which type of console output to generate. Values are 'plain', 'auto' (default), 'rich' or 'verbose'.")});
        }

        public void applyTo(String value, LoggingConfiguration settings, Origin origin) {
            String consoleValue = TextUtil.capitalize((String)value.toLowerCase(Locale.ROOT));
            try {
                ConsoleOutput consoleOutput = ConsoleOutput.valueOf((String)consoleValue);
                settings.setConsoleOutput(consoleOutput);
            }
            catch (IllegalArgumentException e) {
                origin.handleInvalidValue(value);
            }
        }
    }

    public static class StacktraceOption
    extends AbstractBuildOption<LoggingConfiguration, CommandLineOptionConfiguration> {
        public static final String GRADLE_PROPERTY = "org.gradle.logging.stacktrace";
        public static final String STACKTRACE_LONG_OPTION = "stacktrace";
        public static final String STACKTRACE_SHORT_OPTION = "s";
        public static final String FULL_STACKTRACE_LONG_OPTION = "full-stacktrace";
        public static final String FULL_STACKTRACE_SHORT_OPTION = "S";
        private static final String[] ALL_SHORT_OPTIONS = new String[]{"s", "S"};

        public StacktraceOption() {
            super(GRADLE_PROPERTY, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)STACKTRACE_LONG_OPTION, (String)STACKTRACE_SHORT_OPTION, (String)"Print out the stacktrace for all exceptions."), CommandLineOptionConfiguration.create((String)FULL_STACKTRACE_LONG_OPTION, (String)FULL_STACKTRACE_SHORT_OPTION, (String)"Print out the full (very verbose) stacktrace for all exceptions.")});
        }

        public void applyFromProperty(Map<String, String> properties, LoggingConfiguration settings) {
            String value = properties.get(this.property);
            if (value != null) {
                if (value.equalsIgnoreCase("internal")) {
                    settings.setShowStacktrace(ShowStacktrace.INTERNAL_EXCEPTIONS);
                } else if (value.equalsIgnoreCase("all")) {
                    settings.setShowStacktrace(ShowStacktrace.ALWAYS);
                } else if (value.equalsIgnoreCase("full")) {
                    settings.setShowStacktrace(ShowStacktrace.ALWAYS_FULL);
                } else {
                    Origin.forGradleProperty((String)GRADLE_PROPERTY).handleInvalidValue(value, "must be one of internal, all, or full");
                }
            }
        }

        public void configure(CommandLineParser parser) {
            for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
                this.configureCommandLineOption(parser, config.getAllOptions(), config.getDescription(), config.isDeprecated(), config.isIncubating());
            }
            parser.allowOneOf(ALL_SHORT_OPTIONS);
        }

        public void applyFromCommandLine(ParsedCommandLine options, LoggingConfiguration settings) {
            if (options.hasOption(STACKTRACE_LONG_OPTION)) {
                settings.setShowStacktrace(ShowStacktrace.ALWAYS);
            } else if (options.hasOption(FULL_STACKTRACE_LONG_OPTION)) {
                settings.setShowStacktrace(ShowStacktrace.ALWAYS_FULL);
            }
        }
    }

    public static class LogLevelOption
    extends AbstractBuildOption<LoggingConfiguration, CommandLineOptionConfiguration> {
        public static final String GRADLE_PROPERTY = "org.gradle.logging.level";
        public static final String QUIET_LONG_OPTION = "quiet";
        public static final String QUIET_SHORT_OPTION = "q";
        public static final String WARN_LONG_OPTION = "warn";
        public static final String WARN_SHORT_OPTION = "w";
        public static final String INFO_LONG_OPTION = "info";
        public static final String INFO_SHORT_OPTION = "i";
        public static final String DEBUG_LONG_OPTION = "debug";
        public static final String DEBUG_SHORT_OPTION = "d";
        private static final String[] ALL_SHORT_OPTIONS = new String[]{"q", "w", "i", "d"};

        public LogLevelOption() {
            super(GRADLE_PROPERTY, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)QUIET_LONG_OPTION, (String)QUIET_SHORT_OPTION, (String)"Log errors only."), CommandLineOptionConfiguration.create((String)WARN_LONG_OPTION, (String)WARN_SHORT_OPTION, (String)"Set log level to warn."), CommandLineOptionConfiguration.create((String)INFO_LONG_OPTION, (String)INFO_SHORT_OPTION, (String)"Set log level to info."), CommandLineOptionConfiguration.create((String)DEBUG_LONG_OPTION, (String)DEBUG_SHORT_OPTION, (String)"Log in debug mode (includes normal stacktrace).")});
        }

        public void applyFromProperty(Map<String, String> properties, LoggingConfiguration settings) {
            String value = properties.get(this.property);
            if (value != null) {
                LogLevel level = LogLevelOption.parseLogLevel(value);
                settings.setLogLevel(level);
            }
        }

        public void configure(CommandLineParser parser) {
            for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
                this.configureCommandLineOption(parser, config.getAllOptions(), config.getDescription(), config.isDeprecated(), config.isIncubating());
            }
            parser.allowOneOf(ALL_SHORT_OPTIONS);
        }

        public void applyFromCommandLine(ParsedCommandLine options, LoggingConfiguration settings) {
            if (options.hasOption(QUIET_LONG_OPTION)) {
                settings.setLogLevel(LogLevel.QUIET);
            } else if (options.hasOption(WARN_LONG_OPTION)) {
                settings.setLogLevel(LogLevel.WARN);
            } else if (options.hasOption(INFO_LONG_OPTION)) {
                settings.setLogLevel(LogLevel.INFO);
            } else if (options.hasOption(DEBUG_LONG_OPTION)) {
                settings.setLogLevel(LogLevel.DEBUG);
            }
        }

        public static LogLevel parseLogLevel(String value) {
            try {
                LogLevel logLevel = LogLevel.valueOf((String)value.toUpperCase(Locale.ENGLISH));
                if (logLevel == LogLevel.ERROR) {
                    throw new IllegalArgumentException("Log level cannot be set to 'ERROR'.");
                }
                return logLevel;
            }
            catch (IllegalArgumentException e) {
                Origin.forGradleProperty((String)GRADLE_PROPERTY).handleInvalidValue(value, "must be one of quiet, warn, lifecycle, info, or debug)");
                return null;
            }
        }
    }
}

